/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.sso.agent.saml.artifact;

import java.io.IOException;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLContextBuilder;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicResponseHandler;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.opensaml.core.xml.XMLObjectBuilderFactory;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.soap.common.SOAPObjectBuilder;
import org.opensaml.soap.soap11.Body;
import org.opensaml.soap.soap11.Envelope;
import org.wso2.carbon.identity.sso.agent.exception.ArtifactResolutionException;

public class SAMLSSOSoapMessageService {
    private static final String CONTENT_TYPE = "text/xml; charset=utf-8";
    private static final String MIME_TYPE = "text/xml";
    private static final Log log = LogFactory.getLog(SAMLSSOSoapMessageService.class);

    public Envelope buildSOAPMessage(SAMLObject samlMessage) {
        XMLObjectBuilderFactory builderFactory = XMLObjectProviderRegistrySupport.getBuilderFactory();
        SOAPObjectBuilder envBuilder = (SOAPObjectBuilder)builderFactory.getBuilder(Envelope.DEFAULT_ELEMENT_NAME);
        Envelope envelope = (Envelope)envBuilder.buildObject();
        SOAPObjectBuilder bodyBuilder = (SOAPObjectBuilder)builderFactory.getBuilder(Body.DEFAULT_ELEMENT_NAME);
        Body body = (Body)bodyBuilder.buildObject();
        body.getUnknownXMLObjects().add(samlMessage);
        envelope.setBody(body);
        return envelope;
    }

    public String sendSOAP(String message, String url) throws ArtifactResolutionException {
        if (message == null) {
            throw new ArtifactResolutionException("Cannot send null SOAP message.");
        }
        if (url == null) {
            throw new ArtifactResolutionException("Cannot send SOAP message to null URL.");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Sending SOAP message to the URL: " + url));
        }
        StringBuilder soapResponse = new StringBuilder();
        try {
            HttpPost httpPost = new HttpPost(url);
            this.setRequestProperties(url, message, httpPost);
            HttpClient httpClient = this.getHttpClient();
            HttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpPost);
            int responseCode = httpResponse.getStatusLine().getStatusCode();
            if (responseCode != 200) {
                throw new ArtifactResolutionException("Problem in communicating with: " + url + ". Received response: " + responseCode);
            }
            log.info((Object)("Successful response from the URL: " + url));
            soapResponse.append(SAMLSSOSoapMessageService.getResponseBody(httpResponse));
        }
        catch (UnknownHostException e) {
            throw new ArtifactResolutionException("Unknown targeted host: " + url, e);
        }
        catch (IOException e) {
            throw new ArtifactResolutionException("Could not open connection with host: " + url, e);
        }
        return soapResponse.toString();
    }

    private void setRequestProperties(String url, String message, HttpPost httpPost) {
        httpPost.addHeader("Content-Type", CONTENT_TYPE);
        httpPost.addHeader("Accept", CONTENT_TYPE);
        String sbSOAPAction = "\"" + url + "\"";
        httpPost.addHeader("SOAPAction", sbSOAPAction);
        httpPost.addHeader("Pragma", "no-cache");
        httpPost.addHeader("Cache-Control", "no-cache, no-store");
        httpPost.setEntity((HttpEntity)new StringEntity(message, ContentType.create((String)MIME_TYPE, (Charset)StandardCharsets.UTF_8)));
    }

    private static String getResponseBody(HttpResponse response) throws ArtifactResolutionException {
        String responseBody;
        BasicResponseHandler responseHandler = new BasicResponseHandler();
        try {
            responseBody = (String)responseHandler.handleResponse(response);
        }
        catch (IOException e) {
            throw new ArtifactResolutionException("Error when retrieving the HTTP response body.", e);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Response Body:" + responseBody));
        }
        return responseBody;
    }

    private HttpClient getHttpClient() throws ArtifactResolutionException {
        CloseableHttpClient httpClient = null;
        SSLContextBuilder builder = new SSLContextBuilder();
        try {
            builder.loadTrustMaterial(null, (TrustStrategy)new TrustSelfSignedStrategy());
            SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(builder.build());
            httpClient = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf).build();
        }
        catch (KeyStoreException | NoSuchAlgorithmException e) {
            throw new ArtifactResolutionException("Error while building trust store.", e);
        }
        catch (KeyManagementException e) {
            throw new ArtifactResolutionException("Error while building socket factory.", e);
        }
        return httpClient;
    }
}

