/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.sso.agent.saml.artifact;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.UUID;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.joda.time.DateTime;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectBuilderFactory;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.common.SAMLObjectBuilder;
import org.opensaml.saml.common.SAMLVersion;
import org.opensaml.saml.saml2.core.Artifact;
import org.opensaml.saml.saml2.core.ArtifactResolve;
import org.opensaml.saml.saml2.core.ArtifactResponse;
import org.opensaml.saml.saml2.core.Issuer;
import org.opensaml.security.x509.X509Credential;
import org.opensaml.soap.soap11.Envelope;
import org.w3c.dom.Node;
import org.wso2.carbon.identity.sso.agent.bean.SSOAgentConfig;
import org.wso2.carbon.identity.sso.agent.exception.ArtifactResolutionException;
import org.wso2.carbon.identity.sso.agent.exception.SSOAgentException;
import org.wso2.carbon.identity.sso.agent.saml.artifact.SAMLSSOSoapMessageService;
import org.wso2.carbon.identity.sso.agent.security.X509CredentialImpl;
import org.wso2.carbon.identity.sso.agent.util.SSOAgentUtils;

public class SAMLSSOArtifactResolutionService {
    private static final Log log = LogFactory.getLog(SAMLSSOArtifactResolutionService.class);
    private SSOAgentConfig ssoAgentConfig;

    public SAMLSSOArtifactResolutionService(SSOAgentConfig ssoAgentConfig) {
        this.ssoAgentConfig = ssoAgentConfig;
    }

    public ArtifactResponse getSAMLArtifactResponse(String samlArtReceived) throws ArtifactResolutionException {
        this.validateArtifactResolveConfig();
        ArtifactResolve artifactResolve = this.generateArtifactResolveReq(samlArtReceived);
        return this.sendArtifactResolveRequest(artifactResolve);
    }

    public ArtifactResolve generateArtifactResolveReq(String samlArtReceived) throws ArtifactResolutionException {
        ArtifactResolve artifactResolve = this.createArtifactResolveObject(samlArtReceived);
        if (this.ssoAgentConfig.getSAML2().isEnableArtifactResolveSigning()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Signing artifact resolve request for the received SAML artifact: " + samlArtReceived));
            }
            artifactResolve = this.signArtifactResolveReq(artifactResolve);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Created Artifact Resolve object: " + artifactResolve));
        }
        return artifactResolve;
    }

    public ArtifactResponse sendArtifactResolveRequest(ArtifactResolve artifactResolve) throws ArtifactResolutionException {
        String envelopeElement;
        SAMLSSOSoapMessageService soapMessageService = new SAMLSSOSoapMessageService();
        Envelope envelope = soapMessageService.buildSOAPMessage((SAMLObject)artifactResolve);
        try {
            envelopeElement = SSOAgentUtils.marshall((XMLObject)envelope);
        }
        catch (SSOAgentException e) {
            throw new ArtifactResolutionException("Encountered error marshalling SOAP message with artifact resolve, into its DOM representation", (Throwable)((Object)e));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Artifact Resolve Request as a SOAP Message: " + envelopeElement));
        }
        String artifactResponseString = soapMessageService.sendSOAP(envelopeElement, this.ssoAgentConfig.getSAML2().getArtifactResolveURL());
        if (log.isDebugEnabled()) {
            log.debug((Object)("Received artifact response string: " + artifactResponseString));
        }
        ArtifactResponse artifactResponse = this.extractArtifactResponse(artifactResponseString);
        this.validateArtifactResponse(artifactResolve, artifactResponse);
        return artifactResponse;
    }

    public ArtifactResponse extractArtifactResponse(String artifactResponseString) throws ArtifactResolutionException {
        ArtifactResponse artifactResponse = null;
        ByteArrayInputStream stream = new ByteArrayInputStream(artifactResponseString.getBytes(StandardCharsets.UTF_8));
        try {
            MessageFactory messageFactory = MessageFactory.newInstance();
            SOAPMessage soapMessage = messageFactory.createMessage(new MimeHeaders(), (InputStream)stream);
            SOAPBody soapBody = soapMessage.getSOAPBody();
            Iterator iterator = soapBody.getChildElements();
            while (iterator.hasNext()) {
                SOAPBodyElement artifactResponseElement = (SOAPBodyElement)iterator.next();
                if (StringUtils.equals((String)"urn:oasis:names:tc:SAML:2.0:protocol", (String)artifactResponseElement.getNamespaceURI()) && StringUtils.equals((String)"ArtifactResponse", (String)artifactResponseElement.getLocalName())) {
                    DOMSource source = new DOMSource((Node)artifactResponseElement);
                    StringWriter stringResult = new StringWriter();
                    TransformerFactory.newInstance().newTransformer().transform(source, new StreamResult(stringResult));
                    artifactResponse = (ArtifactResponse)SSOAgentUtils.unmarshall(stringResult.toString());
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("Extracted Artifact Response: " + stringResult));
                    continue;
                }
                throw new ArtifactResolutionException("Received invalid artifact response with nameSpaceURI: " + artifactResponseElement.getNamespaceURI() + " and localName: " + artifactResponseElement.getLocalName());
            }
        }
        catch (IOException | SOAPException | TransformerException e) {
            throw new ArtifactResolutionException("Didn't receive valid artifact response.", e);
        }
        catch (SSOAgentException e) {
            throw new ArtifactResolutionException("Encountered error unmarshalling response into SAML2 object", (Throwable)((Object)e));
        }
        return artifactResponse;
    }

    private void validateArtifactResponse(ArtifactResolve artifactResolve, ArtifactResponse artifactResponse) throws ArtifactResolutionException {
        String artifactResponseInResponseTo;
        if (artifactResponse == null) {
            throw new ArtifactResolutionException("Received artifact response message was null.");
        }
        String artifactResolveId = artifactResolve.getID();
        if (!artifactResolveId.equals(artifactResponseInResponseTo = artifactResponse.getInResponseTo())) {
            throw new ArtifactResolutionException("Artifact resolve ID: " + artifactResolveId + " is not equal to artifact response InResponseTo : " + artifactResponseInResponseTo);
        }
        String artifactResponseStatus = artifactResponse.getStatus().getStatusCode().getValue();
        if (!"urn:oasis:names:tc:SAML:2.0:status:Success".equals(artifactResponseStatus)) {
            throw new ArtifactResolutionException("Unsuccessful artifact response with status: " + artifactResponseStatus);
        }
        SAMLObject message = artifactResponse.getMessage();
        if (message == null) {
            throw new ArtifactResolutionException("No SAML response embedded into the artifact response.");
        }
    }

    private void validateArtifactResolveConfig() throws ArtifactResolutionException {
        if (StringUtils.isEmpty((String)this.ssoAgentConfig.getSAML2().getArtifactResolveURL())) {
            throw new ArtifactResolutionException("Artifact Resolve Url is not configured.");
        }
        if (StringUtils.isEmpty((String)this.ssoAgentConfig.getSAML2().getSPEntityId())) {
            throw new ArtifactResolutionException("Artifact Resolve Issuer is not configured.");
        }
    }

    private ArtifactResolve createArtifactResolveObject(String samlArtReceived) {
        XMLObjectBuilderFactory builderFactory = XMLObjectProviderRegistrySupport.getBuilderFactory();
        SAMLObjectBuilder artifactResolveBuilder = (SAMLObjectBuilder)builderFactory.getBuilder(ArtifactResolve.DEFAULT_ELEMENT_NAME);
        ArtifactResolve artifactResolve = (ArtifactResolve)artifactResolveBuilder.buildObject();
        artifactResolve.setVersion(SAMLVersion.VERSION_20);
        artifactResolve.setID(UUID.randomUUID().toString());
        artifactResolve.setIssueInstant(new DateTime());
        SAMLObjectBuilder artifactBuilder = (SAMLObjectBuilder)builderFactory.getBuilder(Artifact.DEFAULT_ELEMENT_NAME);
        Artifact artifact = (Artifact)artifactBuilder.buildObject();
        artifact.setArtifact(samlArtReceived);
        SAMLObjectBuilder issuerBuilder = (SAMLObjectBuilder)builderFactory.getBuilder(Issuer.DEFAULT_ELEMENT_NAME);
        Issuer issuer = (Issuer)issuerBuilder.buildObject();
        issuer.setValue(this.ssoAgentConfig.getSAML2().getSPEntityId());
        artifactResolve.setIssuer(issuer);
        artifactResolve.setArtifact(artifact);
        return artifactResolve;
    }

    private ArtifactResolve signArtifactResolveReq(ArtifactResolve artifactResolve) throws ArtifactResolutionException {
        try {
            return SSOAgentUtils.setSignature(artifactResolve, "http://www.w3.org/2000/09/xmldsig#rsa-sha1", (X509Credential)new X509CredentialImpl(this.ssoAgentConfig.getSAML2().getSSOAgentX509Credential()));
        }
        catch (SSOAgentException e) {
            throw new ArtifactResolutionException("Error in signing the Artifact Resolve request", (Throwable)((Object)e));
        }
    }
}

