/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.sso.agent.saml;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import javax.crypto.SecretKey;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import net.shibboleth.utilities.java.support.codec.Base64Support;
import net.shibboleth.utilities.java.support.xml.SerializeSupport;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.io.Marshaller;
import org.opensaml.core.xml.io.MarshallerFactory;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.common.SAMLVersion;
import org.opensaml.saml.common.SignableSAMLObject;
import org.opensaml.saml.saml2.core.ArtifactResponse;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.Attribute;
import org.opensaml.saml.saml2.core.AttributeStatement;
import org.opensaml.saml.saml2.core.Audience;
import org.opensaml.saml.saml2.core.AudienceRestriction;
import org.opensaml.saml.saml2.core.AuthnContextClassRef;
import org.opensaml.saml.saml2.core.AuthnContextComparisonTypeEnumeration;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.opensaml.saml.saml2.core.AuthnStatement;
import org.opensaml.saml.saml2.core.Conditions;
import org.opensaml.saml.saml2.core.EncryptedAssertion;
import org.opensaml.saml.saml2.core.Extensions;
import org.opensaml.saml.saml2.core.Issuer;
import org.opensaml.saml.saml2.core.LogoutRequest;
import org.opensaml.saml.saml2.core.LogoutResponse;
import org.opensaml.saml.saml2.core.NameID;
import org.opensaml.saml.saml2.core.NameIDPolicy;
import org.opensaml.saml.saml2.core.RequestedAuthnContext;
import org.opensaml.saml.saml2.core.Response;
import org.opensaml.saml.saml2.core.SessionIndex;
import org.opensaml.saml.saml2.core.Status;
import org.opensaml.saml.saml2.core.StatusCode;
import org.opensaml.saml.saml2.core.StatusMessage;
import org.opensaml.saml.saml2.core.impl.AuthnContextClassRefBuilder;
import org.opensaml.saml.saml2.core.impl.AuthnRequestBuilder;
import org.opensaml.saml.saml2.core.impl.IssuerBuilder;
import org.opensaml.saml.saml2.core.impl.LogoutRequestBuilder;
import org.opensaml.saml.saml2.core.impl.LogoutResponseBuilder;
import org.opensaml.saml.saml2.core.impl.NameIDBuilder;
import org.opensaml.saml.saml2.core.impl.NameIDPolicyBuilder;
import org.opensaml.saml.saml2.core.impl.RequestedAuthnContextBuilder;
import org.opensaml.saml.saml2.core.impl.SessionIndexBuilder;
import org.opensaml.saml.saml2.core.impl.StatusBuilder;
import org.opensaml.saml.saml2.core.impl.StatusCodeBuilder;
import org.opensaml.saml.saml2.core.impl.StatusMessageBuilder;
import org.opensaml.saml.saml2.encryption.Decrypter;
import org.opensaml.saml.security.impl.SAMLSignatureProfileValidator;
import org.opensaml.security.credential.BasicCredential;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.CredentialSupport;
import org.opensaml.security.x509.X509Credential;
import org.opensaml.xmlsec.encryption.EncryptedKey;
import org.opensaml.xmlsec.keyinfo.KeyInfoCredentialResolver;
import org.opensaml.xmlsec.keyinfo.impl.StaticKeyInfoCredentialResolver;
import org.opensaml.xmlsec.signature.Signature;
import org.opensaml.xmlsec.signature.impl.SignatureImpl;
import org.opensaml.xmlsec.signature.support.SignatureException;
import org.opensaml.xmlsec.signature.support.SignatureValidator;
import org.owasp.encoder.Encode;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSSerializer;
import org.wso2.carbon.CarbonConstants;
import org.wso2.carbon.identity.sso.agent.bean.LoggedInSessionBean;
import org.wso2.carbon.identity.sso.agent.bean.SSOAgentConfig;
import org.wso2.carbon.identity.sso.agent.exception.ArtifactResolutionException;
import org.wso2.carbon.identity.sso.agent.exception.InvalidSessionException;
import org.wso2.carbon.identity.sso.agent.exception.SSOAgentException;
import org.wso2.carbon.identity.sso.agent.internal.SSOAgentServiceComponent;
import org.wso2.carbon.identity.sso.agent.saml.SAMLSignatureValidator;
import org.wso2.carbon.identity.sso.agent.saml.artifact.SAMLSSOArtifactResolutionService;
import org.wso2.carbon.identity.sso.agent.security.X509CredentialImpl;
import org.wso2.carbon.identity.sso.agent.session.management.SSOAgentSessionManager;
import org.wso2.carbon.identity.sso.agent.util.SSOAgentDataHolder;
import org.wso2.carbon.identity.sso.agent.util.SSOAgentUtils;
import org.wso2.carbon.user.api.UserRealm;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.user.core.UserStoreManager;

public class SAML2SSOManager {
    private static String DEFAULT_MULTI_ATTRIBUTE_SEPARATOR = ",";
    private static final Log log = LogFactory.getLog(SAML2SSOManager.class);
    private static final Logger LOGGER = Logger.getLogger("org.wso2.carbon.identity.sso.agent");
    private SSOAgentConfig ssoAgentConfig = null;

    public SAML2SSOManager(SSOAgentConfig ssoAgentConfig) throws SSOAgentException {
        this.ssoAgentConfig = ssoAgentConfig;
        String signerClassName = ssoAgentConfig.getSAML2().getSignatureValidatorImplClass();
        try {
            if (signerClassName != null) {
                SSOAgentDataHolder.getInstance().setSignatureValidator(Class.forName(signerClassName).newInstance());
            }
        }
        catch (ClassNotFoundException e) {
            throw new SSOAgentException("Error loading custom signature validator class", e);
        }
        catch (IllegalAccessException e) {
            throw new SSOAgentException("Error loading custom signature validator class", e);
        }
        catch (InstantiationException e) {
            throw new SSOAgentException("Error loading custom signature validator class", e);
        }
        SSOAgentUtils.doBootstrap();
    }

    public String buildRedirectRequest(HttpServletRequest request, boolean isLogout) throws SSOAgentException {
        AuthnRequest requestMessage = null;
        if (!isLogout) {
            requestMessage = this.buildAuthnRequest(request);
        } else {
            HttpSession httpSession = request.getSession(false);
            if (httpSession == null) {
                throw new InvalidSessionException("Session is expired or user already logged out.");
            }
            LoggedInSessionBean sessionBean = (LoggedInSessionBean)httpSession.getAttribute("org.wso2.carbon.identity.sso.agent.LoggedInSessionBean");
            if (sessionBean != null) {
                requestMessage = this.buildLogoutRequest(sessionBean.getSAML2SSO().getSubjectId(), sessionBean.getSAML2SSO().getSessionIndex());
            } else {
                throw new SSOAgentException("SLO Request can not be built. SSO Session is NULL");
            }
        }
        String idpUrl = null;
        String encodedRequestMessage = this.encodeRequestMessage((SignableSAMLObject)requestMessage, "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect");
        StringBuilder httpQueryString = new StringBuilder("SAMLRequest=" + encodedRequestMessage);
        String relayState = request.getParameter("RelayState");
        if (StringUtils.isNotEmpty((String)relayState)) {
            relayState = this.ssoAgentConfig.getSAML2().getRelayState();
        }
        if (relayState != null) {
            try {
                httpQueryString.append("&RelayState=" + URLEncoder.encode(relayState, "UTF-8").trim());
            }
            catch (UnsupportedEncodingException e) {
                throw new SSOAgentException("Error occurred while URLEncoding RelayState", e);
            }
        }
        if (this.ssoAgentConfig.getSAML2().isRequestSigned().booleanValue()) {
            SSOAgentUtils.addDeflateSignatureToHTTPQueryString(httpQueryString, new X509CredentialImpl(this.ssoAgentConfig.getSAML2().getSSOAgentX509Credential()));
        }
        if (this.ssoAgentConfig.getQueryParams() != null && !this.ssoAgentConfig.getQueryParams().isEmpty()) {
            StringBuilder builder = new StringBuilder();
            for (Map.Entry<String, String[]> entry : this.ssoAgentConfig.getQueryParams().entrySet()) {
                if (entry.getKey() == null || entry.getValue() == null || entry.getValue().length <= 0) continue;
                for (String param : entry.getValue()) {
                    try {
                        builder.append("&").append(entry.getKey()).append("=").append(URLEncoder.encode(param, "UTF-8"));
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new SSOAgentException("Error occurred while URLEncoding " + entry.getKey(), e);
                    }
                }
            }
            httpQueryString.append((CharSequence)builder);
        }
        idpUrl = this.ssoAgentConfig.getSAML2().getIdPURL().indexOf("?") > -1 ? this.ssoAgentConfig.getSAML2().getIdPURL().concat("&").concat(httpQueryString.toString()) : this.ssoAgentConfig.getSAML2().getIdPURL().concat("?").concat(httpQueryString.toString());
        return idpUrl;
    }

    public String buildPostRequest(HttpServletRequest request, HttpServletResponse response, boolean isLogout) throws SSOAgentException {
        AuthnRequest requestMessage = null;
        if (!isLogout) {
            requestMessage = this.buildAuthnRequest(request);
            if (this.ssoAgentConfig.getSAML2().isRequestSigned().booleanValue()) {
                requestMessage = SSOAgentUtils.setSignature(requestMessage, "http://www.w3.org/2000/09/xmldsig#rsa-sha1", (X509Credential)new X509CredentialImpl(this.ssoAgentConfig.getSAML2().getSSOAgentX509Credential()));
            }
        } else {
            HttpSession httpSession = request.getSession(false);
            if (httpSession == null) {
                throw new InvalidSessionException("Session is expired or user already logged out.");
            }
            LoggedInSessionBean sessionBean = (LoggedInSessionBean)httpSession.getAttribute("org.wso2.carbon.identity.sso.agent.LoggedInSessionBean");
            if (sessionBean != null) {
                requestMessage = this.buildLogoutRequest(sessionBean.getSAML2SSO().getSubjectId(), sessionBean.getSAML2SSO().getSessionIndex());
                if (this.ssoAgentConfig.getSAML2().isRequestSigned().booleanValue()) {
                    requestMessage = SSOAgentUtils.setSignature((LogoutRequest)requestMessage, "http://www.w3.org/2000/09/xmldsig#rsa-sha1", (X509Credential)new X509CredentialImpl(this.ssoAgentConfig.getSAML2().getSSOAgentX509Credential()));
                }
            } else {
                throw new SSOAgentException("SLO Request can not be built. SSO Session is null");
            }
        }
        String encodedRequestMessage = this.encodeRequestMessage((SignableSAMLObject)requestMessage, "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST");
        HashMap<String, String[]> paramsMap = new HashMap<String, String[]>();
        paramsMap.put("SAMLRequest", new String[]{encodedRequestMessage});
        String relayState = request.getParameter("RelayState");
        if (StringUtils.isNotEmpty((String)relayState)) {
            paramsMap.put("RelayState", new String[]{relayState});
        } else if (this.ssoAgentConfig.getSAML2().getRelayState() != null) {
            paramsMap.put("RelayState", new String[]{this.ssoAgentConfig.getSAML2().getRelayState()});
        }
        if (this.ssoAgentConfig.getQueryParams() != null && !this.ssoAgentConfig.getQueryParams().isEmpty()) {
            paramsMap.putAll(this.ssoAgentConfig.getQueryParams());
        }
        StringBuilder htmlParams = new StringBuilder();
        for (Map.Entry entry : paramsMap.entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null || ((String[])entry.getValue()).length <= 0) continue;
            for (String param : (String[])entry.getValue()) {
                htmlParams.append("<input type='hidden' name='").append((String)entry.getKey()).append("' value='").append(Encode.forHtmlAttribute((String)param)).append("'>\n");
            }
        }
        String htmlPayload = this.ssoAgentConfig.getSAML2().getPostBindingRequestHTMLPayload();
        htmlPayload = htmlPayload == null || !htmlPayload.contains("<!--$saml_params-->") ? "<html>\n<body>\n<p>You are now redirected back to " + this.ssoAgentConfig.getSAML2().getIdPURL() + " \nIf the redirection fails, please click the post button.</p>\n<form method='post' action='" + this.ssoAgentConfig.getSAML2().getIdPURL() + "'>\n<p>\n" + htmlParams.toString() + "<button type='submit'>POST</button>\n</p>\n</form>\n<script type='text/javascript'>\ndocument.forms[0].submit();\n</script>\n</body>\n</html>" : htmlPayload.replace("<!--$saml_params-->", htmlParams.toString());
        return htmlPayload;
    }

    public String buildPostResponse(SignableSAMLObject requestMessage) throws SSOAgentException {
        return this.encodeRequestMessage(requestMessage, "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST");
    }

    public void processResponse(HttpServletRequest request, HttpServletResponse response) throws SSOAgentException {
        String saml2SSOResponse = request.getParameter("SAMLResponse");
        if (saml2SSOResponse != null) {
            String decodedResponse = new String(Base64Support.decode((String)saml2SSOResponse), Charset.forName("UTF-8"));
            XMLObject samlObject = SSOAgentUtils.unmarshall(decodedResponse);
            if (samlObject instanceof LogoutResponse) {
                this.doSLO(request);
                request.setAttribute("shouldGoToWelcomePage", (Object)"true");
            } else {
                this.processSSOResponse(request);
            }
            String relayState = request.getParameter("RelayState");
            if (relayState != null && !relayState.isEmpty() && !"null".equalsIgnoreCase(relayState)) {
                this.ssoAgentConfig.getSAML2().setRelayState(relayState);
            }
        } else {
            throw new SSOAgentException("Invalid SAML2 Response. SAML2 Response can not be null.");
        }
    }

    public void processArtifactResponse(HttpServletRequest request) throws SSOAgentException {
        SAMLSSOArtifactResolutionService artifactResolutionService = new SAMLSSOArtifactResolutionService(this.ssoAgentConfig);
        try {
            ArtifactResponse artifactResponse = artifactResolutionService.getSAMLArtifactResponse(request.getParameter("SAMLart"));
            if (!StringUtils.equals((String)artifactResponse.getStatus().getStatusCode().getValue(), (String)"urn:oasis:names:tc:SAML:2.0:status:Success")) {
                throw new SSOAgentException("Received an invalid SAML response with status code: " + artifactResponse.getStatus().getStatusCode().getValue());
            }
            if (artifactResponse.getMessage() == null) {
                throw new SSOAgentException("Received SAML2 Artifact response message was null.");
            }
            SAMLObject xmlObject = artifactResponse.getMessage();
            if (!(xmlObject instanceof Response) && !(xmlObject instanceof LogoutResponse)) {
                throw new SSOAgentException("Received incorrect Artifact Response message with type: " + xmlObject.getClass());
            }
            this.validateSAMLResponseInArtifactResponse((XMLObject)xmlObject);
            this.executeSAMLResponse(request, (XMLObject)xmlObject);
        }
        catch (ArtifactResolutionException e) {
            throw new SSOAgentException("Error when getting the Artifact Response.", e);
        }
    }

    private void validateSAMLResponseInArtifactResponse(XMLObject response) throws SSOAgentException {
        NodeList responseList = response.getDOM().getElementsByTagNameNS("urn:oasis:names:tc:SAML:2.0:protocol", "Response");
        if (responseList != null && responseList.getLength() > 0) {
            throw new SSOAgentException("Error occurred while processing SAML2 response. Invalid schema for the SAML2 response. Multiple Response elements found.");
        }
        NodeList assertionList = response.getDOM().getElementsByTagNameNS("urn:oasis:names:tc:SAML:2.0:assertion", "Assertion");
        if (assertionList != null && assertionList.getLength() > 1) {
            throw new SSOAgentException("Error occurred while processing SAML2 response. Invalid schema for the SAML2 response. Multiple Assertion elements found.");
        }
    }

    private void executeSAMLResponse(HttpServletRequest request, XMLObject samlObject) throws SSOAgentException {
        if (samlObject instanceof LogoutResponse) {
            this.doSLO(request);
        } else if (samlObject instanceof Response) {
            this.processSSOResponse(request, (Response)samlObject);
        } else {
            throw new SSOAgentException("Unable to process unknown SAML object of type: " + samlObject.getClass());
        }
    }

    public LogoutResponse doSLO(HttpServletRequest request) throws SSOAgentException {
        XMLObject saml2Object = null;
        if (request.getParameter("SAMLRequest") != null) {
            saml2Object = SSOAgentUtils.unmarshall(new String(Base64Support.decode((String)request.getParameter("SAMLRequest")), Charset.forName("UTF-8")));
        }
        if (saml2Object == null) {
            saml2Object = SSOAgentUtils.unmarshall(new String(Base64Support.decode((String)request.getParameter("SAMLResponse")), Charset.forName("UTF-8")));
        }
        if (saml2Object instanceof LogoutRequest) {
            LogoutRequest logoutRequest = (LogoutRequest)saml2Object;
            String sessionIndex = ((SessionIndex)logoutRequest.getSessionIndexes().get(0)).getSessionIndex();
            Set<HttpSession> sessions = SSOAgentSessionManager.invalidateAllSessions(sessionIndex);
            for (HttpSession session : sessions) {
                session.invalidate();
            }
            return this.buildLogoutResponse(logoutRequest.getID(), "urn:oasis:names:tc:SAML:2.0:status:Success", null);
        }
        if (saml2Object instanceof LogoutResponse) {
            if (request.getSession(false) != null) {
                Set<HttpSession> sessions = SSOAgentSessionManager.invalidateAllSessions(request.getSession(false));
                for (HttpSession session : sessions) {
                    try {
                        session.invalidate();
                    }
                    catch (IllegalStateException ignore) {
                        if (!log.isDebugEnabled()) continue;
                        log.debug((Object)"Ignoring exception : ", (Throwable)ignore);
                    }
                }
            }
            return (LogoutResponse)saml2Object;
        }
        throw new SSOAgentException("Invalid SAML2 Single Logout Request/Response");
    }

    private void processSSOResponse(HttpServletRequest servletRequest) throws SSOAgentException {
        String saml2ResponseString = new String(Base64Support.decode((String)servletRequest.getParameter("SAMLResponse")), Charset.forName("UTF-8"));
        XMLObject response = SSOAgentUtils.unmarshall(saml2ResponseString);
        NodeList list = response.getDOM().getElementsByTagNameNS("urn:oasis:names:tc:SAML:2.0:protocol", "Response");
        if (list.getLength() > 0) {
            log.error((Object)"Invalid schema for the SAML2 response. Multiple Response elements found.");
            throw new SSOAgentException("Error occurred while processing SAML2 response.");
        }
        NodeList assertionList = response.getDOM().getElementsByTagNameNS("urn:oasis:names:tc:SAML:2.0:assertion", "Assertion");
        if (assertionList.getLength() > 1) {
            log.error((Object)"Invalid schema for the SAML2 response. Multiple Assertion elements found.");
            throw new SSOAgentException("Error occurred while processing SAML2 response.");
        }
        Response saml2Response = (Response)response;
        this.processSSOResponse(servletRequest, saml2Response);
    }

    private void processSSOResponse(HttpServletRequest servletRequest, Response saml2Response) throws SSOAgentException {
        LoggedInSessionBean sessionBean = new LoggedInSessionBean();
        sessionBean.setSAML2SSO(sessionBean.new LoggedInSessionBean.SAML2SSO());
        sessionBean.getSAML2SSO().setResponseString(saml2Response.toString());
        sessionBean.getSAML2SSO().setSAMLResponse(saml2Response);
        Assertion assertion = null;
        if (this.ssoAgentConfig.getSAML2().isAssertionEncrypted().booleanValue()) {
            List encryptedAssertions = saml2Response.getEncryptedAssertions();
            EncryptedAssertion encryptedAssertion = null;
            if (!CollectionUtils.isEmpty((Collection)encryptedAssertions)) {
                encryptedAssertion = (EncryptedAssertion)encryptedAssertions.get(0);
                try {
                    assertion = this.getDecryptedAssertion(encryptedAssertion);
                }
                catch (Exception e) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Assertion decryption failure : ", (Throwable)e);
                    }
                    throw new SSOAgentException("Unable to decrypt the SAML2 Assertion");
                }
            }
        } else {
            List assertions = saml2Response.getAssertions();
            if (assertions != null && !assertions.isEmpty()) {
                assertion = (Assertion)assertions.get(0);
            }
        }
        if (assertion == null) {
            if (this.isNoPassive(saml2Response)) {
                LOGGER.log(Level.FINE, "Cannot authenticate in passive mode");
                servletRequest.setAttribute("shouldGoToWelcomePage", (Object)"true");
                return;
            }
            throw new SSOAgentException("SAML2 Assertion not found in the Response");
        }
        String idPEntityIdValue = assertion.getIssuer().getValue();
        if (idPEntityIdValue == null || idPEntityIdValue.isEmpty()) {
            throw new SSOAgentException("SAML2 Response does not contain an Issuer value");
        }
        if (!idPEntityIdValue.equals(this.ssoAgentConfig.getSAML2().getIdPEntityId())) {
            throw new SSOAgentException("SAML2 Response Issuer verification failed");
        }
        sessionBean.getSAML2SSO().setAssertion(assertion);
        this.validateAssertionValidityPeriod(assertion);
        this.validateAudienceRestriction(assertion);
        this.validateSignature(saml2Response, assertion);
        String subject = null;
        if (assertion.getSubject() != null && assertion.getSubject().getNameID() != null) {
            subject = assertion.getSubject().getNameID().getValue();
        }
        if (subject == null) {
            throw new SSOAgentException("SAML2 Response does not contain the name of the subject");
        }
        sessionBean.getSAML2SSO().setSubjectId(subject);
        servletRequest.getSession().setAttribute("org.wso2.carbon.identity.sso.agent.LoggedInSessionBean", (Object)sessionBean);
        sessionBean.getSAML2SSO().setAssertionString(this.marshall((XMLObject)assertion));
        ((LoggedInSessionBean)servletRequest.getSession(false).getAttribute("org.wso2.carbon.identity.sso.agent.LoggedInSessionBean")).getSAML2SSO().setSubjectAttributes(this.getAssertionStatements(assertion));
        if (servletRequest.getSession(Boolean.FALSE.booleanValue()) != null) {
            HttpSession session = servletRequest.getSession(Boolean.FALSE.booleanValue());
            Enumeration attributeNames = session.getAttributeNames();
            HashMap<String, Object> sessionMap = new HashMap<String, Object>();
            while (attributeNames.hasMoreElements()) {
                String attributeName = (String)attributeNames.nextElement();
                sessionMap.put(attributeName, session.getAttribute(attributeName));
            }
            servletRequest.getSession(Boolean.FALSE.booleanValue()).invalidate();
            HttpSession newSession = servletRequest.getSession(Boolean.TRUE.booleanValue());
            for (Map.Entry entry : sessionMap.entrySet()) {
                newSession.setAttribute((String)entry.getKey(), entry.getValue());
            }
        }
        if (this.ssoAgentConfig.getSAML2().isSLOEnabled().booleanValue()) {
            String sessionId = ((AuthnStatement)assertion.getAuthnStatements().get(0)).getSessionIndex();
            if (sessionId == null) {
                throw new SSOAgentException("Single Logout is enabled but IdP Session ID not found in SAML2 Assertion");
            }
            ((LoggedInSessionBean)servletRequest.getSession(false).getAttribute("org.wso2.carbon.identity.sso.agent.LoggedInSessionBean")).getSAML2SSO().setSessionIndex(sessionId);
            SSOAgentSessionManager.addAuthenticatedSession(servletRequest.getSession(false));
        }
        servletRequest.getSession(false).setAttribute("org.wso2.carbon.identity.sso.agent.LoggedInSessionBean", (Object)sessionBean);
    }

    protected LogoutRequest buildLogoutRequest(String user, String sessionIdx) throws SSOAgentException {
        LogoutRequest logoutReq = new LogoutRequestBuilder().buildObject();
        logoutReq.setID(SSOAgentUtils.createID());
        logoutReq.setDestination(this.ssoAgentConfig.getSAML2().getIdPURL());
        DateTime issueInstant = new DateTime();
        logoutReq.setIssueInstant(issueInstant);
        logoutReq.setNotOnOrAfter(new DateTime(issueInstant.getMillis() + 300000L));
        IssuerBuilder issuerBuilder = new IssuerBuilder();
        Issuer issuer = issuerBuilder.buildObject();
        issuer.setValue(this.ssoAgentConfig.getSAML2().getSPEntityId());
        logoutReq.setIssuer(issuer);
        NameID nameId = new NameIDBuilder().buildObject();
        nameId.setFormat("urn:oasis:names:tc:SAML:2.0:nameid-format:entity");
        nameId.setValue(user);
        logoutReq.setNameID(nameId);
        SessionIndex sessionIndex = new SessionIndexBuilder().buildObject();
        sessionIndex.setSessionIndex(sessionIdx);
        logoutReq.getSessionIndexes().add(sessionIndex);
        logoutReq.setReason("Single Logout");
        return logoutReq;
    }

    public LogoutResponse buildLogoutResponse(String id, String status, String statMsg) throws SSOAgentException {
        LogoutResponse logoutResp = new LogoutResponseBuilder().buildObject();
        logoutResp.setID(SSOAgentUtils.createID());
        logoutResp.setInResponseTo(id);
        IssuerBuilder issuerBuilder = new IssuerBuilder();
        Issuer issuer = issuerBuilder.buildObject();
        issuer.setValue(this.ssoAgentConfig.getSAML2().getSPEntityId());
        logoutResp.setIssuer(issuer);
        logoutResp.setStatus(this.buildStatus(status, statMsg));
        logoutResp.setIssueInstant(new DateTime());
        logoutResp.setDestination(this.ssoAgentConfig.getSAML2().getIdPURL());
        SSOAgentUtils.setSignatureValue(logoutResp, "http://www.w3.org/2000/09/xmldsig#rsa-sha1", new X509CredentialImpl(this.ssoAgentConfig.getSAML2().getSSOAgentX509Credential()));
        return logoutResp;
    }

    protected AuthnRequest buildAuthnRequest(HttpServletRequest request) throws SSOAgentException {
        IssuerBuilder issuerBuilder = new IssuerBuilder();
        Issuer issuer = issuerBuilder.buildObject("urn:oasis:names:tc:SAML:2.0:assertion", "Issuer", "samlp");
        issuer.setValue(this.ssoAgentConfig.getSAML2().getSPEntityId());
        NameIDPolicyBuilder nameIdPolicyBuilder = new NameIDPolicyBuilder();
        NameIDPolicy nameIdPolicy = nameIdPolicyBuilder.buildObject();
        nameIdPolicy.setFormat("urn:oasis:names:tc:SAML:2.0:nameid-format:persistent");
        nameIdPolicy.setSPNameQualifier("Issuer");
        nameIdPolicy.setAllowCreate(Boolean.valueOf(true));
        AuthnContextClassRefBuilder authnContextClassRefBuilder = new AuthnContextClassRefBuilder();
        AuthnContextClassRef authnContextClassRef = authnContextClassRefBuilder.buildObject("urn:oasis:names:tc:SAML:2.0:assertion", "AuthnContextClassRef", "saml");
        authnContextClassRef.setAuthnContextClassRef("urn:oasis:names:tc:SAML:2.0:ac:classes:PasswordProtectedTransport");
        RequestedAuthnContextBuilder requestedAuthnContextBuilder = new RequestedAuthnContextBuilder();
        RequestedAuthnContext requestedAuthnContext = requestedAuthnContextBuilder.buildObject();
        requestedAuthnContext.setComparison(AuthnContextComparisonTypeEnumeration.EXACT);
        requestedAuthnContext.getAuthnContextClassRefs().add(authnContextClassRef);
        DateTime issueInstant = new DateTime();
        AuthnRequestBuilder authRequestBuilder = new AuthnRequestBuilder();
        AuthnRequest authRequest = authRequestBuilder.buildObject("urn:oasis:names:tc:SAML:2.0:protocol", "AuthnRequest", "samlp");
        authRequest.setForceAuthn(this.ssoAgentConfig.getSAML2().isForceAuthn());
        authRequest.setIsPassive(this.ssoAgentConfig.getSAML2().isPassiveAuthn());
        authRequest.setIssueInstant(issueInstant);
        authRequest.setProtocolBinding(this.ssoAgentConfig.getSAML2().getHttpBinding());
        authRequest.setAssertionConsumerServiceURL(this.ssoAgentConfig.getSAML2().getACSURL());
        authRequest.setIssuer(issuer);
        authRequest.setNameIDPolicy(nameIdPolicy);
        authRequest.setRequestedAuthnContext(requestedAuthnContext);
        authRequest.setID(SSOAgentUtils.createID());
        authRequest.setVersion(SAMLVersion.VERSION_20);
        authRequest.setDestination(this.ssoAgentConfig.getSAML2().getIdPURL());
        if (request.getAttribute("Extensions") != null) {
            authRequest.setExtensions((Extensions)request.getAttribute("Extensions"));
        }
        if (this.ssoAgentConfig.getSAML2().getAttributeConsumingServiceIndex() != null && this.ssoAgentConfig.getSAML2().getAttributeConsumingServiceIndex().trim().length() > 0) {
            authRequest.setAttributeConsumingServiceIndex(Integer.valueOf(Integer.parseInt(this.ssoAgentConfig.getSAML2().getAttributeConsumingServiceIndex())));
        }
        return authRequest;
    }

    protected String encodeRequestMessage(SignableSAMLObject requestMessage, String binding) throws SSOAgentException {
        Marshaller marshaller = XMLObjectProviderRegistrySupport.getMarshallerFactory().getMarshaller((XMLObject)requestMessage);
        Element authDOM = null;
        try {
            authDOM = marshaller.marshall((XMLObject)requestMessage);
            StringWriter rspWrt = new StringWriter();
            rspWrt.write(SerializeSupport.nodeToString((Node)authDOM));
            if ("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect".equals(binding)) {
                Deflater deflater = new Deflater(8, true);
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream((OutputStream)byteArrayOutputStream, deflater);
                deflaterOutputStream.write(rspWrt.toString().getBytes(Charset.forName("UTF-8")));
                deflaterOutputStream.close();
                String encodedRequestMessage = Base64Support.encode((byte[])byteArrayOutputStream.toByteArray(), (boolean)false);
                return URLEncoder.encode(encodedRequestMessage, "UTF-8").trim();
            }
            if ("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST".equals(binding)) {
                return Base64Support.encode((byte[])rspWrt.toString().getBytes(), (boolean)false);
            }
            LOGGER.log(Level.FINE, "Unsupported SAML2 HTTP Binding. Defaulting to urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST");
            return Base64Support.encode((byte[])rspWrt.toString().getBytes(), (boolean)false);
        }
        catch (MarshallingException e) {
            throw new SSOAgentException("Error occurred while encoding SAML2 request", e);
        }
        catch (UnsupportedEncodingException e) {
            throw new SSOAgentException("Error occurred while encoding SAML2 request", e);
        }
        catch (IOException e) {
            throw new SSOAgentException("Error occurred while encoding SAML2 request", e);
        }
    }

    private Map<String, String> getAssertionStatements(Assertion assertion) {
        HashMap<String, String> results = new HashMap<String, String>();
        String multiAttributeSeparator = DEFAULT_MULTI_ATTRIBUTE_SEPARATOR;
        try {
            if (SSOAgentServiceComponent.getRealmService() != null) {
                UserRealm realm = SSOAgentServiceComponent.getRealmService().getTenantUserRealm(-1234);
                UserStoreManager userStoreManager = (UserStoreManager)realm.getUserStoreManager();
                multiAttributeSeparator = userStoreManager.getRealmConfiguration().getUserStoreProperty("MultiAttributeSeparator");
            }
        }
        catch (UserStoreException e) {
            log.warn((Object)"Error while reading MultiAttributeSeparator value from primary user store ", (Throwable)e);
        }
        if (assertion != null && assertion.getAttributeStatements() != null) {
            List attributeStatementList = assertion.getAttributeStatements();
            for (AttributeStatement statement : attributeStatementList) {
                List attributesList = statement.getAttributes();
                for (Attribute attribute : attributesList) {
                    List multipleAttributeValues = attribute.getAttributeValues();
                    if (!CollectionUtils.isNotEmpty((Collection)multipleAttributeValues)) continue;
                    ArrayList<String> valueList = new ArrayList<String>();
                    for (XMLObject attributeVal : multipleAttributeValues) {
                        Element value = attributeVal.getDOM();
                        valueList.add(value.getTextContent());
                    }
                    String attributeValue = StringUtils.join(valueList.iterator(), (String)multiAttributeSeparator);
                    results.put(attribute.getName(), attributeValue);
                }
            }
        }
        return results;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void validateAudienceRestriction(Assertion assertion) throws SSOAgentException {
        if (assertion == null) return;
        Conditions conditions = assertion.getConditions();
        if (conditions == null) throw new SSOAgentException("SAML2 Response doesn't contain Conditions");
        List audienceRestrictions = conditions.getAudienceRestrictions();
        if (audienceRestrictions == null) throw new SSOAgentException("SAML2 Response doesn't contain AudienceRestrictions");
        if (audienceRestrictions.isEmpty()) throw new SSOAgentException("SAML2 Response doesn't contain AudienceRestrictions");
        boolean audienceFound = false;
        for (AudienceRestriction audienceRestriction : audienceRestrictions) {
            if (audienceRestriction.getAudiences() != null && !audienceRestriction.getAudiences().isEmpty()) {
                for (Audience audience : audienceRestriction.getAudiences()) {
                    if (!this.ssoAgentConfig.getSAML2().getSPEntityId().equals(audience.getAudienceURI())) continue;
                    return;
                }
            }
            if (!audienceFound) continue;
            break;
        }
        if (audienceFound) return;
        throw new SSOAgentException("SAML2 Assertion Audience Restriction validation failed");
    }

    protected void validateSignature(Response response, Assertion assertion) throws SSOAgentException {
        if (SSOAgentDataHolder.getInstance().getSignatureValidator() != null) {
            SAMLSignatureValidator signatureValidatorUtility = (SAMLSignatureValidator)SSOAgentDataHolder.getInstance().getSignatureValidator();
            signatureValidatorUtility.validateSignature(response, assertion, this.ssoAgentConfig);
        } else {
            if (this.ssoAgentConfig.getSAML2().isResponseSigned().booleanValue()) {
                if (response.getSignature() == null) {
                    throw new SSOAgentException("SAML2 Response signing is enabled, but signature element not found in SAML2 Response element");
                }
                this.validateSignature((XMLObject)response.getSignature());
            }
            if (this.ssoAgentConfig.getSAML2().isAssertionSigned().booleanValue()) {
                if (assertion.getSignature() == null) {
                    throw new SSOAgentException("SAML2 Assertion signing is enabled, but signature element not found in SAML2 Assertion element");
                }
                this.validateSignature((XMLObject)assertion.getSignature());
            }
        }
    }

    protected String marshall(XMLObject xmlObject) throws SSOAgentException {
        try {
            System.setProperty("javax.xml.parsers.DocumentBuilderFactory", "org.apache.xerces.jaxp.DocumentBuilderFactoryImpl");
            MarshallerFactory marshallerFactory = XMLObjectProviderRegistrySupport.getMarshallerFactory();
            Marshaller marshaller = marshallerFactory.getMarshaller(xmlObject);
            Element element = marshaller.marshall(xmlObject);
            ByteArrayOutputStream byteArrayOutputStrm = new ByteArrayOutputStream();
            DOMImplementationRegistry registry = DOMImplementationRegistry.newInstance();
            DOMImplementationLS impl = (DOMImplementationLS)((Object)registry.getDOMImplementation("LS"));
            LSSerializer writer = impl.createLSSerializer();
            LSOutput output = impl.createLSOutput();
            output.setByteStream(byteArrayOutputStrm);
            writer.write(element, output);
            return new String(byteArrayOutputStrm.toByteArray(), Charset.forName("UTF-8"));
        }
        catch (ClassNotFoundException e) {
            throw new SSOAgentException("Error in marshalling SAML2 Assertion", e);
        }
        catch (InstantiationException e) {
            throw new SSOAgentException("Error in marshalling SAML2 Assertion", e);
        }
        catch (MarshallingException e) {
            throw new SSOAgentException("Error in marshalling SAML2 Assertion", e);
        }
        catch (IllegalAccessException e) {
            throw new SSOAgentException("Error in marshalling SAML2 Assertion", e);
        }
    }

    protected Assertion getDecryptedAssertion(EncryptedAssertion encryptedAssertion) throws SSOAgentException {
        try {
            StaticKeyInfoCredentialResolver keyResolver = new StaticKeyInfoCredentialResolver((Credential)new X509CredentialImpl(this.ssoAgentConfig.getSAML2().getSSOAgentX509Credential()));
            EncryptedKey key = (EncryptedKey)encryptedAssertion.getEncryptedData().getKeyInfo().getEncryptedKeys().get(0);
            Decrypter decrypter = new Decrypter(null, (KeyInfoCredentialResolver)keyResolver, null);
            SecretKey dkey = (SecretKey)decrypter.decryptKey(key, encryptedAssertion.getEncryptedData().getEncryptionMethod().getAlgorithm());
            BasicCredential shared = CredentialSupport.getSimpleCredential((SecretKey)dkey);
            decrypter = new Decrypter((KeyInfoCredentialResolver)new StaticKeyInfoCredentialResolver((Credential)shared), null, null);
            decrypter.setRootInNewDocument(true);
            return decrypter.decrypt(encryptedAssertion);
        }
        catch (Exception e) {
            throw new SSOAgentException("Decrypted assertion error", e);
        }
    }

    protected boolean isNoPassive(Response response) {
        return response.getStatus() != null && response.getStatus().getStatusCode() != null && response.getStatus().getStatusCode().getValue().equals("urn:oasis:names:tc:SAML:2.0:status:Responder") && response.getStatus().getStatusCode().getStatusCode() != null && response.getStatus().getStatusCode().getStatusCode().getValue().equals("urn:oasis:names:tc:SAML:2.0:status:NoPassive");
    }

    public SSOAgentConfig getSsoAgentConfig() {
        return this.ssoAgentConfig;
    }

    private void validateAssertionValidityPeriod(Assertion assertion) throws SSOAgentException {
        if (assertion.getConditions() != null) {
            int timeStampSkewInSeconds = this.ssoAgentConfig.getSAML2().getTimeStampSkewInSeconds();
            DateTime validFrom = assertion.getConditions().getNotBefore();
            DateTime validTill = assertion.getConditions().getNotOnOrAfter();
            if (validFrom != null && validFrom.minusSeconds(timeStampSkewInSeconds).isAfterNow()) {
                throw new SSOAgentException("Failed to meet SAML Assertion Condition 'Not Before'");
            }
            if (validTill != null && validTill.plusSeconds(timeStampSkewInSeconds).isBeforeNow()) {
                throw new SSOAgentException("Failed to meet SAML Assertion Condition 'Not On Or After'");
            }
            if (validFrom != null && validTill != null && validFrom.isAfter((ReadableInstant)validTill)) {
                throw new SSOAgentException("SAML Assertion Condition 'Not Before' must be less than the value of 'Not On Or After'");
            }
        }
    }

    private void validateSignature(XMLObject signature) throws SSOAgentException {
        SignatureImpl signImpl = (SignatureImpl)signature;
        try {
            SAMLSignatureProfileValidator signatureProfileValidator = new SAMLSignatureProfileValidator();
            signatureProfileValidator.validate((Signature)signImpl);
        }
        catch (SignatureException ex) {
            String logMsg = "Signature do not confirm to SAML signature profile. Possible XML Signature Wrapping  Attack!";
            CarbonConstants.AUDIT_LOG.warn((Object)logMsg);
            if (log.isDebugEnabled()) {
                log.debug((Object)logMsg, (Throwable)ex);
            }
            throw new SSOAgentException(logMsg, ex);
        }
        try {
            SignatureValidator.validate((Signature)signImpl, (Credential)new X509CredentialImpl(this.ssoAgentConfig.getSAML2().getSSOAgentX509Credential()));
        }
        catch (SignatureException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Validation exception : ", (Throwable)e);
            }
            throw new SSOAgentException("Signature validation failed for SAML2 Element");
        }
    }

    private Status buildStatus(String status, String statMsg) {
        Status stat = new StatusBuilder().buildObject();
        StatusCode statCode = new StatusCodeBuilder().buildObject();
        statCode.setValue(status);
        stat.setStatusCode(statCode);
        if (statMsg != null) {
            StatusMessage statMesssage = new StatusMessageBuilder().buildObject();
            statMesssage.setMessage(statMsg);
            stat.setStatusMessage(statMesssage);
        }
        return stat;
    }
}

