/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.sso.agent.openid;

import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.MapUtils;
import org.openid4java.association.AssociationException;
import org.openid4java.consumer.ConsumerException;
import org.openid4java.consumer.ConsumerManager;
import org.openid4java.consumer.VerificationResult;
import org.openid4java.discovery.Discovery;
import org.openid4java.discovery.DiscoveryException;
import org.openid4java.discovery.DiscoveryInformation;
import org.openid4java.discovery.Identifier;
import org.openid4java.discovery.yadis.YadisException;
import org.openid4java.discovery.yadis.YadisResolver;
import org.openid4java.message.AuthRequest;
import org.openid4java.message.AuthSuccess;
import org.openid4java.message.MessageException;
import org.openid4java.message.MessageExtension;
import org.openid4java.message.ParameterList;
import org.openid4java.message.ax.FetchRequest;
import org.openid4java.message.ax.FetchResponse;
import org.openid4java.server.RealmVerifierFactory;
import org.openid4java.util.HttpFetcherFactory;
import org.wso2.carbon.identity.sso.agent.bean.LoggedInSessionBean;
import org.wso2.carbon.identity.sso.agent.bean.SSOAgentConfig;
import org.wso2.carbon.identity.sso.agent.exception.SSOAgentException;
import org.wso2.carbon.identity.sso.agent.openid.AttributesRequestor;
import org.wso2.carbon.identity.sso.agent.util.SSOAgentDataHolder;

public class OpenIDManager {
    AttributesRequestor attributesRequestor = null;
    private SSOAgentConfig ssoAgentConfig = null;

    public OpenIDManager(SSOAgentConfig ssoAgentConfig) throws SSOAgentException {
        SSOAgentDataHolder.getInstance().setConsumerManager(this.getConsumerManagerInstance());
        this.ssoAgentConfig = ssoAgentConfig;
    }

    private ConsumerManager getConsumerManagerInstance() throws SSOAgentException {
        HttpFetcherFactory httpFetcherFactory = null;
        try {
            httpFetcherFactory = new HttpFetcherFactory(SSLContext.getDefault(), null);
        }
        catch (NoSuchAlgorithmException e) {
            throw new SSOAgentException("Error while getting default SSL Context", e);
        }
        return new ConsumerManager(new RealmVerifierFactory(new YadisResolver(httpFetcherFactory)), new Discovery(), httpFetcherFactory);
    }

    public String doOpenIDLogin(HttpServletRequest request, HttpServletResponse response) throws SSOAgentException {
        String claimedId = this.ssoAgentConfig.getOpenId().getClaimedId();
        try {
            ConsumerManager manager = SSOAgentDataHolder.getInstance().getConsumerManager();
            if (this.ssoAgentConfig.getOpenId().isDumbModeEnabled()) {
                manager.setMaxAssocAttempts(0);
            }
            List discoveries = manager.discover(claimedId);
            DiscoveryInformation discovered = manager.associate(discoveries);
            LoggedInSessionBean sessionBean = new LoggedInSessionBean();
            sessionBean.setOpenId(sessionBean.new LoggedInSessionBean.OpenID());
            sessionBean.getOpenId().setDiscoveryInformation(discovered);
            request.getSession().setAttribute("org.wso2.carbon.identity.sso.agent.LoggedInSessionBean", (Object)sessionBean);
            manager.setImmediateAuth(true);
            AuthRequest authReq = manager.authenticate(discovered, this.ssoAgentConfig.getOpenId().getReturnToURL());
            if (this.ssoAgentConfig.getOpenId().isAttributeExchangeEnabled() && this.ssoAgentConfig.getOpenId().getAttributesRequestor() != null) {
                this.attributesRequestor = this.ssoAgentConfig.getOpenId().getAttributesRequestor();
                this.attributesRequestor.init();
                String[] requestedAttributes = this.attributesRequestor.getRequestedAttributes(claimedId);
                FetchRequest fetchRequest = FetchRequest.createFetchRequest();
                for (String requestedAttribute : requestedAttributes) {
                    fetchRequest.addAttribute(requestedAttribute, this.attributesRequestor.getTypeURI(claimedId, requestedAttribute), this.attributesRequestor.isRequired(claimedId, requestedAttribute), this.attributesRequestor.getCount(claimedId, requestedAttribute));
                }
                authReq.addExtension((MessageExtension)fetchRequest);
            }
            SSOAgentDataHolder.getInstance().setConsumerManager(manager);
            StringBuilder destinationUrl = new StringBuilder(authReq.getDestinationUrl(true));
            if (MapUtils.isNotEmpty(this.ssoAgentConfig.getQueryParams())) {
                StringBuilder builder = new StringBuilder();
                for (Map.Entry entry : this.ssoAgentConfig.getQueryParams().entrySet()) {
                    if (entry.getKey() == null || entry.getValue() == null || ((String[])entry.getValue()).length <= 0) continue;
                    for (String param : (String[])entry.getValue()) {
                        builder.append("&").append((String)entry.getKey()).append("=").append(param);
                    }
                }
                destinationUrl.append((CharSequence)builder);
            }
            return destinationUrl.toString();
        }
        catch (YadisException e) {
            if (e.getErrorCode() == 1796) {
                throw new SSOAgentException(e.getMessage(), e);
            }
            throw new SSOAgentException("Error while creating FetchRequest", e);
        }
        catch (MessageException e) {
            throw new SSOAgentException("Error while creating FetchRequest", e);
        }
        catch (DiscoveryException e) {
            throw new SSOAgentException("Error while doing OpenID Discovery", e);
        }
        catch (ConsumerException e) {
            throw new SSOAgentException("Error while doing OpenID Authentication", e);
        }
    }

    public void processOpenIDLoginResponse(HttpServletRequest request, HttpServletResponse response) throws SSOAgentException {
        block11: {
            try {
                ParameterList authResponseParams = new ParameterList(request.getParameterMap());
                LoggedInSessionBean loggedInSessionBean = (LoggedInSessionBean)request.getSession(false).getAttribute("org.wso2.carbon.identity.sso.agent.LoggedInSessionBean");
                if (loggedInSessionBean == null) {
                    throw new SSOAgentException("Error while verifying OpenID response. Cannot find valid session for user");
                }
                DiscoveryInformation discovered = loggedInSessionBean.getOpenId().getDiscoveryInformation();
                VerificationResult verificationResult = SSOAgentDataHolder.getInstance().getConsumerManager().verify(this.ssoAgentConfig.getOpenId().getReturnToURL(), authResponseParams, discovered);
                Identifier verified = verificationResult.getVerifiedId();
                if (verified != null) {
                    AuthSuccess authSuccess = (AuthSuccess)verificationResult.getAuthResponse();
                    loggedInSessionBean.getOpenId().setClaimedId(authSuccess.getIdentity());
                    if (authSuccess.hasExtension("http://openid.net/srv/ax/1.0")) {
                        HashMap<String, List<String>> attributesMap = new HashMap<String, List<String>>();
                        if (this.ssoAgentConfig.getOpenId().getAttributesRequestor() != null) {
                            this.attributesRequestor = this.ssoAgentConfig.getOpenId().getAttributesRequestor();
                            String[] attrArray = this.attributesRequestor.getRequestedAttributes(authSuccess.getIdentity());
                            FetchResponse fetchResp = (FetchResponse)authSuccess.getExtension("http://openid.net/srv/ax/1.0");
                            for (String attr : attrArray) {
                                List attributeValues = fetchResp.getAttributeValuesByTypeUri(this.attributesRequestor.getTypeURI(authSuccess.getIdentity(), attr));
                                if (attributeValues.get(0) instanceof String && ((String)attributeValues.get(0)).split(",").length > 1) {
                                    String[] splitString;
                                    for (String part : splitString = ((String)attributeValues.get(0)).split(",")) {
                                        attributeValues.add(part);
                                    }
                                }
                                if (attributeValues.get(0) == null) continue;
                                attributesMap.put(attr, attributeValues);
                            }
                        }
                        loggedInSessionBean.getOpenId().setSubjectAttributes(attributesMap);
                    }
                    break block11;
                }
                throw new SSOAgentException("OpenID verification failed");
            }
            catch (AssociationException e) {
                throw new SSOAgentException("Error while verifying OpenID response", e);
            }
            catch (MessageException e) {
                throw new SSOAgentException("Error while verifying OpenID response", e);
            }
            catch (DiscoveryException e) {
                throw new SSOAgentException("Error while verifying OpenID response", e);
            }
        }
    }
}

