/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.sso.agent.oauth2;

import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import javax.net.ssl.HttpsURLConnection;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.shibboleth.utilities.java.support.codec.Base64Support;
import org.wso2.carbon.identity.sso.agent.bean.LoggedInSessionBean;
import org.wso2.carbon.identity.sso.agent.bean.SSOAgentConfig;
import org.wso2.carbon.identity.sso.agent.exception.SSOAgentException;

public class SAML2GrantManager {
    private SSOAgentConfig ssoAgentConfig = null;

    public SAML2GrantManager(SSOAgentConfig ssoAgentConfig) {
        this.ssoAgentConfig = ssoAgentConfig;
    }

    public void getAccessToken(HttpServletRequest request, HttpServletResponse response) throws SSOAgentException {
        String samlAssertionString = ((LoggedInSessionBean)request.getSession(false).getAttribute("org.wso2.carbon.identity.sso.agent.LoggedInSessionBean")).getSAML2SSO().getAssertionString();
        String clientLogin = this.ssoAgentConfig.getOAuth2().getClientId() + ":" + this.ssoAgentConfig.getOAuth2().getClientSecret();
        String queryParam = "grant_type=urn:ietf:params:oauth:grant-type:saml2-bearer&assertion=" + URLEncoder.encode(Base64Support.encode((byte[])samlAssertionString.getBytes(Charset.forName("UTF-8")), (boolean)false).replaceAll("\n", ""));
        String additionalQueryParam = this.ssoAgentConfig.getRequestQueryParameters();
        if (additionalQueryParam != null) {
            queryParam = queryParam + additionalQueryParam;
        }
        String accessTokenResponse = this.executePost(queryParam, Base64Support.encode((byte[])clientLogin.getBytes(Charset.forName("UTF-8")), (boolean)false).replace("\n", ""));
        Gson gson = new Gson();
        LoggedInSessionBean.AccessTokenResponseBean accessTokenResp = (LoggedInSessionBean.AccessTokenResponseBean)gson.fromJson(accessTokenResponse, LoggedInSessionBean.AccessTokenResponseBean.class);
        ((LoggedInSessionBean)request.getSession(false).getAttribute("org.wso2.carbon.identity.sso.agent.LoggedInSessionBean")).getSAML2SSO().setAccessTokenResponseBean(accessTokenResp);
    }

    protected String executePost(String urlParameters, String basicAuthHeader) throws SSOAgentException {
        HttpURLConnection connection = null;
        try {
            String line;
            URL url = new URL(this.ssoAgentConfig.getOAuth2().getTokenURL());
            connection = this.ssoAgentConfig.getEnableSSLVerification() != false ? (HttpsURLConnection)url.openConnection() : (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            connection.setRequestProperty("Authorization", "Basic " + basicAuthHeader);
            connection.setRequestProperty("Content-Length", "" + Integer.toString(urlParameters.getBytes(Charset.forName("UTF-8")).length));
            connection.setUseCaches(false);
            connection.setDoInput(true);
            connection.setDoOutput(true);
            DataOutputStream wr = new DataOutputStream(connection.getOutputStream());
            wr.writeBytes(urlParameters);
            wr.flush();
            wr.close();
            InputStream is = connection.getInputStream();
            BufferedReader rd = new BufferedReader(new InputStreamReader(is));
            StringBuilder response = new StringBuilder();
            while ((line = rd.readLine()) != null) {
                response.append(line);
                response.append('\r');
            }
            rd.close();
            String string = response.toString();
            return string;
        }
        catch (IOException e) {
            throw new SSOAgentException("Error occurred while executing SAML2 grant request to OAuth2 Token URL", e);
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }
}

