/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.sso.agent.oauth2;

import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import javax.servlet.http.HttpServletRequest;
import net.shibboleth.utilities.java.support.codec.Base64Support;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.sso.agent.bean.SSOAgentSessionBean;
import org.wso2.carbon.identity.sso.agent.exception.SSOAgentException;
import org.wso2.carbon.identity.sso.agent.util.SSOAgentConfigs;

public class SAML2GrantAccessTokenRequestor {
    private static final Log log = LogFactory.getLog(SAML2GrantAccessTokenRequestor.class);
    public static final String SAML2_BEARER_ASSERTION = "grant_type=urn:ietf:params:oauth:grant-type:saml2-bearer&assertion=";

    private SAML2GrantAccessTokenRequestor() {
    }

    public static void getAccessToken(HttpServletRequest request) throws SSOAgentException {
        String samlAssertionString = ((SSOAgentSessionBean)request.getSession().getAttribute(SSOAgentConfigs.getSessionBeanName())).getSAMLSSOSessionBean().getSAMLAssertionString();
        try {
            String consumerKey = SSOAgentConfigs.getOAuth2ClientId();
            String consumerSecret = SSOAgentConfigs.getOAuth2ClientSecret();
            String tokenEndpoint = SSOAgentConfigs.getTokenEndpoint();
            String keySecret = consumerKey + ":" + consumerSecret;
            String accessTokenResponse = SAML2GrantAccessTokenRequestor.executePost(tokenEndpoint, SAML2_BEARER_ASSERTION + URLEncoder.encode(Base64Support.encode((byte[])samlAssertionString.getBytes(Charset.forName("UTF-8")), (boolean)false).replaceAll("\n", "")), Base64Support.encode((byte[])keySecret.getBytes(Charset.forName("UTF-8")), (boolean)false).replace("\n", ""));
            Gson gson = new Gson();
            SSOAgentSessionBean.AccessTokenResponseBean accessTokenResp = (SSOAgentSessionBean.AccessTokenResponseBean)gson.fromJson(accessTokenResponse, SSOAgentSessionBean.AccessTokenResponseBean.class);
            ((SSOAgentSessionBean)request.getSession().getAttribute(SSOAgentConfigs.getSessionBeanName())).getSAMLSSOSessionBean().setAccessTokenResponseBean(accessTokenResp);
        }
        catch (Exception e) {
            throw new SSOAgentException("Error while retrieving OAuth2 access token using SAML2 grant type", e);
        }
    }

    public static String executePost(String targetURL, String urlParameters, String clientCredentials) throws SSOAgentException {
        HttpURLConnection connection = null;
        try {
            String line;
            URL url = new URL(targetURL);
            connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            connection.setRequestProperty("Authorization", "Basic " + clientCredentials);
            connection.setRequestProperty("Content-Length", "" + Integer.toString(urlParameters.getBytes(Charset.forName("UTF-8")).length));
            connection.setUseCaches(false);
            connection.setDoInput(true);
            connection.setDoOutput(true);
            DataOutputStream wr = new DataOutputStream(connection.getOutputStream());
            wr.writeBytes(urlParameters);
            wr.flush();
            wr.close();
            InputStream is = connection.getInputStream();
            BufferedReader rd = new BufferedReader(new InputStreamReader(is));
            StringBuilder response = new StringBuilder();
            while ((line = rd.readLine()) != null) {
                response.append(line);
                response.append('\r');
            }
            rd.close();
            String string = response.toString();
            return string;
        }
        catch (Exception e) {
            throw new SSOAgentException("Exception while executiong post", e);
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }
}

