/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.sso.agent.internal;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.wso2.carbon.user.core.service.RealmService;

@Component(name="org.wso2.carbon.identity.sso.agent", immediate=true)
public class SSOAgentServiceComponent {
    private static final Log log = LogFactory.getLog(SSOAgentServiceComponent.class);
    private static RealmService realmService;

    public static RealmService getRealmService() {
        return realmService;
    }

    @Reference(name="user.realmservice.default", service=RealmService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetRealmService")
    protected void setRealmService(RealmService realmService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"RealmService is set in the SSO agent bundle");
        }
        SSOAgentServiceComponent.realmService = realmService;
    }

    @Activate
    protected void activate(ComponentContext ctxt) {
        if (log.isDebugEnabled()) {
            log.info((Object)"SSO Agent bundle is activated");
        }
    }

    @Deactivate
    protected void deactivate(ComponentContext context) {
        if (log.isDebugEnabled()) {
            log.info((Object)"SSO Agent bundle is deactivated");
        }
    }

    protected void unsetRealmService(RealmService realmService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"RealmService is unset in the SSO Agent bundle");
        }
        SSOAgentServiceComponent.realmService = null;
    }
}

