/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.sso.agent.bean;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.wso2.carbon.identity.sso.agent.AESDecryptor;
import org.wso2.carbon.identity.sso.agent.exception.SSOAgentException;
import org.wso2.carbon.identity.sso.agent.openid.AttributesRequestor;
import org.wso2.carbon.identity.sso.agent.security.SSOAgentCarbonX509Credential;
import org.wso2.carbon.identity.sso.agent.security.SSOAgentX509Credential;

public class SSOAgentConfig {
    private static final Logger LOGGER = Logger.getLogger("org.wso2.carbon.identity.sso.agent");
    private static final String ARGUMENT = "sun.java.command";
    private Boolean isSAML2SSOLoginEnabled = false;
    private Boolean isOpenIdLoginEnabled = false;
    private Boolean isOAuth2SAML2GrantEnabled = false;
    private String saml2SSOURL = null;
    private String openIdURL = null;
    private String oauth2SAML2GrantURL = null;
    private Set<String> skipURIs = new HashSet<String>();
    private Map<String, String[]> queryParams = new HashMap<String, String[]>();
    private SAML2 saml2 = new SAML2();
    private OpenID openId = new OpenID();
    private OIDC oidc = new OIDC();
    private OAuth2 oauth2 = new OAuth2();
    private String requestQueryParameters;
    private Boolean enableHostNameVerification = false;
    private Boolean enableSSLVerification = false;
    private InputStream keyStoreStream;
    private String keyStorePassword;
    private KeyStore keyStore;
    private String privateKeyPassword;
    private String privateKeyAlias;
    private String idpPublicCertAlias;

    public Boolean getEnableHostNameVerification() {
        return this.enableHostNameVerification;
    }

    public Boolean getEnableSSLVerification() {
        return this.enableSSLVerification;
    }

    public String getRequestQueryParameters() {
        return this.requestQueryParameters;
    }

    public Boolean isSAML2SSOLoginEnabled() {
        return this.isSAML2SSOLoginEnabled;
    }

    public Boolean isOpenIdLoginEnabled() {
        return this.isOpenIdLoginEnabled;
    }

    public Boolean isOAuth2SAML2GrantEnabled() {
        return this.isOAuth2SAML2GrantEnabled;
    }

    public String getSAML2SSOURL() {
        return this.saml2SSOURL;
    }

    public void setSAML2SSOURL(String saml2SSOURL) {
        this.saml2SSOURL = saml2SSOURL;
    }

    public String getOpenIdURL() {
        return this.openIdURL;
    }

    public void setOpenIdURL(String openIdURL) {
        this.openIdURL = openIdURL;
    }

    public String getOAuth2SAML2GrantURL() {
        return this.oauth2SAML2GrantURL;
    }

    public void setOAuth2SAML2GrantURL(String oauth2SAML2GrantURL) {
        this.oauth2SAML2GrantURL = oauth2SAML2GrantURL;
    }

    public Set<String> getSkipURIs() {
        return this.skipURIs;
    }

    public void setSkipURIs(Set<String> skipURIs) {
        this.skipURIs = skipURIs;
    }

    public Map<String, String[]> getQueryParams() {
        return this.queryParams;
    }

    public void setQueryParams(Map<String, String[]> queryParams) {
        this.queryParams = queryParams;
    }

    public SAML2 getSAML2() {
        return this.saml2;
    }

    public OAuth2 getOAuth2() {
        return this.oauth2;
    }

    public OpenID getOpenId() {
        return this.openId;
    }

    public OIDC getOidc() {
        return this.oidc;
    }

    public void setSAML2SSOLoginEnabled(Boolean isSAML2SSOLoginEnabled) {
        this.isSAML2SSOLoginEnabled = isSAML2SSOLoginEnabled;
    }

    public void setOpenIdLoginEnabled(Boolean isOpenIdLoginEnabled) {
        this.isOpenIdLoginEnabled = isOpenIdLoginEnabled;
    }

    public void setOAuth2SAML2GrantEnabled(Boolean isOAuth2SAML2GrantEnabled) {
        this.isOAuth2SAML2GrantEnabled = isOAuth2SAML2GrantEnabled;
    }

    private InputStream getKeyStoreStream() {
        return this.keyStoreStream;
    }

    public void setKeyStoreStream(InputStream keyStoreStream) {
        if (this.keyStoreStream == null) {
            this.keyStoreStream = keyStoreStream;
        }
    }

    public String getPrivateKeyPassword() {
        return this.privateKeyPassword;
    }

    public String getPrivateKeyAlias() {
        return this.privateKeyAlias;
    }

    public String getIdPPublicCertAlias() {
        return this.idpPublicCertAlias;
    }

    public String getKeyStorePassword() {
        return this.keyStorePassword;
    }

    public void setKeyStorePassword(String keyStorePassword) {
        this.keyStorePassword = keyStorePassword;
    }

    public KeyStore getKeyStore() throws SSOAgentException {
        if (this.keyStore == null) {
            this.setKeyStore(this.readKeyStore(this.getKeyStoreStream(), this.getKeyStorePassword()));
        }
        return this.keyStore;
    }

    public void setKeyStore(KeyStore keyStore) {
        this.keyStore = keyStore;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void initConfig(Properties properties) throws SSOAgentException {
        String isRequestSignedString;
        String queryParamsString;
        String isSAML2SSOLoginEnabledString;
        boolean isReadpassword = false;
        char[] password = null;
        Properties copyOfProperties = new Properties();
        copyOfProperties.putAll((Map<?, ?>)properties);
        String filePath = System.getProperty("catalina.home") + "/conf/password_temp.txt";
        for (Map.Entry<Object, Object> entry : copyOfProperties.entrySet()) {
            if (!String.valueOf(entry.getValue()).startsWith("Enc:")) continue;
            if (!System.getProperty(ARGUMENT).contains("password")) {
                if (!isReadpassword) {
                    Path path = Paths.get(filePath, new String[0]);
                    try (BufferedReader reader = Files.newBufferedReader(path, Charset.forName("UTF-8"));){
                        String[] currentLine = new StringBuilder();
                        currentLine.append(reader.readLine());
                        if (currentLine.length() > 0) {
                            password = new char[currentLine.length()];
                            currentLine.getChars(0, currentLine.length(), password, 0);
                            currentLine = null;
                        }
                        isReadpassword = true;
                        if (Files.deleteIfExists(path)) {
                            LOGGER.info("Deleted the temporary password file at " + path);
                        }
                    }
                    catch (IOException ex) {
                        throw new SSOAgentException("Error while reading the file ", ex);
                    }
                }
            } else if (!isReadpassword) {
                System.out.print("Enter password for decryption:");
                password = System.console().readPassword();
                isReadpassword = true;
            }
            if (ArrayUtils.isEmpty(password)) {
                LOGGER.log(Level.SEVERE, "Can't find the password to decrypt the encrypted values.");
                return;
            }
            String encryptedValue = String.valueOf(entry.getValue());
            if (encryptedValue.split(":").length <= 1) {
                LOGGER.log(Level.SEVERE, "Encrypted value is not in the correct format. Encrypted value must contain the encrypted value with Enc: as prefix.");
                return;
            }
            String decodedPassword = AESDecryptor.decrypt(String.valueOf(entry.getValue()).split(":")[1].trim(), password);
            properties.remove(String.valueOf(entry.getKey()));
            properties.setProperty(String.valueOf(entry.getKey()), decodedPassword);
        }
        if (password != null) {
            Arrays.fill(password, '\u0000');
        }
        this.privateKeyPassword = properties.getProperty("PrivateKeyPassword");
        this.privateKeyAlias = properties.getProperty("PrivateKeyAlias");
        this.idpPublicCertAlias = properties.getProperty("IdPPublicCertAlias");
        this.requestQueryParameters = properties.getProperty("SAML.Request.Query.Param");
        if (properties.getProperty("SSL.EnableSSLVerification") != null) {
            this.enableSSLVerification = Boolean.parseBoolean(properties.getProperty("SSL.EnableSSLVerification"));
        }
        if (properties.getProperty("SSL.EnableSSLHostNameVerification") != null) {
            this.enableHostNameVerification = Boolean.parseBoolean(properties.getProperty("SSL.EnableSSLHostNameVerification"));
        }
        if ((isSAML2SSOLoginEnabledString = properties.getProperty("EnableSAML2SSOLogin")) != null) {
            this.isSAML2SSOLoginEnabled = Boolean.parseBoolean(isSAML2SSOLoginEnabledString);
        } else {
            LOGGER.log(Level.FINE, "EnableSAML2SSOLogin not configured. Defaulting to 'false'");
            this.isSAML2SSOLoginEnabled = false;
        }
        String isOpenIdLoginEnabledString = properties.getProperty("EnableOpenIDLogin");
        if (isOpenIdLoginEnabledString != null) {
            this.isOpenIdLoginEnabled = Boolean.parseBoolean(isOpenIdLoginEnabledString);
        } else {
            LOGGER.log(Level.FINE, "EnableOpenIDLogin not configured. Defaulting to 'false'");
            this.isOpenIdLoginEnabled = false;
        }
        String isSAML2OAuth2GrantEnabledString = properties.getProperty("EnableOAuth2SAML2Grant");
        if (isSAML2OAuth2GrantEnabledString != null) {
            this.isOAuth2SAML2GrantEnabled = Boolean.parseBoolean(isSAML2OAuth2GrantEnabledString);
        } else {
            LOGGER.log(Level.FINE, "EnableOAuth2SAML2Grant not configured. Defaulting to 'false'");
            this.isOAuth2SAML2GrantEnabled = false;
        }
        this.saml2SSOURL = properties.getProperty("SAML2SSOURL");
        this.openIdURL = properties.getProperty("OpenIdURL");
        this.oauth2SAML2GrantURL = properties.getProperty("OAuth2SAML2GrantURL");
        String skipURIsString = properties.getProperty("SkipURIs");
        if (!StringUtils.isBlank((String)skipURIsString)) {
            String[] skipURIArray;
            for (String string : skipURIArray = skipURIsString.split(",")) {
                this.skipURIs.add(string);
            }
        }
        if (!StringUtils.isBlank((String)(queryParamsString = properties.getProperty("QueryParams")))) {
            String[] queryParamsArray = queryParamsString.split("&");
            HashMap queryParamMap = new HashMap();
            if (queryParamsArray.length > 0) {
                for (String queryParam : queryParamsArray) {
                    String[] splitParam = queryParam.split("=");
                    if (splitParam.length != 2) continue;
                    if (queryParamMap.get(splitParam[0]) != null) {
                        ((List)queryParamMap.get(splitParam[0])).add(splitParam[1]);
                        continue;
                    }
                    ArrayList<String> newList = new ArrayList<String>();
                    newList.add(splitParam[1]);
                    queryParamMap.put(splitParam[0], newList);
                }
                for (Map.Entry entry : queryParamMap.entrySet()) {
                    String[] valueArray = ((List)entry.getValue()).toArray(new String[((List)entry.getValue()).size()]);
                    this.queryParams.put((String)entry.getKey(), valueArray);
                }
            }
        }
        this.saml2.httpBinding = properties.getProperty("SAML2.HTTPBinding");
        if (this.saml2.httpBinding == null || this.saml2.httpBinding.isEmpty()) {
            LOGGER.log(Level.FINE, "SAML2.HTTPBinding not configured. Defaulting to 'urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST'");
            this.saml2.httpBinding = "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST";
        }
        this.saml2.spEntityId = properties.getProperty("SAML2.SPEntityId");
        this.saml2.acsURL = properties.getProperty("SAML2.AssertionConsumerURL");
        this.saml2.idPEntityId = properties.getProperty("SAML2.IdPEntityId");
        this.saml2.idPURL = properties.getProperty("SAML2.IdPURL");
        this.saml2.attributeConsumingServiceIndex = properties.getProperty("SAML2.AttributeConsumingServiceIndex");
        String isSLOEnabledString = properties.getProperty("SAML2.EnableSLO");
        if (isSLOEnabledString != null) {
            this.saml2.isSLOEnabled = Boolean.parseBoolean(isSLOEnabledString);
        } else {
            LOGGER.info("'SAML2.EnableSLO' not configured. Defaulting to 'false'");
            this.saml2.isSLOEnabled = false;
        }
        this.saml2.sloURL = properties.getProperty("SAML2.SLOURL");
        String isAssertionSignedString = properties.getProperty("SAML2.EnableAssertionSigning");
        if (isAssertionSignedString != null) {
            this.saml2.isAssertionSigned = Boolean.parseBoolean(isAssertionSignedString);
        } else {
            LOGGER.log(Level.FINE, "SAML2.EnableAssertionSigning not configured. Defaulting to 'false'");
            this.saml2.isAssertionSigned = false;
        }
        String isAssertionEncryptedString = properties.getProperty("SAML2.EnableAssertionEncryption");
        if (isAssertionEncryptedString != null) {
            this.saml2.isAssertionEncrypted = Boolean.parseBoolean(isAssertionEncryptedString);
        } else {
            LOGGER.log(Level.FINE, "SAML2.EnableAssertionEncryption not configured. Defaulting to 'false'");
            this.saml2.isAssertionEncrypted = false;
        }
        String string = properties.getProperty("SAML2.EnableResponseSigning");
        if (string != null) {
            this.saml2.isResponseSigned = Boolean.parseBoolean(string);
        } else {
            LOGGER.log(Level.FINE, "SAML2.EnableResponseSigning not configured. Defaulting to 'false'");
            this.saml2.isResponseSigned = false;
        }
        if (this.saml2.isResponseSigned().booleanValue() || this.saml2.isAssertionSigned().booleanValue()) {
            String signatureValidatorImplClass = properties.getProperty("SAML2.SignatureValidatorImplClass");
            if (signatureValidatorImplClass != null) {
                this.saml2.signatureValidatorImplClass = signatureValidatorImplClass;
            } else {
                LOGGER.log(Level.FINE, "SAML2.SignatureValidatorImplClass not configured.");
            }
        }
        if ((isRequestSignedString = properties.getProperty("SAML2.EnableRequestSigning")) != null) {
            this.saml2.isRequestSigned = Boolean.parseBoolean(isRequestSignedString);
        } else {
            LOGGER.log(Level.FINE, "SAML2.EnableRequestSigning not configured. Defaulting to 'false'");
            this.saml2.isRequestSigned = false;
        }
        String isPassiveAuthnString = properties.getProperty("SAML2.IsPassiveAuthn");
        if (isPassiveAuthnString != null) {
            this.saml2.isPassiveAuthn = Boolean.parseBoolean(isPassiveAuthnString);
        } else {
            LOGGER.log(Level.FINE, "'SAML2.IsPassiveAuthn' not configured. Defaulting to 'false'");
            this.saml2.isPassiveAuthn = false;
        }
        String isForceAuthnString = properties.getProperty("SAML2.IsForceAuthn");
        if (isForceAuthnString != null) {
            this.saml2.isForceAuthn = Boolean.parseBoolean(isForceAuthnString);
        } else {
            LOGGER.log(Level.FINE, "'SAML2.IsForceAuthn' not configured. Defaulting to 'false'");
            this.saml2.isForceAuthn = false;
        }
        this.saml2.relayState = properties.getProperty("SAML2.RelayState");
        this.saml2.postBindingRequestHTMLPayload = properties.getProperty("SAML2.PostBindingRequestHTMLPayload");
        this.saml2.artifactResolveURL = properties.getProperty("SAML2.ArtifactResolveUrl");
        this.saml2.enableArtifactResolveSigning = StringUtils.equals((String)properties.getProperty("SAML2.EnableArtifactResolveSigning"), (String)"true");
        this.oauth2.tokenURL = properties.getProperty("OAuth2.TokenURL");
        this.oauth2.clientId = properties.getProperty("OAuth2.ClientId");
        this.oauth2.clientSecret = properties.getProperty("OAuth2.ClientSecret");
        this.openId.providerURL = properties.getProperty("OpenId.ProviderURL");
        this.openId.returnToURL = properties.getProperty("OpenId.ReturnToURL");
        String isAttributeExchangeEnabledString = properties.getProperty("OpenId.EnableAttributeExchange");
        if (isAttributeExchangeEnabledString != null) {
            this.openId.isAttributeExchangeEnabled = Boolean.parseBoolean(isAttributeExchangeEnabledString);
        } else {
            LOGGER.log(Level.FINE, "'OpenId.EnableAttributeExchange' not configured. Defaulting to 'true'");
            this.openId.isAttributeExchangeEnabled = true;
        }
        String isDumbModeEnabledString = properties.getProperty("OpenId.EnableDumbMode");
        if (isAttributeExchangeEnabledString != null) {
            this.openId.isDumbModeEnabled = Boolean.parseBoolean(isDumbModeEnabledString);
        } else {
            LOGGER.log(Level.FINE, "'OpenId.EnableDumbMode' not configured. Defaulting to 'false'");
            this.openId.isDumbModeEnabled = false;
        }
        this.oidc.setConsumerKey(properties.getProperty("consumerKey"));
        this.oidc.setConsumerSecret(properties.getProperty("consumerSecret"));
        this.oidc.setAuthzEndpoint(properties.getProperty("authorizeEndpoint"));
        this.oidc.setAuthzGrantType(properties.getProperty("grantType"));
        this.oidc.setCallBackUrl(properties.getProperty("callBackUrl"));
        this.oidc.setOIDCLogoutEndpoint(properties.getProperty("logoutEndpoint"));
        this.oidc.setSessionIFrameEndpoint(properties.getProperty("sessionIFrameEndpoint"));
        this.oidc.setScope(properties.getProperty("scope"));
        this.oidc.setPostLogoutRedirectUri(properties.getProperty("postLogoutRedirectUri"));
        if (properties.getProperty("KeyStore") != null) {
            try {
                this.keyStoreStream = new FileInputStream(properties.getProperty("KeyStore"));
            }
            catch (FileNotFoundException e) {
                throw new SSOAgentException("Cannot find file " + properties.getProperty("KeyStore"), e);
            }
        }
        this.keyStorePassword = properties.getProperty("KeyStorePassword");
        String timeStampSkew = properties.getProperty("SAML2.TimestampSkew");
        if (timeStampSkew != null) {
            this.saml2.timeStampSkewInSeconds = Integer.parseInt(timeStampSkew);
        } else {
            LOGGER.log(Level.FINE, "SAML2.TimestampSkew not configured. Defaulting to 300s");
        }
        try {
            SSLContext sc = SSLContext.getInstance("SSL");
            this.doHostNameVerification();
            TrustManager[] trustManagers = this.doSSLVerification();
            sc.init(null, trustManagers, new SecureRandom());
            SSLSocketFactory sslSocketFactory = sc.getSocketFactory();
            HttpsURLConnection.setDefaultSSLSocketFactory(sslSocketFactory);
            return;
        }
        catch (Exception e) {
            throw new SSOAgentException("An error in initializing SSL Context");
        }
    }

    public void verifyConfig() throws SSOAgentException {
        if (this.isSAML2SSOLoginEnabled.booleanValue() && this.saml2SSOURL == null) {
            throw new SSOAgentException("'SAML2SSOURL' not configured");
        }
        if (this.isOpenIdLoginEnabled.booleanValue() && this.openIdURL == null) {
            throw new SSOAgentException("'OpenIdURL' not configured");
        }
        if (!this.isSAML2SSOLoginEnabled.booleanValue() && this.isOAuth2SAML2GrantEnabled.booleanValue()) {
            throw new SSOAgentException("SAML2 SSO Login is disabled. Cannot use SAML2 Bearer Grant type for OAuth2");
        }
        if (this.isSAML2SSOLoginEnabled.booleanValue() && this.isOAuth2SAML2GrantEnabled.booleanValue() && this.oauth2SAML2GrantURL == null) {
            throw new SSOAgentException("'OAuth2SAML2GrantURL' not configured");
        }
        if (this.isSAML2SSOLoginEnabled.booleanValue() && this.saml2.spEntityId == null) {
            throw new SSOAgentException("'SAML2.SPEntityId' not configured");
        }
        if (this.isSAML2SSOLoginEnabled.booleanValue() && this.saml2.acsURL == null) {
            throw new SSOAgentException("'SAML2.AssertionConsumerURL' not configured");
        }
        if (this.isSAML2SSOLoginEnabled.booleanValue() && this.saml2.idPEntityId == null) {
            throw new SSOAgentException("'SAML2.IdPEntityId' not configured");
        }
        if (this.isSAML2SSOLoginEnabled.booleanValue() && this.saml2.idPURL == null) {
            throw new SSOAgentException("'SAML2.IdPURL' not configured");
        }
        if (this.isSAML2SSOLoginEnabled.booleanValue() && this.saml2.attributeConsumingServiceIndex == null) {
            LOGGER.log(Level.FINE, "'SAML2.AttributeConsumingServiceIndex' not configured. No attributes of the Subject will be requested");
        }
        if (this.isSAML2SSOLoginEnabled.booleanValue() && this.saml2.isSLOEnabled.booleanValue() && this.saml2.sloURL == null) {
            throw new SSOAgentException("Single Logout enabled, but SLO URL not configured");
        }
        if (this.isSAML2SSOLoginEnabled.booleanValue() && (this.saml2.isAssertionSigned.booleanValue() || this.saml2.isAssertionEncrypted.booleanValue() || this.saml2.isResponseSigned.booleanValue() || this.saml2.isRequestSigned.booleanValue()) && this.saml2.ssoAgentX509Credential == null) {
            LOGGER.log(Level.FINE, "'SSOAgentX509Credential' not configured. Defaulting to " + SSOAgentCarbonX509Credential.class.getName());
        }
        if (this.isSAML2SSOLoginEnabled.booleanValue() && (this.saml2.isAssertionSigned.booleanValue() || this.saml2.isResponseSigned.booleanValue()) && this.saml2.ssoAgentX509Credential.getEntityCertificate() == null) {
            throw new SSOAgentException("Public certificate of IdP not configured");
        }
        if (this.isSAML2SSOLoginEnabled.booleanValue() && (this.saml2.isRequestSigned.booleanValue() || this.saml2.isAssertionEncrypted.booleanValue()) && this.saml2.ssoAgentX509Credential.getPrivateKey() == null) {
            throw new SSOAgentException("Private key of SP not configured");
        }
        if (this.isOpenIdLoginEnabled.booleanValue() && this.openId.providerURL == null) {
            throw new SSOAgentException("'OpenId.ProviderURL' not configured");
        }
        if (this.isOpenIdLoginEnabled.booleanValue() && this.openId.returnToURL == null) {
            throw new SSOAgentException("'OpenId.ReturnToURL' not configured");
        }
        if (this.isOpenIdLoginEnabled.booleanValue() && this.openId.attributesRequestor == null) {
            LOGGER.log(Level.FINE, "'OpenId.ProviderURL' not configured. No attributes of the Subject will be fetched");
        }
        if (this.isSAML2SSOLoginEnabled.booleanValue() && this.isOAuth2SAML2GrantEnabled.booleanValue() && this.oauth2.tokenURL == null) {
            throw new SSOAgentException("OAuth2 Token endpoint not configured");
        }
        if (this.isSAML2SSOLoginEnabled.booleanValue() && this.isOAuth2SAML2GrantEnabled.booleanValue() && this.oauth2.clientId == null) {
            throw new SSOAgentException("OAuth2 Client Id not configured");
        }
        if (this.isSAML2SSOLoginEnabled.booleanValue() && this.isOAuth2SAML2GrantEnabled.booleanValue() && this.oauth2.clientSecret == null) {
            throw new SSOAgentException("OAuth2 Client Secret not configured");
        }
    }

    private KeyStore readKeyStore(InputStream is, String storePassword) throws SSOAgentException {
        if (storePassword == null) {
            throw new SSOAgentException("KeyStore password can not be null");
        }
        try {
            KeyStore keyStore = KeyStore.getInstance("JKS");
            keyStore.load(is, storePassword.toCharArray());
            KeyStore keyStore2 = keyStore;
            return keyStore2;
        }
        catch (Exception e) {
            throw new SSOAgentException("Error while loading key store file", e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException ignored) {
                    throw new SSOAgentException("Error while closing input stream of key store", ignored);
                }
            }
        }
    }

    private void doHostNameVerification() {
        if (!this.getEnableHostNameVerification().booleanValue()) {
            HostnameVerifier hv = new HostnameVerifier(){

                @Override
                public boolean verify(String urlHostName, SSLSession session) {
                    return true;
                }
            };
            HttpsURLConnection.setDefaultHostnameVerifier(hv);
        }
    }

    private TrustManager[] doSSLVerification() throws Exception {
        TrustManager[] trustManagers = null;
        if (this.getEnableSSLVerification().booleanValue()) {
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(this.getKeyStore());
            trustManagers = tmf.getTrustManagers();
        } else {
            trustManagers = new TrustManager[]{new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                @Override
                public void checkClientTrusted(X509Certificate[] certs, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] certs, String authType) {
                }
            }};
        }
        return trustManagers;
    }

    public class OAuth2 {
        private String tokenURL = null;
        private String clientId = null;
        private String clientSecret = null;

        public String getClientSecret() {
            return this.clientSecret;
        }

        public void setClientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
        }

        public String getTokenURL() {
            return this.tokenURL;
        }

        public void setTokenURL(String tokenURL) {
            this.tokenURL = tokenURL;
        }

        public String getClientId() {
            return this.clientId;
        }

        public void setClientId(String clientId) {
            this.clientId = clientId;
        }
    }

    public class OIDC {
        private String consumerKey = "";
        private String consumerSecret = "";
        private String authzEndpoint = "";
        private String authzGrantType = "";
        private String callBackUrl = "";
        private String OIDCLogoutEndpoint = "";
        private String sessionIFrameEndpoint = "";
        private String scope = "";
        private String postLogoutRedirectUri = "";

        public String getScope() {
            return this.scope;
        }

        public void setScope(String scope) {
            this.scope = scope;
        }

        public String getConsumerKey() {
            return this.consumerKey;
        }

        public void setConsumerKey(String consumerKey) {
            this.consumerKey = consumerKey;
        }

        public String getAuthzEndpoint() {
            return this.authzEndpoint;
        }

        public void setAuthzEndpoint(String authzEndpoint) {
            this.authzEndpoint = authzEndpoint;
        }

        public String getAuthzGrantType() {
            return this.authzGrantType;
        }

        public void setAuthzGrantType(String authzGrantType) {
            this.authzGrantType = authzGrantType;
        }

        public String getCallBackUrl() {
            return this.callBackUrl;
        }

        public void setCallBackUrl(String callBackUrl) {
            this.callBackUrl = callBackUrl;
        }

        public String getOIDCLogoutEndpoint() {
            return this.OIDCLogoutEndpoint;
        }

        public void setOIDCLogoutEndpoint(String OIDCLogoutEndpoint) {
            this.OIDCLogoutEndpoint = OIDCLogoutEndpoint;
        }

        public String getSessionIFrameEndpoint() {
            return this.sessionIFrameEndpoint;
        }

        public void setSessionIFrameEndpoint(String sessionIFrameEndpoint) {
            this.sessionIFrameEndpoint = sessionIFrameEndpoint;
        }

        public String getConsumerSecret() {
            return this.consumerSecret;
        }

        public void setConsumerSecret(String consumerSecret) {
            this.consumerSecret = consumerSecret;
        }

        public String getPostLogoutRedirectUri() {
            return this.postLogoutRedirectUri;
        }

        public void setPostLogoutRedirectUri(String postLogoutRedirectUri) {
            this.postLogoutRedirectUri = postLogoutRedirectUri;
        }
    }

    public class OpenID {
        private String mode = null;
        private String providerURL = null;
        private String returnToURL = null;
        private String claimedId = null;
        private AttributesRequestor attributesRequestor = null;
        private boolean isAttributeExchangeEnabled = false;
        private boolean isDumbModeEnabled = false;

        public String getMode() {
            return this.mode;
        }

        public void setMode(String mode) {
            this.mode = mode;
        }

        public String getProviderURL() {
            return this.providerURL;
        }

        public void setProviderURL(String providerURL) {
            this.providerURL = providerURL;
        }

        public String getReturnToURL() {
            return this.returnToURL;
        }

        public void setReturnToURL(String returnToURL) {
            this.returnToURL = returnToURL;
        }

        public String getClaimedId() {
            return this.claimedId;
        }

        public void setClaimedId(String claimedId) {
            this.claimedId = claimedId;
        }

        public AttributesRequestor getAttributesRequestor() {
            return this.attributesRequestor;
        }

        public void setAttributesRequestor(AttributesRequestor attributesRequestor) {
            this.attributesRequestor = attributesRequestor;
        }

        public boolean isAttributeExchangeEnabled() {
            return this.isAttributeExchangeEnabled;
        }

        public void setAttributeExchangeEnabled(boolean isAttributeExchangeEnabled) {
            this.isAttributeExchangeEnabled = isAttributeExchangeEnabled;
        }

        public boolean isDumbModeEnabled() {
            return this.isDumbModeEnabled;
        }

        public void setDumbModeEnabled(boolean isDumbModeEnabled) {
            this.isDumbModeEnabled = isDumbModeEnabled;
        }
    }

    public class SAML2 {
        private String httpBinding = null;
        private String spEntityId = null;
        private String acsURL = null;
        private String idPEntityId = null;
        private String idPURL = null;
        private Boolean isSLOEnabled = false;
        private String sloURL = null;
        private String attributeConsumingServiceIndex = null;
        private SSOAgentX509Credential ssoAgentX509Credential = null;
        private Boolean isAssertionSigned = false;
        private Boolean isAssertionEncrypted = false;
        private Boolean isResponseSigned = false;
        private Boolean isRequestSigned = false;
        private Boolean isPassiveAuthn = false;
        private Boolean isForceAuthn = false;
        private String relayState = null;
        private String signatureValidatorImplClass = null;
        private int timeStampSkewInSeconds = 300;
        private String artifactResolveURL = null;
        private boolean enableArtifactResolveSigning;
        private String postBindingRequestHTMLPayload = null;

        public void setArtifactResolveURL(String artifactResolveURL) {
            this.artifactResolveURL = artifactResolveURL;
        }

        public String getArtifactResolveURL() {
            return this.artifactResolveURL;
        }

        public void setEnableArtifactResolveSigning(boolean enableArtifactResolveSigning) {
            this.enableArtifactResolveSigning = enableArtifactResolveSigning;
        }

        public boolean isEnableArtifactResolveSigning() {
            return this.enableArtifactResolveSigning;
        }

        public String getHttpBinding() {
            return this.httpBinding;
        }

        public void setHttpBinding(String httpBinding) {
            this.httpBinding = httpBinding;
        }

        public String getSPEntityId() {
            return this.spEntityId;
        }

        public void setSPEntityId(String spEntityId) {
            this.spEntityId = spEntityId;
        }

        public String getACSURL() {
            return this.acsURL;
        }

        public void setACSURL(String acsURL) {
            this.acsURL = acsURL;
        }

        public String getIdPEntityId() {
            return this.idPEntityId;
        }

        public void setIdPEntityId(String idPEntityId) {
            this.idPEntityId = idPEntityId;
        }

        public String getIdPURL() {
            return this.idPURL;
        }

        public void setIdPURL(String idPURL) {
            this.idPURL = idPURL;
        }

        public Boolean isSLOEnabled() {
            return this.isSLOEnabled;
        }

        public String getSLOURL() {
            return this.sloURL;
        }

        public void setSLOURL(String sloURL) {
            this.sloURL = sloURL;
        }

        public String getAttributeConsumingServiceIndex() {
            return this.attributeConsumingServiceIndex;
        }

        public void setAttributeConsumingServiceIndex(String attributeConsumingServiceIndex) {
            this.attributeConsumingServiceIndex = attributeConsumingServiceIndex;
        }

        public SSOAgentX509Credential getSSOAgentX509Credential() {
            return this.ssoAgentX509Credential;
        }

        public void setSSOAgentX509Credential(SSOAgentX509Credential ssoAgentX509Credential) {
            this.ssoAgentX509Credential = ssoAgentX509Credential;
        }

        public Boolean isAssertionSigned() {
            return this.isAssertionSigned;
        }

        public Boolean isAssertionEncrypted() {
            return this.isAssertionEncrypted;
        }

        public Boolean isResponseSigned() {
            return this.isResponseSigned;
        }

        public Boolean isRequestSigned() {
            return this.isRequestSigned;
        }

        public Boolean isPassiveAuthn() {
            return this.isPassiveAuthn;
        }

        public Boolean isForceAuthn() {
            return this.isForceAuthn;
        }

        public String getRelayState() {
            return this.relayState;
        }

        public void setRelayState(String relayState) {
            this.relayState = relayState;
        }

        public String getPostBindingRequestHTMLPayload() {
            return this.postBindingRequestHTMLPayload;
        }

        public void setPostBindingRequestHTMLPayload(String postBindingRequestHTMLPayload) {
            this.postBindingRequestHTMLPayload = postBindingRequestHTMLPayload;
        }

        public void setSLOEnabled(Boolean isSLOEnabled) {
            this.isSLOEnabled = isSLOEnabled;
        }

        public void setAssertionSigned(Boolean isAssertionSigned) {
            this.isAssertionSigned = isAssertionSigned;
        }

        public void setAssertionEncrypted(Boolean isAssertionEncrypted) {
            this.isAssertionEncrypted = isAssertionEncrypted;
        }

        public void setResponseSigned(Boolean isResponseSigned) {
            this.isResponseSigned = isResponseSigned;
        }

        public void setRequestSigned(Boolean isRequestSigned) {
            this.isRequestSigned = isRequestSigned;
        }

        public void setPassiveAuthn(Boolean isPassiveAuthn) {
            this.isPassiveAuthn = isPassiveAuthn;
        }

        public void setForceAuthn(Boolean isForceAuthn) {
            this.isForceAuthn = isForceAuthn;
        }

        public String getSignatureValidatorImplClass() {
            return this.signatureValidatorImplClass;
        }

        public int getTimeStampSkewInSeconds() {
            return this.timeStampSkewInSeconds;
        }
    }
}

