/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.sso.agent.bean;

import com.google.gson.Gson;
import com.google.gson.annotations.SerializedName;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAttribute;
import org.openid4java.discovery.DiscoveryInformation;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.Response;
import org.wso2.carbon.identity.sso.agent.exception.SSOAgentException;
import org.wso2.carbon.identity.sso.agent.util.SSOAgentUtils;

public class LoggedInSessionBean
implements Serializable {
    private static final long serialVersionUID = 7762835859870143767L;
    private OpenID openId;
    private SAML2SSO saml2SSO;

    public SAML2SSO getSAML2SSO() {
        return this.saml2SSO;
    }

    public void setSAML2SSO(SAML2SSO saml2SSO) {
        this.saml2SSO = saml2SSO;
    }

    public OpenID getOpenId() {
        return this.openId;
    }

    public void setOpenId(OpenID openId) {
        this.openId = openId;
    }

    public class SAML2SSO
    implements Serializable {
        public static final String EMPTY_STRING = "";
        private String subjectId;
        private Response response;
        private String responseString;
        private Assertion assertion;
        private String assertionString;
        private AccessTokenResponseBean accessTokenResponseBean;
        private String sessionIndex;
        private Map<String, String> subjectAttributes;

        private void writeObject(ObjectOutputStream stream) throws IOException {
            stream.writeObject(this.subjectId);
            stream.writeObject(this.responseString);
            stream.writeObject(this.assertionString);
            stream.writeObject(this.sessionIndex);
            if (this.accessTokenResponseBean != null) {
                stream.writeObject(this.accessTokenResponseBean.toString());
            } else {
                stream.writeObject(EMPTY_STRING);
            }
            stream.writeObject(this.subjectAttributes);
        }

        private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException, SSOAgentException {
            this.subjectId = (String)stream.readObject();
            this.responseString = (String)stream.readObject();
            if (this.responseString != null && !EMPTY_STRING.equals(this.responseString)) {
                this.response = (Response)SSOAgentUtils.unmarshall(this.responseString);
            }
            this.assertionString = (String)stream.readObject();
            if (this.responseString != null && !EMPTY_STRING.equals(this.assertionString)) {
                this.assertion = (Assertion)SSOAgentUtils.unmarshall(this.assertionString);
            }
            this.sessionIndex = (String)stream.readObject();
            String accessTokenResponseBeanString = (String)stream.readObject();
            this.accessTokenResponseBean = !EMPTY_STRING.equals(accessTokenResponseBeanString) ? this.accessTokenResponseBean.deSerialize(accessTokenResponseBeanString) : null;
            this.subjectAttributes = (Map)stream.readObject();
        }

        public String getSubjectId() {
            return this.subjectId;
        }

        public void setSubjectId(String subjectId) {
            this.subjectId = subjectId;
        }

        public Map<String, String> getSubjectAttributes() {
            return this.subjectAttributes;
        }

        public void setSubjectAttributes(Map<String, String> samlSSOAttributes) {
            this.subjectAttributes = samlSSOAttributes;
        }

        public String getSessionIndex() {
            return this.sessionIndex;
        }

        public void setSessionIndex(String sessionIndex) {
            this.sessionIndex = sessionIndex;
        }

        public Response getSAMLResponse() {
            return this.response;
        }

        public void setSAMLResponse(Response samlResponse) {
            this.response = samlResponse;
        }

        public String getResponseString() {
            return this.responseString;
        }

        public void setResponseString(String responseString) {
            this.responseString = responseString;
        }

        public Assertion getAssertion() {
            return this.assertion;
        }

        public void setAssertion(Assertion samlAssertion) {
            this.assertion = samlAssertion;
        }

        public String getAssertionString() {
            return this.assertionString;
        }

        public void setAssertionString(String samlAssertionString) {
            this.assertionString = samlAssertionString;
        }

        public AccessTokenResponseBean getAccessTokenResponseBean() {
            return this.accessTokenResponseBean;
        }

        public void setAccessTokenResponseBean(AccessTokenResponseBean accessTokenResponseBean) {
            this.accessTokenResponseBean = accessTokenResponseBean;
        }
    }

    public class OpenID
    implements Serializable {
        private DiscoveryInformation discoveryInformation;
        private String claimedId;
        private Map<String, List<String>> subjectAttributes;

        public DiscoveryInformation getDiscoveryInformation() {
            return this.discoveryInformation;
        }

        public void setDiscoveryInformation(DiscoveryInformation discoveryInformation) {
            this.discoveryInformation = discoveryInformation;
        }

        public String getClaimedId() {
            return this.claimedId;
        }

        public void setClaimedId(String claimedId) {
            this.claimedId = claimedId;
        }

        public Map<String, List<String>> getSubjectAttributes() {
            return this.subjectAttributes;
        }

        public void setSubjectAttributes(Map<String, List<String>> subjectAttributes) {
            this.subjectAttributes = subjectAttributes;
        }
    }

    public static class AccessTokenResponseBean
    implements Serializable {
        @XmlAttribute(name="access_token")
        @SerializedName(value="access_token")
        private String accessToken;
        @XmlAttribute(name="refresh_token")
        @SerializedName(value="refresh_token")
        private String refreshToken;
        @XmlAttribute(name="token_type")
        @SerializedName(value="token_type")
        private String tokenType;
        @XmlAttribute(name="expires_in")
        @SerializedName(value="expires_in")
        private String expiresIn;

        public String getAccessToken() {
            return this.accessToken;
        }

        public void setAccessToken(String accessToken) {
            this.accessToken = accessToken;
        }

        public String getRefreshToken() {
            return this.refreshToken;
        }

        public void setRefreshToken(String refreshToken) {
            this.refreshToken = refreshToken;
        }

        public String getTokenType() {
            return this.tokenType;
        }

        public void setTokenType(String tokenType) {
            this.tokenType = tokenType;
        }

        public String getExpiresIn() {
            return this.expiresIn;
        }

        public void setExpiresIn(String expiresIn) {
            this.expiresIn = expiresIn;
        }

        public String toString() {
            Gson gson = new Gson();
            return gson.toJson((Object)this);
        }

        public AccessTokenResponseBean deSerialize(String accessTokenResponseBeanString) {
            Gson gson = new Gson();
            return (AccessTokenResponseBean)gson.fromJson(accessTokenResponseBeanString, AccessTokenResponseBean.class);
        }
    }
}

