/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.sso.agent;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.commons.lang.StringUtils;
import org.wso2.carbon.identity.sso.agent.bean.SSOAgentConfig;
import org.wso2.carbon.identity.sso.agent.exception.SSOAgentException;
import org.wso2.carbon.identity.sso.agent.security.SSOAgentX509KeyStoreCredential;

public class SSOAgentContextEventListener
implements ServletContextListener {
    private static Logger logger = Logger.getLogger(SSOAgentContextEventListener.class.getName());

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        Properties properties = new Properties();
        try {
            ServletContext servletContext = servletContextEvent.getServletContext();
            String propertyFileName = servletContext.getInitParameter("property-file");
            if (!StringUtils.isNotBlank((String)propertyFileName)) {
                throw new SSOAgentException("property-file context-param is not specified in the web.xml");
            }
            properties.load(servletContextEvent.getServletContext().getResourceAsStream("/WEB-INF/classes/" + propertyFileName));
            String certificateFileName = servletContext.getInitParameter("certificate-file");
            if (!StringUtils.isNotBlank((String)certificateFileName)) {
                throw new SSOAgentException("certificate-file context-param is not specified in the web.xml");
            }
            InputStream keyStoreInputStream = servletContext.getResourceAsStream("/WEB-INF/classes/" + certificateFileName);
            SSOAgentX509KeyStoreCredential credential = new SSOAgentX509KeyStoreCredential(keyStoreInputStream, properties.getProperty("KeyStorePassword").toCharArray(), properties.getProperty("IdPPublicCertAlias"), properties.getProperty("PrivateKeyAlias"), properties.getProperty("PrivateKeyPassword").toCharArray());
            SSOAgentConfig config = new SSOAgentConfig();
            config.initConfig(properties);
            config.getSAML2().setSSOAgentX509Credential(credential);
            servletContext.setAttribute("org.wso2.carbon.identity.sso.agent.SSOAgentConfig", (Object)config);
        }
        catch (IOException | SSOAgentException e) {
            logger.log(Level.SEVERE, ((Throwable)e).getMessage(), (Throwable)e);
        }
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
    }
}

