/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.sso.agent;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opensaml.saml.common.SignableSAMLObject;
import org.opensaml.saml.saml2.core.LogoutResponse;
import org.wso2.carbon.identity.sso.agent.bean.SSOAgentConfig;
import org.wso2.carbon.identity.sso.agent.exception.InvalidSessionException;
import org.wso2.carbon.identity.sso.agent.exception.SSOAgentException;
import org.wso2.carbon.identity.sso.agent.oauth2.SAML2GrantManager;
import org.wso2.carbon.identity.sso.agent.openid.OpenIDManager;
import org.wso2.carbon.identity.sso.agent.saml.SAML2SSOManager;
import org.wso2.carbon.identity.sso.agent.util.SSOAgentFilterUtils;
import org.wso2.carbon.identity.sso.agent.util.SSOAgentRequestResolver;
import org.wso2.carbon.identity.sso.agent.util.SSOAgentUtils;

public class SAML2SSOAgentFilter
implements Filter {
    private static final Logger LOGGER = Logger.getLogger("org.wso2.carbon.identity.sso.agent");
    protected FilterConfig filterConfig = null;

    public void init(FilterConfig fConfig) throws ServletException {
        this.filterConfig = fConfig;
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        try {
            SSOAgentConfig ssoAgentConfig = SSOAgentFilterUtils.getSSOAgentConfig(this.filterConfig);
            SSOAgentRequestResolver resolver = new SSOAgentRequestResolver(request, response, ssoAgentConfig);
            if (resolver.isURLToSkip()) {
                chain.doFilter(servletRequest, servletResponse);
                return;
            }
            if (resolver.isSLORequest()) {
                SAML2SSOManager samlSSOManager = new SAML2SSOManager(ssoAgentConfig);
                LogoutResponse logoutResponse = samlSSOManager.doSLO(request);
                String encodedRequestMessage = samlSSOManager.buildPostResponse((SignableSAMLObject)logoutResponse);
                SSOAgentUtils.sendPostResponse(request, response, encodedRequestMessage);
                return;
            }
            if (resolver.isSAML2SSOResponse()) {
                SAML2SSOManager samlSSOManager = new SAML2SSOManager(ssoAgentConfig);
                try {
                    samlSSOManager.processResponse(request, response);
                }
                catch (SSOAgentException e) {
                    this.handleException(request, e);
                }
            } else if (resolver.isSAML2ArtifactResponse()) {
                SAML2SSOManager samlSSOManager = new SAML2SSOManager(ssoAgentConfig);
                try {
                    samlSSOManager.processArtifactResponse(request);
                }
                catch (SSOAgentException e) {
                    this.handleException(request, e);
                }
            } else if (resolver.isOpenIdLoginResponse()) {
                OpenIDManager openIdManager = new OpenIDManager(ssoAgentConfig);
                try {
                    openIdManager.processOpenIDLoginResponse(request, response);
                }
                catch (SSOAgentException e) {
                    this.handleException(request, e);
                }
            } else {
                if (resolver.isSLOURL()) {
                    SAML2SSOManager samlSSOManager = new SAML2SSOManager(ssoAgentConfig);
                    if (resolver.isHttpPostBinding()) {
                        boolean isPassiveAuth = ssoAgentConfig.getSAML2().isPassiveAuthn();
                        ssoAgentConfig.getSAML2().setPassiveAuthn(false);
                        String htmlPayload = samlSSOManager.buildPostRequest(request, response, true);
                        ssoAgentConfig.getSAML2().setPassiveAuthn(isPassiveAuth);
                        SSOAgentUtils.sendPostResponse(request, response, htmlPayload);
                    } else {
                        boolean isPassiveAuth = ssoAgentConfig.getSAML2().isPassiveAuthn();
                        ssoAgentConfig.getSAML2().setPassiveAuthn(false);
                        String redirectUrl = samlSSOManager.buildRedirectRequest(request, true);
                        ssoAgentConfig.getSAML2().setPassiveAuthn(isPassiveAuth);
                        response.sendRedirect(redirectUrl);
                    }
                    return;
                }
                if (resolver.isSAML2SSOURL()) {
                    SAML2SSOManager samlSSOManager = new SAML2SSOManager(ssoAgentConfig);
                    if (resolver.isHttpPostBinding()) {
                        String htmlPayload = samlSSOManager.buildPostRequest(request, response, false);
                        SSOAgentUtils.sendPostResponse(request, response, htmlPayload);
                        return;
                    }
                    response.sendRedirect(samlSSOManager.buildRedirectRequest(request, false));
                    return;
                }
                if (resolver.isPassiveAuthnRequest()) {
                    SAML2SSOManager samlSSOManager = new SAML2SSOManager(ssoAgentConfig);
                    boolean isPassiveAuth = ssoAgentConfig.getSAML2().isPassiveAuthn();
                    ssoAgentConfig.getSAML2().setPassiveAuthn(true);
                    String redirectUrl = samlSSOManager.buildRedirectRequest(request, false);
                    ssoAgentConfig.getSAML2().setPassiveAuthn(isPassiveAuth);
                    response.sendRedirect(redirectUrl);
                    return;
                }
                if (resolver.isSAML2OAuth2GrantRequest()) {
                    SAML2GrantManager saml2GrantManager = new SAML2GrantManager(ssoAgentConfig);
                    saml2GrantManager.getAccessToken(request, response);
                }
            }
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        catch (InvalidSessionException e) {
            LOGGER.log(Level.FINE, "Invalid Session!", (Throwable)((Object)e));
            response.sendRedirect(this.filterConfig.getServletContext().getContextPath());
        }
    }

    public void destroy() {
    }

    protected void handleException(HttpServletRequest request, SSOAgentException e) throws SSOAgentException {
        if (request.getSession(false) != null) {
            request.getSession(false).removeAttribute("org.wso2.carbon.identity.sso.agent.LoggedInSessionBean");
        }
        throw e;
    }
}

