/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.sso.agent;

import java.io.IOException;
import java.util.logging.Logger;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.wso2.carbon.identity.sso.agent.bean.SSOAgentConfig;
import org.wso2.carbon.identity.sso.agent.exception.InvalidSessionException;
import org.wso2.carbon.identity.sso.agent.exception.SSOAgentException;
import org.wso2.carbon.identity.sso.agent.openid.OpenIDManager;
import org.wso2.carbon.identity.sso.agent.util.SSOAgentFilterUtils;
import org.wso2.carbon.identity.sso.agent.util.SSOAgentRequestResolver;

public class OpenIdSSOAgentFilter
implements Filter {
    private static final Logger LOGGER = Logger.getLogger("org.wso2.carbon.identity.sso.agent");
    protected FilterConfig filterConfig = null;

    public void init(FilterConfig fConfig) throws ServletException {
        this.filterConfig = fConfig;
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        try {
            SSOAgentConfig ssoAgentConfig = SSOAgentFilterUtils.getSSOAgentConfig(this.filterConfig);
            SSOAgentRequestResolver resolver = new SSOAgentRequestResolver(request, response, ssoAgentConfig);
            if (resolver.isURLToSkip()) {
                chain.doFilter(servletRequest, servletResponse);
                return;
            }
            if (resolver.isOpenIdLoginResponse()) {
                OpenIDManager openIdManager = new OpenIDManager(ssoAgentConfig);
                try {
                    openIdManager.processOpenIDLoginResponse(request, response);
                }
                catch (SSOAgentException e) {
                    this.handleException(request, e);
                }
            } else if (resolver.isOpenIdURL()) {
                OpenIDManager openIdManager = new OpenIDManager(ssoAgentConfig);
                response.sendRedirect(openIdManager.doOpenIDLogin(request, response));
                return;
            }
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        catch (InvalidSessionException e) {
            request.setAttribute("shouldGoToWelcomePage", (Object)"true");
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        catch (SSOAgentException e) {
            throw e;
        }
    }

    public void destroy() {
    }

    protected void handleException(HttpServletRequest request, SSOAgentException e) throws SSOAgentException {
        if (request.getSession(false) != null) {
            request.getSession(false).removeAttribute("org.wso2.carbon.identity.sso.agent.LoggedInSessionBean");
        }
        throw e;
    }
}

