/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.output.adapter.wso2event;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.wso2.carbon.event.output.adapter.core.OutputEventAdapter;
import org.wso2.carbon.event.output.adapter.core.OutputEventAdapterConfiguration;
import org.wso2.carbon.event.output.adapter.core.OutputEventAdapterFactory;
import org.wso2.carbon.event.output.adapter.core.Property;
import org.wso2.carbon.event.output.adapter.wso2event.WSO2EventAdapter;

public class WSO2EventAdapterFactory
extends OutputEventAdapterFactory {
    ResourceBundle resourceBundle = ResourceBundle.getBundle("org.wso2.carbon.event.output.adapter.wso2event.i18n.Resources", Locale.getDefault());

    public String getType() {
        return "wso2event";
    }

    public List<String> getSupportedMessageFormats() {
        ArrayList<String> supportOutputMessageTypes = new ArrayList<String>();
        supportOutputMessageTypes.add("wso2event");
        return supportOutputMessageTypes;
    }

    public List<Property> getStaticPropertyList() {
        ArrayList<Property> propertyList = new ArrayList<Property>();
        Property ipProperty = new Property("receiverURL");
        ipProperty.setDisplayName(this.resourceBundle.getString("receiverURL"));
        ipProperty.setRequired(false);
        ipProperty.setHint(this.resourceBundle.getString("enterReceiverUrl"));
        Property authenticatorIpProperty = new Property("authenticatorURL");
        authenticatorIpProperty.setDisplayName(this.resourceBundle.getString("authenticatorURL"));
        authenticatorIpProperty.setRequired(false);
        authenticatorIpProperty.setHint(this.resourceBundle.getString("enterAuthenticatorUrl"));
        Property userNameProperty = new Property("username");
        userNameProperty.setRequired(true);
        userNameProperty.setDisplayName(this.resourceBundle.getString("username"));
        userNameProperty.setHint(this.resourceBundle.getString("enterUsername"));
        Property passwordProperty = new Property("password");
        passwordProperty.setRequired(true);
        passwordProperty.setSecured(true);
        passwordProperty.setEncrypted(true);
        passwordProperty.setDisplayName(this.resourceBundle.getString("password"));
        passwordProperty.setHint(this.resourceBundle.getString("enterPassword"));
        Property protocolProperty = new Property("protocol");
        protocolProperty.setRequired(true);
        protocolProperty.setDefaultValue("thrift");
        protocolProperty.setOptions(new String[]{"thrift", "binary"});
        protocolProperty.setDisplayName(this.resourceBundle.getString("protocol"));
        protocolProperty.setHint(this.resourceBundle.getString("selectProtocol"));
        Property publishingModeProperty = new Property("publishingMode");
        publishingModeProperty.setDefaultValue("non-blocking");
        publishingModeProperty.setOptions(new String[]{"blocking", "non-blocking"});
        publishingModeProperty.setDisplayName(this.resourceBundle.getString("publishingMode"));
        publishingModeProperty.setHint(this.resourceBundle.getString("selectPublishingMode"));
        Property publishTimeoutProperty = new Property("publishTimeout");
        publishTimeoutProperty.setDefaultValue("0");
        publishTimeoutProperty.setDisplayName(this.resourceBundle.getString("publishTimeout"));
        publishTimeoutProperty.setHint(this.resourceBundle.getString("enterPublishTimeout"));
        propertyList.add(ipProperty);
        propertyList.add(authenticatorIpProperty);
        propertyList.add(userNameProperty);
        propertyList.add(passwordProperty);
        propertyList.add(protocolProperty);
        propertyList.add(publishingModeProperty);
        propertyList.add(publishTimeoutProperty);
        return propertyList;
    }

    public List<Property> getDynamicPropertyList() {
        return null;
    }

    public String getUsageTips() {
        return this.resourceBundle.getString("wso2event.usage.tips");
    }

    public OutputEventAdapter createEventAdapter(OutputEventAdapterConfiguration eventAdapterConfiguration, Map<String, String> globalProperties) {
        return new WSO2EventAdapter(eventAdapterConfiguration, globalProperties);
    }
}

