/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.output.adapter.wso2event;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.databridge.agent.AgentHolder;
import org.wso2.carbon.databridge.agent.DataPublisher;
import org.wso2.carbon.databridge.agent.exception.DataEndpointAgentConfigurationException;
import org.wso2.carbon.databridge.agent.exception.DataEndpointAuthenticationException;
import org.wso2.carbon.databridge.agent.exception.DataEndpointConfigurationException;
import org.wso2.carbon.databridge.agent.exception.DataEndpointException;
import org.wso2.carbon.databridge.commons.Event;
import org.wso2.carbon.databridge.commons.exception.TransportException;
import org.wso2.carbon.event.output.adapter.core.EventAdapterUtil;
import org.wso2.carbon.event.output.adapter.core.OutputEventAdapter;
import org.wso2.carbon.event.output.adapter.core.OutputEventAdapterConfiguration;
import org.wso2.carbon.event.output.adapter.core.exception.ConnectionUnavailableException;
import org.wso2.carbon.event.output.adapter.core.exception.OutputEventAdapterException;
import org.wso2.carbon.event.output.adapter.core.exception.OutputEventAdapterRuntimeException;
import org.wso2.carbon.event.output.adapter.core.exception.TestConnectionNotSupportedException;

public final class WSO2EventAdapter
implements OutputEventAdapter {
    private static final Log log = LogFactory.getLog(WSO2EventAdapter.class);
    private final OutputEventAdapterConfiguration eventAdapterConfiguration;
    private final Map<String, String> globalProperties;
    private DataPublisher dataPublisher = null;
    private boolean isBlockingMode = false;
    private long timeout = 0L;
    private int tenantId;
    private String authUrl;
    private String receiverUrl;
    private String protocol;

    public WSO2EventAdapter(OutputEventAdapterConfiguration eventAdapterConfiguration, Map<String, String> globalProperties) {
        this.eventAdapterConfiguration = eventAdapterConfiguration;
        this.globalProperties = globalProperties;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void init() throws OutputEventAdapterException {
        this.validateOutputEventAdapterConfigurations();
        this.tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
        String configPath = this.globalProperties.get("config.path");
        if (configPath != null) {
            AgentHolder.setConfigPath((String)configPath);
        }
        this.authUrl = (String)this.eventAdapterConfiguration.getStaticProperties().get("authenticatorURL");
        this.receiverUrl = (String)this.eventAdapterConfiguration.getStaticProperties().get("receiverURL");
        this.protocol = (String)this.eventAdapterConfiguration.getStaticProperties().get("protocol");
        if (this.receiverUrl != null) return;
        if (this.protocol.equals("thrift")) {
            String defaultTCPUrl = this.globalProperties.get("default.thrift.tcp.url");
            String defaultSSLUrl = this.globalProperties.get("default.thrift.ssl.url");
            if (defaultTCPUrl == null) throw new OutputEventAdapterException("Cannot deploy WSO2Event Publisher " + this.eventAdapterConfiguration.getName() + " , since there is no any thrift url specified in global/event publisher configuration");
            this.receiverUrl = defaultTCPUrl;
            if (this.authUrl == null && defaultSSLUrl != null) {
                this.authUrl = defaultSSLUrl;
            }
            if (!log.isDebugEnabled()) return;
            log.debug((Object)("Thirft TCP url is not specified for WSO2Event Publisher " + this.eventAdapterConfiguration.getName() + " ,hence using default thrift url " + defaultTCPUrl));
            return;
        } else {
            String defaultTCPUrl = this.globalProperties.get("default.binary.tcp.url");
            String defaultSSLUrl = this.globalProperties.get("default.binary.ssl.url");
            if (defaultTCPUrl == null) throw new OutputEventAdapterException("Cannot deploy WSO2Event Publisher " + this.eventAdapterConfiguration.getName() + " , since there is no any binary url specified in global/event publisher configuration");
            this.receiverUrl = defaultTCPUrl;
            if (this.authUrl == null && defaultSSLUrl != null) {
                this.authUrl = defaultSSLUrl;
            }
            if (!log.isDebugEnabled()) return;
            log.debug((Object)("Thirft TCP url is not specified for WSO2Event Publisher " + this.eventAdapterConfiguration.getName() + " ,hence using default binary url " + defaultTCPUrl));
        }
    }

    public void testConnect() throws TestConnectionNotSupportedException {
        this.connect();
    }

    public synchronized void connect() {
        String userName = (String)this.eventAdapterConfiguration.getStaticProperties().get("username");
        String password = (String)this.eventAdapterConfiguration.getStaticProperties().get("password");
        String publishingMode = (String)this.eventAdapterConfiguration.getStaticProperties().get("publishingMode");
        String timeoutString = (String)this.eventAdapterConfiguration.getStaticProperties().get("publishTimeout");
        if (publishingMode.equalsIgnoreCase("blocking")) {
            this.isBlockingMode = true;
        } else {
            this.timeout = Long.parseLong(timeoutString);
        }
        try {
            this.dataPublisher = this.authUrl != null && this.authUrl.length() > 0 ? new DataPublisher(this.protocol, this.receiverUrl, this.authUrl, userName, password) : new DataPublisher(this.protocol, this.receiverUrl, null, userName, password);
        }
        catch (DataEndpointAgentConfigurationException e) {
            this.throwRuntimeException(this.receiverUrl, this.authUrl, this.protocol, userName, (Exception)((Object)e));
        }
        catch (DataEndpointException e) {
            this.throwConnectionException(this.receiverUrl, this.authUrl, this.protocol, userName, (Exception)((Object)e));
        }
        catch (DataEndpointConfigurationException e) {
            this.throwRuntimeException(this.receiverUrl, this.authUrl, this.protocol, userName, (Exception)((Object)e));
        }
        catch (DataEndpointAuthenticationException e) {
            this.throwConnectionException(this.receiverUrl, this.authUrl, this.protocol, userName, (Exception)((Object)e));
        }
        catch (TransportException e) {
            this.throwConnectionException(this.receiverUrl, this.authUrl, this.protocol, userName, (Exception)((Object)e));
        }
    }

    public void publish(Object message, Map<String, String> dynamicProperties) {
        Event event = (Event)message;
        if (this.isBlockingMode) {
            this.dataPublisher.publish(event);
        } else if (!this.dataPublisher.tryPublish(event, this.timeout)) {
            EventAdapterUtil.logAndDrop((String)this.eventAdapterConfiguration.getName(), (Object)message, (String)"Cannot send event", (Log)log, (int)this.tenantId);
        }
    }

    public void disconnect() {
        if (this.dataPublisher != null) {
            try {
                this.dataPublisher.shutdown();
            }
            catch (DataEndpointException e) {
                String userName = (String)this.eventAdapterConfiguration.getStaticProperties().get("username");
                String authUrl = (String)this.eventAdapterConfiguration.getStaticProperties().get("authenticatorURL");
                String receiverUrl = (String)this.eventAdapterConfiguration.getStaticProperties().get("receiverURL");
                String protocol = (String)this.eventAdapterConfiguration.getStaticProperties().get("protocol");
                this.logException("Error in shutting down the data publisher", receiverUrl, authUrl, protocol, userName, (Exception)((Object)e));
            }
        }
    }

    public void destroy() {
    }

    public boolean isPolled() {
        return false;
    }

    private void validateOutputEventAdapterConfigurations() throws OutputEventAdapterException {
        String timeoutProperty = (String)this.eventAdapterConfiguration.getStaticProperties().get("publishTimeout");
        if (timeoutProperty != null) {
            try {
                Long.parseLong(timeoutProperty);
            }
            catch (NumberFormatException e) {
                throw new OutputEventAdapterException("Invalid value set for property 'Publishing Timeout': " + timeoutProperty, (Throwable)e);
            }
        }
    }

    private void throwRuntimeException(String receiverUrl, String authUrl, String protocol, String userName, Exception e) {
        throw new OutputEventAdapterRuntimeException("Error in data-bridge config for adapter " + this.eventAdapterConfiguration.getName() + " with the receiverUrl:" + receiverUrl + " authUrl:" + authUrl + " protocol:" + protocol + " and userName:" + userName + "," + e.getMessage(), (Throwable)e);
    }

    private void logException(String message, String receiverUrl, String authUrl, String protocol, String userName, Exception e) {
        log.error((Object)(message + " for adapter " + this.eventAdapterConfiguration.getName() + " with the receiverUrl:" + receiverUrl + " authUrl:" + authUrl + " protocol:" + protocol + " and userName:" + userName + "," + e.getMessage()), (Throwable)e);
    }

    private void throwConnectionException(String receiverUrl, String authUrl, String protocol, String userName, Exception e) {
        throw new ConnectionUnavailableException("Connection not available for adapter " + this.eventAdapterConfiguration.getName() + " with the receiverUrl:" + receiverUrl + " authUrl:" + authUrl + " protocol:" + protocol + " and userName:" + userName + "," + e.getMessage(), (Throwable)e);
    }
}

