/*
 * Decompiled with CFR 0.152.
 */
package org.jaggeryjs.hostobjects.file;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.activation.FileTypeMap;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jaggeryjs.hostobjects.file.JavaScriptFile;
import org.jaggeryjs.hostobjects.file.JavaScriptFileManager;
import org.jaggeryjs.hostobjects.file.JavaScriptFileManagerImpl;
import org.jaggeryjs.hostobjects.stream.StreamHostObject;
import org.jaggeryjs.scriptengine.engine.JaggeryContext;
import org.jaggeryjs.scriptengine.engine.RhinoEngine;
import org.jaggeryjs.scriptengine.exceptions.ScriptException;
import org.jaggeryjs.scriptengine.util.HostObjectUtil;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.wso2.carbon.utils.CarbonUtils;

public class FileHostObject
extends ScriptableObject {
    private static final Log log = LogFactory.getLog(FileHostObject.class);
    private static final String hostObjectName = "File";
    public static final String JAVASCRIPT_FILE_MANAGER = "hostobjects.file.filemanager";
    private static final String RESOURCE_MEDIA_TYPE_MAPPINGS_FILE = "mime.types";
    private static boolean mimeMapLoaded = false;
    private JavaScriptFile file = null;
    private JavaScriptFileManager manager = null;
    private Context context = null;
    private String path;

    public static Scriptable jsConstructor(Context cx, Object[] args, Function ctorObj, boolean inNewExpr) throws ScriptException {
        int argsCount = args.length;
        if (argsCount != 1) {
            HostObjectUtil.invalidNumberOfArgs((String)hostObjectName, (String)hostObjectName, (int)argsCount, (boolean)true);
        }
        FileHostObject fho = new FileHostObject();
        JaggeryContext context = (JaggeryContext)RhinoEngine.getContextProperty((Object)"engine.jaggeryContext");
        Object obj = context.getProperty(JAVASCRIPT_FILE_MANAGER);
        fho.manager = obj instanceof JavaScriptFileManager ? (JavaScriptFileManager)obj : new JavaScriptFileManagerImpl();
        fho.file = fho.manager.getJavaScriptFile(args[0]);
        fho.file.construct();
        fho.context = cx;
        return fho;
    }

    public String getClassName() {
        return hostObjectName;
    }

    public static void jsFunction_open(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws ScriptException {
        String functionName = "open";
        int argsCount = args.length;
        if (argsCount != 1) {
            HostObjectUtil.invalidNumberOfArgs((String)hostObjectName, (String)functionName, (int)argsCount, (boolean)false);
        }
        if (!(args[0] instanceof String)) {
            HostObjectUtil.invalidArgsError((String)hostObjectName, (String)functionName, (String)"1", (String)"string", (Object)args[0], (boolean)false);
        }
        FileHostObject fho = (FileHostObject)thisObj;
        fho.file.open((String)args[0]);
    }

    public static void jsFunction_write(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws ScriptException {
        String functionName = "write";
        int argsCount = args.length;
        if (argsCount != 1) {
            HostObjectUtil.invalidNumberOfArgs((String)hostObjectName, (String)functionName, (int)argsCount, (boolean)false);
        }
        Object data = args[0];
        FileHostObject fho = (FileHostObject)thisObj;
        if (data instanceof InputStream) {
            fho.file.write((InputStream)data);
        } else if (data instanceof StreamHostObject) {
            fho.file.write(((StreamHostObject)data).getStream());
        } else {
            fho.file.write(HostObjectUtil.serializeObject((Object)args[0]));
        }
    }

    public static String jsFunction_read(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws ScriptException {
        String functionName = "read";
        int argsCount = args.length;
        if (argsCount != 1) {
            HostObjectUtil.invalidNumberOfArgs((String)hostObjectName, (String)functionName, (int)argsCount, (boolean)false);
        }
        if (!(args[0] instanceof Number)) {
            HostObjectUtil.invalidArgsError((String)hostObjectName, (String)functionName, (String)"1", (String)"string", (Object)args[0], (boolean)false);
        }
        FileHostObject fho = (FileHostObject)thisObj;
        int count = ((Number)args[0]).intValue();
        return fho.file.read(count);
    }

    public static String jsFunction_readAll(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws ScriptException {
        String functionName = "readAll";
        int argsCount = args.length;
        if (argsCount != 0) {
            HostObjectUtil.invalidNumberOfArgs((String)hostObjectName, (String)functionName, (int)argsCount, (boolean)false);
        }
        FileHostObject fho = (FileHostObject)thisObj;
        return fho.file.readAll();
    }

    public static void jsFunction_close(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws ScriptException {
        String functionName = "close";
        int argsCount = args.length;
        if (argsCount != 0) {
            HostObjectUtil.invalidNumberOfArgs((String)hostObjectName, (String)functionName, (int)argsCount, (boolean)false);
        }
        FileHostObject fho = (FileHostObject)thisObj;
        fho.file.close();
    }

    public static boolean jsFunction_move(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws ScriptException {
        String functionName = "move";
        int argsCount = args.length;
        if (argsCount != 1) {
            HostObjectUtil.invalidNumberOfArgs((String)hostObjectName, (String)functionName, (int)argsCount, (boolean)false);
        }
        if (!(args[0] instanceof String)) {
            HostObjectUtil.invalidArgsError((String)hostObjectName, (String)functionName, (String)"1", (String)"string", (Object)args[0], (boolean)false);
        }
        FileHostObject fho = (FileHostObject)thisObj;
        String dest = fho.manager.getJavaScriptFile(args[0]).getURI();
        return fho.file.move(dest);
    }

    public static boolean jsFunction_saveAs(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws ScriptException {
        String functionName = "saveAs";
        int argsCount = args.length;
        if (argsCount != 1) {
            HostObjectUtil.invalidNumberOfArgs((String)hostObjectName, (String)functionName, (int)argsCount, (boolean)false);
        }
        if (!(args[0] instanceof String)) {
            HostObjectUtil.invalidArgsError((String)hostObjectName, (String)functionName, (String)"1", (String)"string", (Object)args[0], (boolean)false);
        }
        FileHostObject fho = (FileHostObject)thisObj;
        String dest = fho.manager.getJavaScriptFile(args[0]).getURI();
        return fho.file.saveAs(dest);
    }

    public static boolean jsFunction_del(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws ScriptException {
        String functionName = "del";
        int argsCount = args.length;
        if (argsCount != 0) {
            HostObjectUtil.invalidNumberOfArgs((String)hostObjectName, (String)functionName, (int)argsCount, (boolean)false);
        }
        FileHostObject fho = (FileHostObject)thisObj;
        return fho.file.del();
    }

    public static long jsFunction_getLength(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws ScriptException {
        String functionName = "getLength";
        int argsCount = args.length;
        if (argsCount != 0) {
            HostObjectUtil.invalidNumberOfArgs((String)hostObjectName, (String)functionName, (int)argsCount, (boolean)false);
        }
        FileHostObject fho = (FileHostObject)thisObj;
        return fho.file.getLength();
    }

    public static long jsFunction_getLastModified(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws ScriptException {
        String functionName = "getLastModified";
        int argsCount = args.length;
        if (argsCount != 0) {
            HostObjectUtil.invalidNumberOfArgs((String)hostObjectName, (String)functionName, (int)argsCount, (boolean)false);
        }
        FileHostObject fho = (FileHostObject)thisObj;
        return fho.file.getLastModified();
    }

    public static String jsFunction_getName(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws ScriptException {
        String functionName = "getName";
        int argsCount = args.length;
        if (argsCount != 0) {
            HostObjectUtil.invalidNumberOfArgs((String)hostObjectName, (String)functionName, (int)argsCount, (boolean)false);
        }
        FileHostObject fho = (FileHostObject)thisObj;
        return fho.file.getName();
    }

    public static boolean jsFunction_isExists(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws ScriptException {
        String functionName = "isExists";
        int argsCount = args.length;
        if (argsCount != 0) {
            HostObjectUtil.invalidNumberOfArgs((String)hostObjectName, (String)functionName, (int)argsCount, (boolean)false);
        }
        FileHostObject fho = (FileHostObject)thisObj;
        return fho.file.isExist();
    }

    public static String jsFunction_getContentType(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws ScriptException {
        String functionName = "getContentType";
        int argsCount = args.length;
        if (argsCount != 0) {
            HostObjectUtil.invalidNumberOfArgs((String)hostObjectName, (String)functionName, (int)argsCount, (boolean)false);
        }
        FileHostObject fho = (FileHostObject)thisObj;
        if (!mimeMapLoaded) {
            FileTypeMap.setDefaultFileTypeMap((FileTypeMap)FileHostObject.loadMimeMap());
            mimeMapLoaded = true;
        }
        return fho.file.getContentType();
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"})
    private static FileTypeMap loadMimeMap() throws ScriptException {
        String[] lines;
        String mappings;
        String configDirPath = CarbonUtils.getEtcCarbonConfigDirPath();
        File configFile = new File(configDirPath, RESOURCE_MEDIA_TYPE_MAPPINGS_FILE);
        if (!configFile.exists()) {
            String msg = "Resource media type definitions file (mime.types) file does not exist in the path " + configDirPath;
            log.error((Object)msg);
            throw new ScriptException(msg);
        }
        final HashMap<String, String> mimeMappings = new HashMap<String, String>();
        try {
            mappings = FileUtils.readFileToString((File)configFile, (String)"UTF-8");
        }
        catch (IOException e) {
            String msg = "Error opening resource media type definitions file (mime.types) : " + e.getMessage();
            throw new ScriptException(msg, (Exception)e);
        }
        for (String line : lines = mappings.split("[\\r\\n]+")) {
            if (line.startsWith("#")) continue;
            String[] parts = line.split("\\s+");
            for (int i = 1; i < parts.length; ++i) {
                mimeMappings.put(parts[i], parts[0]);
            }
        }
        return new FileTypeMap(){

            public String getContentType(File file) {
                return this.getContentType(file.getName());
            }

            public String getContentType(String fileName) {
                String mimeType;
                int i = fileName.lastIndexOf(46);
                if (i > 0 && (mimeType = (String)mimeMappings.get(fileName.substring(i + 1))) != null) {
                    return mimeType;
                }
                return "application/octet-stream";
            }
        };
    }

    public static Scriptable jsFunction_getStream(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws ScriptException {
        String functionName = "getStream";
        int argsCount = args.length;
        if (argsCount != 0) {
            HostObjectUtil.invalidNumberOfArgs((String)hostObjectName, (String)functionName, (int)argsCount, (boolean)false);
        }
        FileHostObject fho = (FileHostObject)thisObj;
        return fho.context.newObject(thisObj, "Stream", new Object[]{fho.file.getInputStream()});
    }

    public InputStream getInputStream() throws ScriptException {
        return this.file.getInputStream();
    }

    public OutputStream getOutputStream() throws ScriptException {
        return this.file.getOutputStream();
    }

    public String getName() throws ScriptException {
        String fileName = this.file.getName();
        fileName = FilenameUtils.getName((String)fileName);
        return fileName;
    }

    public JavaScriptFile getJavaScriptFile() throws ScriptException {
        return this.file;
    }

    public static boolean jsFunction_isDirectory(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws ScriptException {
        String functionName = "isDirectory";
        int argsCount = args.length;
        if (argsCount != 0) {
            HostObjectUtil.invalidNumberOfArgs((String)hostObjectName, (String)functionName, (int)argsCount, (boolean)false);
        }
        FileHostObject fho = (FileHostObject)thisObj;
        return fho.file.isDirectory();
    }

    public static String jsFunction_getPath(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws ScriptException {
        String functionName = "getPath";
        int argsCount = args.length;
        if (argsCount != 0) {
            HostObjectUtil.invalidNumberOfArgs((String)hostObjectName, (String)functionName, (int)argsCount, (boolean)false);
        }
        FileHostObject fho = (FileHostObject)thisObj;
        return fho.file.getURI();
    }

    public static boolean jsFunction_mkdir(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws ScriptException {
        String functionName = "mkdir";
        int argsCount = args.length;
        if (argsCount != 0) {
            HostObjectUtil.invalidNumberOfArgs((String)hostObjectName, (String)functionName, (int)argsCount, (boolean)false);
        }
        FileHostObject fho = (FileHostObject)thisObj;
        return fho.file.mkdir();
    }

    public static Object jsFunction_listFiles(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws ScriptException {
        String functionName = "listFiles";
        int argsCount = args.length;
        if (argsCount != 0) {
            HostObjectUtil.invalidNumberOfArgs((String)hostObjectName, (String)functionName, (int)argsCount, (boolean)false);
        }
        FileHostObject fho = (FileHostObject)thisObj;
        ArrayList<String> fpaths = fho.file.listFiles();
        ArrayList<Scriptable> fhol = new ArrayList<Scriptable>();
        for (String jsf : fpaths) {
            fhol.add(fho.context.newObject(thisObj, hostObjectName, new Object[]{jsf}));
        }
        return cx.newArray(thisObj, fhol.toArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN", "PATH_TRAVERSAL_IN", "PATH_TRAVERSAL_IN"})
    public static boolean jsFunction_unZip(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws ScriptException, IOException {
        String functionName = "unZip";
        int argsCount = args.length;
        if (argsCount != 1) {
            HostObjectUtil.invalidNumberOfArgs((String)hostObjectName, (String)functionName, (int)argsCount, (boolean)false);
        }
        FileHostObject fho = (FileHostObject)thisObj;
        ZipInputStream zin = null;
        FilterOutputStream out = null;
        if (!fho.file.isExist()) {
            log.error((Object)"Zip file not exists");
            return false;
        }
        JaggeryContext context = (JaggeryContext)RhinoEngine.getContextProperty((Object)"engine.jaggeryContext");
        Object obj = context.getProperty(JAVASCRIPT_FILE_MANAGER);
        fho.manager = obj instanceof JavaScriptFileManager ? (JavaScriptFileManager)obj : new JavaScriptFileManagerImpl();
        File zipfile = new File(fho.manager.getFile(fho.file.getPath()).getAbsolutePath());
        File outdir = new File(fho.manager.getDirectoryPath(args[0].toString()));
        if (!outdir.getParentFile().exists() && !outdir.getParentFile().mkdirs()) {
            log.error((Object)("Unable to create directories to handle file : " + fho.file.getName()));
            return false;
        }
        if (!outdir.exists() && !outdir.mkdir()) {
            log.error((Object)("Unable to create directories to handle file : " + fho.file.getName()));
            return false;
        }
        try {
            zin = new ZipInputStream(new FileInputStream(zipfile));
            byte[] buffer = new byte[1024];
lbl25:
            // 4 sources

            block26: while (true) {
                String dir;
                ZipEntry entry;
                if ((entry = zin.getNextEntry()) == null) {
                    boolean bl = true;
                    return bl;
                }
                String name = entry.getName();
                String canonicalDirPath = outdir.getCanonicalPath();
                String canonicalEntryPath = new File(canonicalDirPath + entry.getName()).getCanonicalPath();
                if (!canonicalEntryPath.startsWith(canonicalDirPath)) {
                    log.error((Object)("Invalid entry found in the Zip file: " + name));
                    boolean bl = false;
                    return bl;
                }
                if (entry.isDirectory()) {
                    FileHostObject.mkdirs(outdir, name);
                    continue;
                }
                int hasParentDirs = name.lastIndexOf(File.separatorChar);
                String string = dir = hasParentDirs == -1 ? null : name.substring(0, hasParentDirs);
                if (dir != null) {
                    FileHostObject.mkdirs(outdir, dir);
                }
                try {
                    out = new BufferedOutputStream(new FileOutputStream(new File(outdir, name)));
                    while (true) {
                        int count;
                        if ((count = zin.read(buffer)) == -1) continue block26;
                        ((BufferedOutputStream)out).write(buffer, 0, count);
                    }
                }
                catch (Exception ex) {
                    log.error((Object)("Unable to perform unZip operation for file : " + fho.file.getName()), (Throwable)ex);
                    boolean bl = false;
                    if (zin == null) return bl;
                    try {
                        zin.close();
                        return bl;
                    }
                    catch (IOException er) {
                        log.error((Object)("Unable to close the zip input stream " + er));
                    }
                    return bl;
                }
                break;
            }
        }
        catch (IOException ex) {
            log.error((Object)("Cannot unzip the file " + ex));
            throw new IOException(ex);
        }
        finally {
            if (zin != null) {
                try {
                    zin.close();
                }
                catch (IOException er) {
                    log.error((Object)("Unable to close the zip input stream " + er));
                }
            }
        }
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN", "PATH_TRAVERSAL_OUT", "PATH_TRAVERSAL_IN"})
    public static boolean jsFunction_zip(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws ScriptException, IOException {
        String functionName = "zip";
        int argsCount = args.length;
        if (argsCount != 1) {
            HostObjectUtil.invalidNumberOfArgs((String)hostObjectName, (String)functionName, (int)argsCount, (boolean)false);
        }
        FileHostObject fho = (FileHostObject)thisObj;
        DeflaterOutputStream zip = null;
        if (fho.file.isExist()) {
            JaggeryContext context = (JaggeryContext)RhinoEngine.getContextProperty((Object)"engine.jaggeryContext");
            Object obj = context.getProperty(JAVASCRIPT_FILE_MANAGER);
            fho.manager = obj instanceof JavaScriptFileManager ? (JavaScriptFileManager)obj : new JavaScriptFileManagerImpl();
            String destinationPath = fho.manager.getFile(args[0].toString()).getAbsolutePath();
            String sourcePath = fho.manager.getDirectoryPath(fho.file.getPath());
            File destinationFile = new File(destinationPath);
            if (destinationFile.getParentFile().exists() || destinationFile.getParentFile().mkdirs()) {
                try {
                    zip = new ZipOutputStream(new FileOutputStream(destinationPath));
                    File folder = new File(sourcePath);
                    if (folder.list() != null) {
                        for (String fileName : folder.list()) {
                            FileHostObject.addFileToZip("", sourcePath + File.separator + fileName, (ZipOutputStream)zip);
                        }
                    }
                    boolean bl = true;
                    return bl;
                }
                catch (IOException ex) {
                    log.error((Object)("Cannot zip the folder. " + ex));
                    throw new IOException(ex);
                }
                finally {
                    if (zip != null) {
                        try {
                            zip.flush();
                            ((ZipOutputStream)zip).close();
                        }
                        catch (IOException er) {
                            log.error((Object)("Unable to close the zip output stream " + er));
                        }
                    }
                }
            }
            log.error((Object)("Unable to create the directory path for file : " + fho.file.getName()));
        } else {
            log.error((Object)"Zip operation cannot be done. Folder not found");
        }
        return false;
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN", "PATH_TRAVERSAL_IN"})
    private static void addFileToZip(String path, String srcFile, ZipOutputStream zip) throws IOException {
        FileInputStream in = null;
        try {
            File folder = new File(srcFile);
            if (folder.isDirectory()) {
                FileHostObject.addFolderToZip(path, srcFile, zip);
            } else {
                int len;
                byte[] buf = new byte[1024];
                in = new FileInputStream(srcFile);
                zip.putNextEntry(new ZipEntry(path + File.separator + folder.getName()));
                while ((len = in.read(buf)) > 0) {
                    zip.write(buf, 0, len);
                }
            }
        }
        catch (IOException er) {
            log.error((Object)("Cannot add file to zip " + er));
            throw new IOException(er);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ex) {
                    log.error((Object)("Unable to close file input stream. " + ex));
                }
            }
        }
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"})
    private static void addFolderToZip(String path, String srcFolder, ZipOutputStream zip) throws IOException {
        File folder = new File(srcFolder);
        if (path.isEmpty()) {
            zip.putNextEntry(new ZipEntry(folder.getName() + File.separator));
        } else {
            zip.putNextEntry(new ZipEntry(path + File.separator + folder.getName() + File.separator));
        }
        for (String fileName : folder.list()) {
            if (path.isEmpty()) {
                FileHostObject.addFileToZip(folder.getName(), srcFolder + File.separator + fileName, zip);
                continue;
            }
            FileHostObject.addFileToZip(path + File.separator + folder.getName(), srcFolder + File.separator + fileName, zip);
        }
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"})
    private static boolean mkdirs(File parentDirectory, String path) {
        File dir = new File(parentDirectory, path);
        return dir.exists() || dir.mkdirs();
    }
}

