/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.output.adapter.mqtt.internal.util;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.persist.MqttDefaultFilePersistence;
import org.wso2.carbon.event.output.adapter.core.exception.ConnectionUnavailableException;
import org.wso2.carbon.event.output.adapter.core.exception.OutputEventAdapterException;
import org.wso2.carbon.event.output.adapter.core.exception.OutputEventAdapterRuntimeException;
import org.wso2.carbon.event.output.adapter.mqtt.internal.util.MQTTBrokerConnectionConfiguration;

public class MQTTAdapterPublisher {
    private static final Log log = LogFactory.getLog(MQTTAdapterPublisher.class);
    private MqttClient mqttClient;

    public MQTTAdapterPublisher(MQTTBrokerConnectionConfiguration mqttBrokerConnectionConfiguration, String clientId) {
        if (clientId == null || clientId.trim().isEmpty()) {
            clientId = MqttClient.generateClientId();
        }
        boolean cleanSession = mqttBrokerConnectionConfiguration.isCleanSession();
        int keepAlive = mqttBrokerConnectionConfiguration.getKeepAlive();
        String temp_directory = System.getProperty("java.io.tmpdir");
        MqttDefaultFilePersistence dataStore = new MqttDefaultFilePersistence(temp_directory);
        try {
            MqttConnectOptions connectionOptions = new MqttConnectOptions();
            connectionOptions.setCleanSession(cleanSession);
            connectionOptions.setKeepAliveInterval(keepAlive);
            if (mqttBrokerConnectionConfiguration.getBrokerPassword() != null) {
                connectionOptions.setPassword(mqttBrokerConnectionConfiguration.getBrokerPassword().toCharArray());
            }
            if (mqttBrokerConnectionConfiguration.getBrokerUsername() != null) {
                connectionOptions.setUserName(mqttBrokerConnectionConfiguration.getBrokerUsername());
            }
            this.mqttClient = new MqttClient(mqttBrokerConnectionConfiguration.getBrokerUrl(), clientId, (MqttClientPersistence)dataStore);
            this.mqttClient.connect(connectionOptions);
        }
        catch (MqttException e) {
            log.error((Object)("Error occurred when constructing MQTT client for broker url : " + mqttBrokerConnectionConfiguration.getBrokerUrl()), (Throwable)e);
            this.handleException(e);
        }
    }

    public void publish(int qos, String payload, String topic) {
        try {
            MqttMessage message = new MqttMessage(payload.getBytes());
            message.setQos(qos);
            this.mqttClient.publish(topic, message);
        }
        catch (MqttException e) {
            log.error((Object)("Error occurred when publishing message for MQTT server : " + this.mqttClient.getServerURI()), (Throwable)e);
            this.handleException(e);
        }
    }

    public void publish(String payload, String topic) {
        try {
            MqttMessage message = new MqttMessage(payload.getBytes());
            this.mqttClient.publish(topic, message);
        }
        catch (MqttException e) {
            log.error((Object)("Error occurred when publishing message for MQTT server : " + this.mqttClient.getServerURI()), (Throwable)e);
            this.handleException(e);
        }
    }

    public void close() throws OutputEventAdapterException {
        try {
            this.mqttClient.disconnect(1000L);
            this.mqttClient.close();
        }
        catch (MqttException e) {
            throw new OutputEventAdapterException((Throwable)e);
        }
    }

    private void handleException(MqttException e) {
        if (e.getReasonCode() == 32104) {
            throw new ConnectionUnavailableException((Throwable)e);
        }
        throw new OutputEventAdapterRuntimeException((Throwable)e);
    }
}

