/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.functions.library.mgt.ui.client;

import java.rmi.RemoteException;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.wso2.carbon.identity.functions.library.mgt.model.xsd.FunctionLibrary;
import org.wso2.carbon.identity.functions.library.mgt.stub.FunctionLibraryManagementAdminServiceFunctionLibraryManagementException;
import org.wso2.carbon.identity.functions.library.mgt.stub.FunctionLibraryManagementAdminServiceStub;

public class FunctionLibraryManagementServiceClient {
    public static final String FUNCTION_LIBRARY_MANAGEMENT_SERVICE = "FunctionLibraryManagementAdminService";
    FunctionLibraryManagementAdminServiceStub stub;

    public FunctionLibraryManagementServiceClient(String cookie, String backendServerURL, ConfigurationContext configCtx) throws AxisFault {
        String serviceURL = backendServerURL + FUNCTION_LIBRARY_MANAGEMENT_SERVICE;
        this.stub = new FunctionLibraryManagementAdminServiceStub(configCtx, serviceURL);
        ServiceClient client = this.stub._getServiceClient();
        Options option = client.getOptions();
        option.setManageSession(true);
        option.setProperty("Cookie", (Object)cookie);
    }

    public void createFunctionLibrary(FunctionLibrary functionLibrary) throws AxisFault {
        try {
            this.stub.createFunctionLibrary(functionLibrary);
        }
        catch (RemoteException | FunctionLibraryManagementAdminServiceFunctionLibraryManagementException e) {
            this.handleException((Exception)e);
        }
    }

    public FunctionLibrary[] listFunctionLibraries() throws AxisFault {
        try {
            return this.stub.listFunctionLibraries();
        }
        catch (RemoteException | FunctionLibraryManagementAdminServiceFunctionLibraryManagementException e) {
            this.handleException((Exception)e);
            return new FunctionLibrary[0];
        }
    }

    public FunctionLibrary getFunctionLibrary(String functionLibraryName) throws AxisFault {
        try {
            return this.stub.getFunctionLibrary(functionLibraryName);
        }
        catch (RemoteException | FunctionLibraryManagementAdminServiceFunctionLibraryManagementException e) {
            this.handleException((Exception)e);
            return null;
        }
    }

    public void deleteFunctionLibrary(String functionLibraryName) throws AxisFault {
        try {
            this.stub.deleteFunctionLibrary(functionLibraryName);
        }
        catch (RemoteException | FunctionLibraryManagementAdminServiceFunctionLibraryManagementException e) {
            this.handleException((Exception)e);
        }
    }

    public void updateFunctionLibrary(String oldFunctionLibraryName, FunctionLibrary functionLibrary) throws AxisFault {
        try {
            this.stub.updateFunctionLibrary(oldFunctionLibraryName, functionLibrary);
        }
        catch (RemoteException | FunctionLibraryManagementAdminServiceFunctionLibraryManagementException e) {
            this.handleException((Exception)e);
        }
    }

    private void handleException(Exception e) throws AxisFault {
        String errorMessage = null;
        if (e instanceof FunctionLibraryManagementAdminServiceFunctionLibraryManagementException) {
            FunctionLibraryManagementAdminServiceFunctionLibraryManagementException exception = (FunctionLibraryManagementAdminServiceFunctionLibraryManagementException)((Object)e);
            if (exception.getFaultMessage().getFunctionLibraryManagementException() != null) {
                errorMessage = exception.getFaultMessage().getFunctionLibraryManagementException().getMessage();
            }
        } else {
            errorMessage = e.getMessage();
        }
        throw new AxisFault(errorMessage, (Throwable)e);
    }
}

