/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.datasource.rdbms.tomcat.utils;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.apache.tomcat.jdbc.pool.PoolConfiguration;
import org.apache.tomcat.jdbc.pool.PoolProperties;
import org.wso2.carbon.datasource.core.exception.DataSourceException;
import org.wso2.carbon.datasource.rdbms.tomcat.TomcatDataSourceConfiguration;

public class TomcatDataSourceUtils {
    public static PoolConfiguration createPoolConfiguration(TomcatDataSourceConfiguration config) throws DataSourceException {
        String isolationLevelString;
        PoolProperties props = new PoolProperties();
        props.setUrl(config.getUrl());
        if (config.isDefaultAutoCommit() != null) {
            props.setDefaultAutoCommit(config.isDefaultAutoCommit());
        }
        if (config.isDefaultReadOnly() != null) {
            props.setDefaultReadOnly(config.isDefaultReadOnly());
        }
        if ((isolationLevelString = config.getDefaultTransactionIsolation()) != null) {
            if ("NONE".equals(isolationLevelString)) {
                props.setDefaultTransactionIsolation(0);
            } else if ("READ_UNCOMMITTED".equals(isolationLevelString)) {
                props.setDefaultTransactionIsolation(1);
            } else if ("READ_COMMITTED".equals(isolationLevelString)) {
                props.setDefaultTransactionIsolation(2);
            } else if ("REPEATABLE_READ".equals(isolationLevelString)) {
                props.setDefaultTransactionIsolation(4);
            } else if ("SERIALIZABLE".equals(isolationLevelString)) {
                props.setDefaultTransactionIsolation(8);
            }
        }
        props.setDefaultCatalog(config.getDefaultCatalog());
        props.setDriverClassName(config.getDriverClassName());
        String username = config.getUsername();
        if (null != username && !"".equals(username)) {
            props.setUsername(username);
            String password = config.getPassword();
            if (null != password && !"".equals(password)) {
                props.setPassword(password);
            }
        }
        if (config.getMaxActive() != null) {
            props.setMaxActive(config.getMaxActive().intValue());
        }
        if (config.getMaxIdle() != null) {
            props.setMaxIdle(config.getMaxIdle().intValue());
        }
        if (config.getMinIdle() != null) {
            props.setMinIdle(config.getMinIdle().intValue());
        }
        if (config.getInitialSize() != null) {
            props.setInitialSize(config.getInitialSize().intValue());
        }
        if (config.getMaxWait() != null) {
            props.setMaxWait(config.getMaxWait().intValue());
        }
        if (config.isTestOnBorrow() != null) {
            props.setTestOnBorrow(config.isTestOnBorrow().booleanValue());
        }
        if (config.isTestOnReturn() != null) {
            props.setTestOnReturn(config.isTestOnReturn().booleanValue());
        }
        if (config.isTestWhileIdle() != null) {
            props.setTestWhileIdle(config.isTestWhileIdle().booleanValue());
        }
        props.setValidationQuery(config.getValidationQuery());
        props.setValidatorClassName(config.getValidatorClassName());
        if (config.getTimeBetweenEvictionRunsMillis() != null) {
            props.setTimeBetweenEvictionRunsMillis(config.getTimeBetweenEvictionRunsMillis().intValue());
        }
        if (config.getNumTestsPerEvictionRun() != null) {
            props.setNumTestsPerEvictionRun(config.getNumTestsPerEvictionRun().intValue());
        }
        if (config.getMinEvictableIdleTimeMillis() != null) {
            props.setMinEvictableIdleTimeMillis(config.getMinEvictableIdleTimeMillis().intValue());
        }
        if (config.isAccessToUnderlyingConnectionAllowed() != null) {
            props.setAccessToUnderlyingConnectionAllowed(config.isAccessToUnderlyingConnectionAllowed().booleanValue());
        }
        if (config.isRemoveAbandoned() != null) {
            props.setRemoveAbandoned(config.isRemoveAbandoned().booleanValue());
        }
        if (config.getRemoveAbandonedTimeout() != null) {
            props.setRemoveAbandonedTimeout(config.getRemoveAbandonedTimeout().intValue());
        }
        if (config.isLogAbandoned() != null) {
            props.setLogAbandoned(config.isLogAbandoned().booleanValue());
        }
        props.setConnectionProperties(config.getConnectionProperties());
        props.setInitSQL(config.getInitSQL());
        props.setJdbcInterceptors(config.getJdbcInterceptors());
        if (config.getValidationInterval() != null) {
            props.setValidationInterval(config.getValidationInterval().longValue());
        }
        if (config.isJmxEnabled() != null) {
            props.setJmxEnabled(config.isJmxEnabled().booleanValue());
        }
        if (config.isFairQueue() != null) {
            props.setFairQueue(config.isFairQueue().booleanValue());
        }
        if (config.getAbandonWhenPercentageFull() != null) {
            props.setAbandonWhenPercentageFull(config.getAbandonWhenPercentageFull().intValue());
        }
        if (config.getMaxAge() != null) {
            props.setMaxAge(config.getMaxAge().longValue());
        }
        if (config.isUseEquals() != null) {
            props.setUseEquals(config.isUseEquals().booleanValue());
        }
        if (config.getSuspectTimeout() != null) {
            props.setSuspectTimeout(config.getSuspectTimeout().intValue());
        }
        if (config.getValidationQueryTimeout() != null) {
            props.setValidationQueryTimeout(config.getValidationQueryTimeout().intValue());
        }
        if (config.isAlternateUsernameAllowed() != null) {
            props.setAlternateUsernameAllowed(config.isAlternateUsernameAllowed().booleanValue());
        }
        if (config.getDataSourceClassName() != null) {
            TomcatDataSourceUtils.handleExternalDataSource(props, config);
        }
        if (config.getDatabaseProps() != null) {
            Properties properties = new Properties();
            if (!config.getDatabaseProps().isEmpty()) {
                for (TomcatDataSourceConfiguration.DataSourceProperty property : config.getDatabaseProps()) {
                    properties.setProperty(property.getName(), property.getValue());
                }
            }
            props.setDbProperties(properties);
        }
        return props;
    }

    private static void handleExternalDataSource(PoolProperties poolProps, TomcatDataSourceConfiguration config) throws DataSourceException {
        String dsClassName = config.getDataSourceClassName();
        try {
            Object extDataSource = Class.forName(dsClassName).newInstance();
            TomcatDataSourceUtils.assignBeanProps(extDataSource, TomcatDataSourceUtils.dataSourcePropsToMap(config.getDataSourceProps()));
            poolProps.setDataSource(extDataSource);
        }
        catch (Exception e) {
            throw new DataSourceException("Error in creating external data source: " + e.getMessage(), e);
        }
    }

    public static void assignBeanProps(Object obj, Map<String, Object> props) throws DataSourceException {
        for (Map.Entry<String, Object> prop : props.entrySet()) {
            Method method = TomcatDataSourceUtils.getSetterMethod(obj, TomcatDataSourceUtils.getSetterMethodNameFromPropName(prop.getKey()));
            if (method == null) {
                throw new DataSourceException("Setter method for property '" + prop.getKey() + "' cannot be found");
            }
            try {
                method.invoke(obj, TomcatDataSourceUtils.convertStringToGivenType(prop.getValue(), method.getParameterTypes()[0]));
            }
            catch (Exception e) {
                throw new DataSourceException("Cannot invoke setter for property '" + prop.getKey() + "'", e);
            }
        }
    }

    private static Object convertStringToGivenType(Object value, Class<?> type) throws DataSourceException {
        if (String.class.equals(type) || Properties.class.equals(type)) {
            return value;
        }
        if (Boolean.TYPE.equals(type) || Boolean.class.equals(type)) {
            return Boolean.parseBoolean(String.valueOf(value));
        }
        if (Integer.TYPE.equals(type) || Integer.class.equals(type)) {
            return Integer.parseInt(String.valueOf(value));
        }
        if (Short.TYPE.equals(type) || Short.class.equals(type)) {
            return Short.parseShort(String.valueOf(value));
        }
        if (Byte.TYPE.equals(type) || Byte.class.equals(type)) {
            return Byte.parseByte(String.valueOf(value));
        }
        if (Long.TYPE.equals(type) || Long.class.equals(type)) {
            return Long.parseLong(String.valueOf(value));
        }
        if (Float.TYPE.equals(type) || Float.class.equals(type)) {
            return Float.valueOf(Float.parseFloat(String.valueOf(value)));
        }
        if (Double.TYPE.equals(type) || Double.class.equals(type)) {
            return Double.parseDouble(String.valueOf(value));
        }
        throw new DataSourceException("Cannot convert value: '" + value + "' to type: '" + type.getName() + "'");
    }

    public static boolean isEmptyString(String text) {
        return text == null || text.trim().length() <= 0;
    }

    private static String getSetterMethodNameFromPropName(String propName) throws RuntimeException {
        if (TomcatDataSourceUtils.isEmptyString(propName)) {
            throw new RuntimeException("Invalid property name");
        }
        return "set" + propName.substring(0, 1).toUpperCase(Locale.getDefault()) + propName.substring(1);
    }

    private static Method getSetterMethod(Object obj, String name) {
        Method[] methods;
        for (Method method : methods = obj.getClass().getMethods()) {
            if (!method.getName().equals(name) || !method.getReturnType().equals(Void.class) || method.getParameterTypes().length != 1) continue;
            return method;
        }
        return null;
    }

    public static Map<String, Object> dataSourcePropsToMap(List<TomcatDataSourceConfiguration.DataSourceProperty> dsProps) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (dsProps != null) {
            HashMap<String, Properties> tmpPropertiesObjects = new HashMap<String, Properties>();
            for (TomcatDataSourceConfiguration.DataSourceProperty dsProp : dsProps) {
                String[] prop = dsProp.getName().split("\\.");
                if (prop.length > 1) {
                    Properties tmpProp;
                    if (!tmpPropertiesObjects.containsKey(prop[0])) {
                        tmpProp = new Properties();
                        tmpPropertiesObjects.put(prop[0], tmpProp);
                    } else {
                        tmpProp = (Properties)tmpPropertiesObjects.get(prop[0]);
                    }
                    tmpProp.setProperty(prop[1], dsProp.getValue());
                    continue;
                }
                result.put(dsProp.getName(), dsProp.getValue());
            }
            result.putAll(tmpPropertiesObjects);
        }
        return result;
    }
}

