/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.datasource.core;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import javax.naming.NamingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.datasource.core.DataSourceBuilder;
import org.wso2.carbon.datasource.core.DataSourceJndiManager;
import org.wso2.carbon.datasource.core.DataSourceRepository;
import org.wso2.carbon.datasource.core.beans.CarbonDataSource;
import org.wso2.carbon.datasource.core.beans.DataSourceMetadata;
import org.wso2.carbon.datasource.core.beans.DataSourcesConfiguration;
import org.wso2.carbon.datasource.core.exception.DataSourceException;
import org.wso2.carbon.datasource.core.spi.DataSourceReader;
import org.wso2.carbon.datasource.utils.DataSourceUtils;

public class DataSourceManager {
    private static Logger logger = LoggerFactory.getLogger(DataSourceManager.class);
    private static DataSourceManager instance = new DataSourceManager();
    private DataSourceRepository dataSourceRepository;
    private Map<String, DataSourceReader> dataSourceReaders = new HashMap<String, DataSourceReader>();
    private static final String FILE_NAME_SUFFIX = "-datasources.xml";
    private boolean initialized = false;

    private DataSourceManager() {
        this.dataSourceRepository = new DataSourceRepository();
    }

    public static DataSourceManager getInstance() {
        return instance;
    }

    public DataSourceRepository getDataSourceRepository() {
        return this.dataSourceRepository;
    }

    public List<String> getDataSourceTypes() {
        return new ArrayList<String>(this.dataSourceReaders.keySet());
    }

    public DataSourceReader getDataSourceReader(String dataSourceType) throws DataSourceException {
        DataSourceReader reader = this.dataSourceReaders.get(dataSourceType);
        if (reader == null) {
            throw new DataSourceException("No reader found for type: " + dataSourceType);
        }
        return reader;
    }

    public void initDataSources(String configurationDirectory) throws DataSourceException {
        this.loadDataSourceProviders();
        this.initDataSources(configurationDirectory, this.dataSourceReaders);
    }

    public void initDataSources(String configurationDir, Map<String, DataSourceReader> dataSourceReaders) throws DataSourceException {
        this.dataSourceReaders = dataSourceReaders;
        if (this.initialized) {
            logger.debug("Data sources are already initialized.");
            return;
        }
        logger.debug("Initializing the data sources.");
        if (dataSourceReaders.isEmpty()) {
            throw new RuntimeException("No data source readers found. Data sources will not be initialized!");
        }
        try {
            Path dataSourcesPath = Paths.get(configurationDir, new String[0]);
            File dataSourcesFolder = dataSourcesPath.toFile();
            File[] dataSourceConfigFiles = dataSourcesFolder.listFiles();
            if (dataSourceConfigFiles != null) {
                for (File dataSourceConfigFile : dataSourceConfigFiles) {
                    if (!dataSourceConfigFile.getName().endsWith(FILE_NAME_SUFFIX)) continue;
                    this.initDataSource(dataSourceConfigFile);
                }
            }
        }
        catch (DataSourceException e) {
            throw new DataSourceException("Error in initializing system data sources: " + e.getMessage(), e);
        }
        this.initialized = true;
    }

    private void initDataSource(File dataSourceFile) throws DataSourceException {
        if (logger.isDebugEnabled()) {
            logger.debug("Initializing data source: " + dataSourceFile.getName());
        }
        try {
            DataSourcesConfiguration dataSourceConfiguration = DataSourceUtils.loadJAXBConfiguration(dataSourceFile, DataSourcesConfiguration.class);
            for (DataSourceMetadata dsmInfo : dataSourceConfiguration.getDataSources()) {
                DataSourceReader dataSourceReader = this.getDataSourceReader(dsmInfo.getDefinition().getType());
                CarbonDataSource carbonDataSource = DataSourceBuilder.buildCarbonDataSource(dsmInfo, dataSourceReader);
                this.dataSourceRepository.addDataSource(carbonDataSource);
                DataSourceJndiManager.register(carbonDataSource, dataSourceReader);
            }
        }
        catch (NamingException | DataSourceException e) {
            throw new DataSourceException("Error in initializing data sources at '" + dataSourceFile.getAbsolutePath() + " - " + e.getMessage(), e);
        }
    }

    private void loadDataSourceProviders() {
        if (this.dataSourceReaders.size() == 0) {
            ServiceLoader<DataSourceReader> dsReaderLoader = ServiceLoader.load(DataSourceReader.class);
            dsReaderLoader.forEach(reader -> this.dataSourceReaders.put(reader.getType(), (DataSourceReader)reader));
        }
    }
}

