/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.datasource.core;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.wso2.carbon.datasource.core.beans.CarbonDataSource;
import org.wso2.carbon.datasource.core.beans.DataSourceMetadata;
import org.wso2.carbon.datasource.core.exception.DataSourceException;
import org.wso2.carbon.datasource.core.spi.DataSourceReader;
import org.wso2.carbon.datasource.utils.DataSourceUtils;

public class DataSourceBuilder {
    private static Logger logger = LoggerFactory.getLogger(DataSourceBuilder.class);

    public static CarbonDataSource buildCarbonDataSource(DataSourceMetadata dataSourceMetadata, DataSourceReader dataSourceReader) throws DataSourceException {
        Object dataSource = DataSourceBuilder.buildDataSourceObject(dataSourceMetadata, false, dataSourceReader);
        return new CarbonDataSource(dataSourceMetadata, dataSource);
    }

    public static Object buildDataSourceObject(DataSourceMetadata dataSourceMetadata, boolean isUseDataSourceFactory, DataSourceReader dataSourceReader) throws DataSourceException {
        if (logger.isDebugEnabled()) {
            logger.debug("Generating the DataSource object from \"" + dataSourceReader.getType() + "\" type reader.");
        }
        Element configurationXmlDefinition = (Element)dataSourceMetadata.getDefinition().getDsXMLConfiguration();
        return dataSourceReader.createDataSource(DataSourceUtils.elementToString(configurationXmlDefinition), isUseDataSourceFactory);
    }
}

