/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.databridge.agent.endpoint.thrift;

import java.net.ConnectException;
import java.util.List;
import org.apache.thrift.TException;
import org.wso2.carbon.databridge.agent.endpoint.DataEndpoint;
import org.wso2.carbon.databridge.agent.endpoint.thrift.ThriftClientPoolFactory;
import org.wso2.carbon.databridge.agent.endpoint.thrift.ThriftEventConverter;
import org.wso2.carbon.databridge.agent.endpoint.thrift.ThriftSecureClientPoolFactory;
import org.wso2.carbon.databridge.agent.exception.DataEndpointAuthenticationException;
import org.wso2.carbon.databridge.agent.exception.DataEndpointException;
import org.wso2.carbon.databridge.agent.exception.DataEndpointLoginException;
import org.wso2.carbon.databridge.commons.Event;
import org.wso2.carbon.databridge.commons.exception.SessionTimeoutException;
import org.wso2.carbon.databridge.commons.exception.UndefinedEventTypeException;
import org.wso2.carbon.databridge.commons.thrift.data.ThriftEventBundle;
import org.wso2.carbon.databridge.commons.thrift.exception.ThriftAuthenticationException;
import org.wso2.carbon.databridge.commons.thrift.exception.ThriftSessionExpiredException;
import org.wso2.carbon.databridge.commons.thrift.exception.ThriftUndefinedEventTypeException;
import org.wso2.carbon.databridge.commons.thrift.service.general.ThriftEventTransmissionService;
import org.wso2.carbon.databridge.commons.thrift.service.secure.ThriftSecureEventTransmissionService;

public class ThriftDataEndpoint
extends DataEndpoint {
    @Override
    protected synchronized String login(Object client, String userName, String password) throws DataEndpointAuthenticationException, DataEndpointLoginException {
        try {
            return ((ThriftSecureEventTransmissionService.Client)client).connect(userName, password);
        }
        catch (ThriftAuthenticationException e) {
            throw new DataEndpointLoginException("Error while trying to login to the data receiver.", e);
        }
        catch (TException e) {
            if (e.getCause() instanceof ConnectException) {
                throw new DataEndpointAuthenticationException("Thrift exception", e);
            }
            throw new DataEndpointLoginException("Error while trying to login to the data receiver.", e);
        }
    }

    @Override
    protected synchronized void logout(Object client, String sessionId) throws DataEndpointAuthenticationException {
        try {
            ((ThriftSecureEventTransmissionService.Client)client).disconnect(sessionId);
        }
        catch (TException e) {
            throw new DataEndpointAuthenticationException("Thrift Exception", e);
        }
    }

    @Override
    protected synchronized void send(Object client, List<Event> events) throws DataEndpointException, SessionTimeoutException, UndefinedEventTypeException {
        ThriftEventBundle thriftEventBundle = null;
        for (Event event : events) {
            thriftEventBundle = ThriftEventConverter.toThriftEventBundle(event, thriftEventBundle, this.getDataEndpointConfiguration().getSessionId());
        }
        try {
            if (client instanceof ThriftSecureEventTransmissionService.Client) {
                ((ThriftSecureEventTransmissionService.Client)client).publish(thriftEventBundle);
            } else {
                ((ThriftEventTransmissionService.Client)client).publish(thriftEventBundle);
            }
        }
        catch (ThriftUndefinedEventTypeException e) {
            throw new UndefinedEventTypeException("Thrift Undefined Event Type Exception ", (Throwable)e);
        }
        catch (ThriftSessionExpiredException e) {
            throw new SessionTimeoutException("Thrift Session Expired Exception ", (Throwable)e);
        }
        catch (TException e) {
            throw new DataEndpointException("Cannot send Events", e);
        }
    }

    @Override
    public String getClientPoolFactoryClass() {
        return ThriftClientPoolFactory.class.getCanonicalName();
    }

    @Override
    public String getSecureClientPoolFactoryClass() {
        return ThriftSecureClientPoolFactory.class.getCanonicalName();
    }
}

