/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.databridge.agent.endpoint.binary;

import java.net.Socket;
import java.util.List;
import org.wso2.carbon.databridge.agent.endpoint.DataEndpoint;
import org.wso2.carbon.databridge.agent.endpoint.binary.BinaryClientPoolFactory;
import org.wso2.carbon.databridge.agent.endpoint.binary.BinaryEventSender;
import org.wso2.carbon.databridge.agent.endpoint.binary.BinarySecureClientPoolFactory;
import org.wso2.carbon.databridge.agent.exception.DataEndpointAuthenticationException;
import org.wso2.carbon.databridge.agent.exception.DataEndpointException;
import org.wso2.carbon.databridge.agent.exception.DataEndpointLoginException;
import org.wso2.carbon.databridge.commons.Event;
import org.wso2.carbon.databridge.commons.exception.SessionTimeoutException;
import org.wso2.carbon.databridge.commons.exception.UndefinedEventTypeException;

public class BinaryDataEndpoint
extends DataEndpoint {
    @Override
    protected String login(Object client, String userName, String password) throws DataEndpointAuthenticationException, DataEndpointLoginException {
        Socket socket = (Socket)client;
        try {
            BinaryEventSender.sendBinaryLoginMessage(socket, userName, password);
            return BinaryEventSender.processResponse(socket);
        }
        catch (Exception e) {
            if (e instanceof DataEndpointAuthenticationException) {
                throw (DataEndpointAuthenticationException)e;
            }
            throw new DataEndpointLoginException("Error while trying to login to data receiver :" + socket.getRemoteSocketAddress().toString(), e);
        }
    }

    @Override
    protected void logout(Object client, String sessionId) throws DataEndpointAuthenticationException {
        Socket socket = (Socket)client;
        try {
            BinaryEventSender.sendBinaryLogoutMessage(socket, sessionId);
            BinaryEventSender.processResponse(socket);
        }
        catch (Exception e) {
            if (e instanceof DataEndpointAuthenticationException) {
                throw (DataEndpointAuthenticationException)e;
            }
            throw new DataEndpointAuthenticationException("Error while trying to logout to data receiver :" + socket.getRemoteSocketAddress().toString(), e);
        }
    }

    @Override
    protected void send(Object client, List<Event> events) throws DataEndpointException, SessionTimeoutException, UndefinedEventTypeException {
        Socket socket = (Socket)client;
        String sessionId = this.getDataEndpointConfiguration().getSessionId();
        try {
            BinaryEventSender.sendBinaryPublishMessage(socket, events, sessionId);
            BinaryEventSender.processResponse(socket);
        }
        catch (Exception e) {
            if (e instanceof DataEndpointException) {
                throw (DataEndpointException)e;
            }
            if (e instanceof UndefinedEventTypeException) {
                throw new UndefinedEventTypeException("Undefined Event Type Exception ", (Throwable)e);
            }
            if (e instanceof SessionTimeoutException) {
                throw new SessionTimeoutException("Binary Session Expired Exception ", (Throwable)e);
            }
            throw new DataEndpointException("Error while trying to publish events to data receiver :" + socket.getRemoteSocketAddress().toString(), e);
        }
    }

    @Override
    public String getClientPoolFactoryClass() {
        return BinaryClientPoolFactory.class.getCanonicalName();
    }

    @Override
    public String getSecureClientPoolFactoryClass() {
        return BinarySecureClientPoolFactory.class.getCanonicalName();
    }
}

