/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.databridge.agent.endpoint;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.databridge.agent.conf.DataEndpointConfiguration;
import org.wso2.carbon.databridge.agent.endpoint.DataEndpoint;
import org.wso2.carbon.databridge.agent.exception.DataEndpointAuthenticationException;
import org.wso2.carbon.databridge.agent.exception.DataEndpointException;
import org.wso2.carbon.databridge.agent.exception.DataEndpointLoginException;

public class DataEndpointConnectionWorker
implements Runnable {
    private static Log log = LogFactory.getLog(DataEndpointConnectionWorker.class);
    private DataEndpointConfiguration dataEndpointConfiguration;
    private DataEndpoint dataEndpoint;
    private ScheduledExecutorService loggingControlScheduledExecutorService = Executors.newSingleThreadScheduledExecutor();
    private ScheduledFuture<?> loggingSchedule;
    private LoggingTask loggingTask = new LoggingTask();
    private AtomicBoolean loggingControlFlag = new AtomicBoolean(true);
    private boolean isLoggingControl = false;

    @Override
    public void run() {
        if (this.isInitialized()) {
            try {
                this.connect();
                if (this.dataEndpointConfiguration.isFailOverEndpoint()) {
                    this.loggingControlFlag.set(true);
                }
                this.dataEndpoint.activate();
            }
            catch (DataEndpointAuthenticationException e) {
                if (this.isLoggingControl) {
                    if (this.loggingControlFlag.get()) {
                        if (this.dataEndpointConfiguration.isFailOverEndpoint()) {
                            log.info((Object)("Attempt to connect to the endpoint " + this.dataEndpoint.getDataEndpointConfiguration().getAuthURL() + " failed."));
                            log.debug((Object)("Error while trying to connect to the endpoint. " + e.getErrorMessage()), (Throwable)e);
                        } else {
                            log.error((Object)("Error while trying to connect to the endpoint. " + e.getErrorMessage()), (Throwable)e);
                        }
                        this.loggingControlFlag.set(false);
                    }
                } else {
                    log.error((Object)("Error while trying to connect to the endpoint. " + e.getErrorMessage()), (Throwable)e);
                }
                this.dataEndpoint.deactivate();
            }
            catch (DataEndpointLoginException e) {
                log.error((Object)("Error while trying to connect to the endpoint. " + e.getErrorMessage()), (Throwable)e);
                this.dataEndpoint.deactivate();
            }
        } else {
            String errorMsg = "Data endpoint connection worker is not properly initialized ";
            if (this.dataEndpoint == null) {
                errorMsg = errorMsg + ", data Endpoint is not provided ";
            }
            if (this.dataEndpointConfiguration == null) {
                errorMsg = errorMsg + ", data Endpoint configuration is not provided";
            }
            errorMsg = errorMsg + ".";
            log.error((Object)errorMsg);
        }
    }

    DataEndpointConfiguration getDataEndpointConfiguration() {
        return this.dataEndpointConfiguration;
    }

    public void initialize(DataEndpoint dataEndpoint, DataEndpointConfiguration dataEndpointConfiguration) throws DataEndpointException {
        if (this.dataEndpointConfiguration != null) {
            throw new DataEndpointException("Already data endpoint configuration is set: " + this.dataEndpointConfiguration.toString() + " for the endpoint " + dataEndpointConfiguration.toString());
        }
        this.dataEndpointConfiguration = dataEndpointConfiguration;
        if (this.dataEndpoint != null) {
            throw new DataEndpointException("Already data endpoint is configured for the connection worker");
        }
        this.dataEndpoint = dataEndpoint;
        if (dataEndpointConfiguration.getLoggingControlIntervalInSeconds() != 0L) {
            this.isLoggingControl = true;
            this.scheduledLoggingTask();
        } else if (dataEndpointConfiguration.isFailOverEndpoint()) {
            this.isLoggingControl = true;
        }
    }

    private void connect() throws DataEndpointAuthenticationException, DataEndpointLoginException {
        Object client = null;
        try {
            client = this.dataEndpointConfiguration.getSecuredTransportPool().borrowObject((Object)this.dataEndpointConfiguration.getAuthKey());
            String sessionId = this.dataEndpoint.login(client, this.dataEndpointConfiguration.getUsername(), this.dataEndpointConfiguration.getPassword());
            this.dataEndpointConfiguration.setSessionId(sessionId);
        }
        catch (Throwable e) {
            if (e instanceof DataEndpointLoginException) {
                throw new DataEndpointLoginException("Cannot borrow client for " + this.dataEndpointConfiguration.getAuthURL() + ".", e);
            }
            throw new DataEndpointAuthenticationException("Cannot borrow client for " + this.dataEndpointConfiguration.getAuthURL(), e);
        }
        finally {
            try {
                this.dataEndpointConfiguration.getSecuredTransportPool().returnObject((Object)this.dataEndpointConfiguration.getAuthKey(), client);
            }
            catch (Exception e) {
                this.dataEndpointConfiguration.getSecuredTransportPool().clear((Object)this.dataEndpointConfiguration.getAuthKey());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect(DataEndpointConfiguration dataPublisherConfiguration) {
        Object client = null;
        try {
            client = this.dataEndpointConfiguration.getSecuredTransportPool().borrowObject((Object)dataPublisherConfiguration.getAuthKey());
            this.dataEndpoint.logout(client, dataPublisherConfiguration.getSessionId());
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Cannot connect to the server at " + dataPublisherConfiguration.getAuthURL() + ", for user: " + dataPublisherConfiguration.getUsername()), (Throwable)e);
            }
            log.warn((Object)("Cannot connect to the server at " + dataPublisherConfiguration.getAuthURL() + ", for user: " + dataPublisherConfiguration.getUsername()));
        }
        finally {
            try {
                if (null != this.loggingControlScheduledExecutorService) {
                    this.loggingControlScheduledExecutorService.shutdown();
                }
                this.dataEndpointConfiguration.getSecuredTransportPool().returnObject((Object)dataPublisherConfiguration.getAuthKey(), client);
            }
            catch (Exception e) {
                this.dataEndpointConfiguration.getSecuredTransportPool().clear((Object)dataPublisherConfiguration.getAuthKey());
            }
        }
    }

    private boolean isInitialized() {
        return this.dataEndpoint != null && this.dataEndpointConfiguration != null;
    }

    private void scheduledLoggingTask() {
        this.loggingSchedule = this.loggingControlScheduledExecutorService.scheduleAtFixedRate(this.loggingTask, 0L, this.dataEndpointConfiguration.getLoggingControlIntervalInSeconds(), TimeUnit.SECONDS);
    }

    private class LoggingTask
    implements Runnable {
        private LoggingTask() {
        }

        @Override
        public void run() {
            DataEndpointConnectionWorker.this.loggingControlFlag.set(true);
        }
    }
}

