/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.databridge.agent;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.databridge.agent.DataEndpointAgent;
import org.wso2.carbon.databridge.agent.conf.AgentConfiguration;
import org.wso2.carbon.databridge.agent.conf.DataAgentsConfiguration;
import org.wso2.carbon.databridge.agent.exception.DataEndpointAgentConfigurationException;
import org.wso2.carbon.databridge.agent.exception.DataEndpointException;
import org.wso2.carbon.databridge.agent.util.CarbonUtils;
import org.wso2.carbon.databridge.agent.util.DataEndpointConstants;

public class AgentHolder {
    private static Log log = LogFactory.getLog(AgentHolder.class);
    private static String configPath;
    private static AgentHolder instance;
    private Map<String, DataEndpointAgent> dataEndpointAgents;
    private String defaultDataEndpointAgentName;

    private AgentHolder() throws DataEndpointAgentConfigurationException {
        try {
            this.dataEndpointAgents = new HashMap<String, DataEndpointAgent>();
            DataAgentsConfiguration dataAgentsConfiguration = this.loadConfiguration();
            boolean isDefault = true;
            for (AgentConfiguration agentConfiguration : dataAgentsConfiguration.getAgentConfigurations()) {
                this.addAgentConfiguration(agentConfiguration, isDefault);
                if (!isDefault) continue;
                isDefault = false;
            }
        }
        catch (DataEndpointAgentConfigurationException e) {
            log.error((Object)("Unable to complete initialization of agents." + e.getMessage()), (Throwable)e);
            throw e;
        }
    }

    public static synchronized AgentHolder getInstance() throws DataEndpointAgentConfigurationException {
        if (instance == null) {
            instance = new AgentHolder();
        }
        return instance;
    }

    public synchronized DataEndpointAgent getDataEndpointAgent(String type) throws DataEndpointAgentConfigurationException {
        DataEndpointAgent agent = this.dataEndpointAgents.get(type.toLowerCase());
        if (agent == null) {
            throw new DataEndpointAgentConfigurationException("No data agent configured for the type: " + type.toLowerCase());
        }
        return agent;
    }

    private DataAgentsConfiguration loadConfiguration() throws DataEndpointAgentConfigurationException {
        if (configPath == null) {
            configPath = CarbonUtils.getCarbonConfigDirPath() + DataEndpointConstants.DATA_AGENT_CONF_FILE_PATH;
        }
        try {
            File file = new File(configPath);
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{DataAgentsConfiguration.class});
            Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
            DataAgentsConfiguration dataAgentsConfiguration = (DataAgentsConfiguration)jaxbUnmarshaller.unmarshal(file);
            dataAgentsConfiguration.validateConfigurations();
            for (AgentConfiguration agentConfiguration : dataAgentsConfiguration.getAgentConfigurations()) {
                if (agentConfiguration.getTrustStore() == null) {
                    agentConfiguration.setTrustStore(System.getProperty("javax.net.ssl.trustStore"));
                    if (agentConfiguration.getTrustStore() == null) {
                        throw new DataEndpointAgentConfigurationException("No trustStore found");
                    }
                }
                if (agentConfiguration.getTrustStorePassword() != null) continue;
                agentConfiguration.setTrustStorePassword(System.getProperty("javax.net.ssl.trustStorePassword"));
                if (agentConfiguration.getTrustStorePassword() != null) continue;
                throw new DataEndpointAgentConfigurationException("No trustStore password found");
            }
            return dataAgentsConfiguration;
        }
        catch (JAXBException e) {
            throw new DataEndpointAgentConfigurationException("Error while loading the configuration file " + configPath, e);
        }
    }

    private void addAgentConfiguration(AgentConfiguration agentConfiguration, boolean defaultAgent) throws DataEndpointAgentConfigurationException {
        DataEndpointAgent agent = new DataEndpointAgent(agentConfiguration);
        this.dataEndpointAgents.put(agent.getAgentConfiguration().getDataEndpointName().toLowerCase(), agent);
        if (defaultAgent) {
            this.defaultDataEndpointAgentName = agent.getAgentConfiguration().getDataEndpointName();
        }
    }

    public DataEndpointAgent getDefaultDataEndpointAgent() throws DataEndpointAgentConfigurationException {
        return this.getDataEndpointAgent(this.defaultDataEndpointAgentName);
    }

    public static void setConfigPath(String configPath) {
        AgentHolder.configPath = configPath;
    }

    public static synchronized void shutdown() throws DataEndpointException {
        for (DataEndpointAgent dataEndpointAgent : AgentHolder.instance.dataEndpointAgents.values()) {
            dataEndpointAgent.shutDown();
        }
        instance = null;
    }
}

