/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.simulator.core.internal.util;

import org.wso2.carbon.databridge.commons.Event;
import org.wso2.carbon.databridge.commons.StreamDefinition;
import org.wso2.carbon.event.simulator.core.exception.EventSimulatorRuntimeException;

public class EventSimulatorUtil {
    public static Event getWso2Event(StreamDefinition streamDefinition, long timestamp, Object[] data) {
        int metaAttrCount = streamDefinition.getMetaData() != null ? streamDefinition.getMetaData().size() : 0;
        int correlationAttrCount = streamDefinition.getCorrelationData() != null ? streamDefinition.getCorrelationData().size() : 0;
        int payloadAttrCount = streamDefinition.getPayloadData() != null ? streamDefinition.getPayloadData().size() : 0;
        Object[] metaAttrArray = new Object[metaAttrCount];
        Object[] correlationAttrArray = new Object[correlationAttrCount];
        Object[] payloadAttrArray = new Object[payloadAttrCount];
        for (int i = 0; i < data.length; ++i) {
            if (i < metaAttrCount) {
                metaAttrArray[i] = data[i];
                continue;
            }
            if (i < metaAttrCount + correlationAttrCount) {
                correlationAttrArray[i - metaAttrCount] = data[i];
                continue;
            }
            payloadAttrArray[i - (metaAttrCount + correlationAttrCount)] = data[i];
        }
        return new Event(streamDefinition.getStreamId(), timestamp, metaAttrArray, correlationAttrArray, payloadAttrArray);
    }

    public static void validatePath(String fileName) {
        if (fileName.contains("../") || fileName.contains("..\\")) {
            throw new EventSimulatorRuntimeException("File name contains restricted path elements. " + fileName);
        }
    }
}

