/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.simulator.core.internal.util;

import java.io.File;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.axis2.deployment.DeploymentException;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xerces.util.SecurityManager;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.wso2.carbon.event.simulator.core.CSVFileInfo;
import org.wso2.carbon.event.simulator.core.DataSourceTableAndStreamInfo;
import org.xml.sax.SAXException;

public class DeploymentHelper {
    private static final Log log = LogFactory.getLog(DeploymentHelper.class);
    private static final int ENTITY_EXPANSION_LIMIT = 0;

    private static DocumentBuilderFactory getSecuredDocumentBuilder() {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        dbf.setXIncludeAware(false);
        dbf.setExpandEntityReferences(false);
        try {
            dbf.setFeature("http://xml.org/sax/features/external-general-entities", false);
            dbf.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            dbf.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        }
        catch (ParserConfigurationException e) {
            log.error((Object)"Failed to load XML Processor Feature external-general-entities or external-parameter-entities or nonvalidating/load-external-dtd");
        }
        SecurityManager securityManager = new SecurityManager();
        securityManager.setEntityExpansionLimit(0);
        dbf.setAttribute("http://apache.org/xml/properties/security-manager", securityManager);
        return dbf;
    }

    public static CSVFileInfo getCSVFileInfo(File streamConfigXMLFile, AxisConfiguration axisConfiguration) throws DeploymentException {
        CSVFileInfo csvFileInfo = new CSVFileInfo();
        String csvFileName = streamConfigXMLFile.getName().replace("_streamConfiguration.xml", ".csv");
        DocumentBuilderFactory dbFactory = DeploymentHelper.getSecuredDocumentBuilder();
        Document doc = null;
        try {
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            doc = dBuilder.parse(streamConfigXMLFile);
        }
        catch (ParserConfigurationException e) {
            throw new DeploymentException("Failed to load configuration from file: " + streamConfigXMLFile.getName(), (Throwable)e);
        }
        catch (SAXException e) {
            throw new DeploymentException("Failed to load configuration from file: " + streamConfigXMLFile.getName(), (Throwable)e);
        }
        catch (IOException e) {
            throw new DeploymentException("Failed to load configuration from file: " + streamConfigXMLFile.getName(), (Throwable)e);
        }
        Element element = doc.getDocumentElement();
        Node fileNode = element.getElementsByTagName("file").item(0);
        if (fileNode == null) {
            throw new DeploymentException("file absent in stream configuration file: " + streamConfigXMLFile.getName());
        }
        String extractedCSVFileName = fileNode.getTextContent();
        if (!extractedCSVFileName.equals(csvFileName)) {
            throw new DeploymentException("Wrong file name: " + extractedCSVFileName + " given in stream configuration file: " + streamConfigXMLFile.getName());
        }
        csvFileInfo.setFileName(extractedCSVFileName);
        String repo = axisConfiguration.getRepository().getPath();
        String path = repo + "eventsimulatorfiles";
        String csvAbsolutePath = path + File.separator + extractedCSVFileName;
        File csvFile = new File(csvAbsolutePath);
        if (!csvFile.exists()) {
            throw new DeploymentException("CSV file: " + extractedCSVFileName + " does not exist for stream configuration: " + streamConfigXMLFile.getName());
        }
        csvFileInfo.setFilePath(csvAbsolutePath);
        Node streamIdNode = element.getElementsByTagName("streamID").item(0);
        if (streamIdNode == null) {
            throw new DeploymentException("streamID absent in stream configuration file: " + streamConfigXMLFile.getName());
        }
        csvFileInfo.setStreamID(streamIdNode.getTextContent());
        Node eventSendingDelayNode = element.getElementsByTagName("delayBetweenEventsInMilies").item(0);
        if (eventSendingDelayNode == null) {
            throw new DeploymentException("delayBetweenEventsInMilies absent in stream configuration file: " + streamConfigXMLFile.getName());
        }
        csvFileInfo.setDelayBetweenEventsInMillis(Long.valueOf(eventSendingDelayNode.getTextContent()));
        Node separateCharNode = element.getElementsByTagName("separateChar").item(0);
        if (separateCharNode == null) {
            throw new DeploymentException("separateChar absent in stream configuration file: " + streamConfigXMLFile.getName());
        }
        csvFileInfo.setSeparateCharacter(separateCharNode.getTextContent());
        return csvFileInfo;
    }

    public static DataSourceTableAndStreamInfo getEventMappingConfiguration(File datasourceConfigXMLFile) {
        DataSourceTableAndStreamInfo dataSourceTableAndStreamInfo;
        block4: {
            dataSourceTableAndStreamInfo = new DataSourceTableAndStreamInfo();
            try {
                if (!datasourceConfigXMLFile.exists()) break block4;
                DocumentBuilderFactory dbFactory = DeploymentHelper.getSecuredDocumentBuilder();
                DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
                Document doc = dBuilder.parse(datasourceConfigXMLFile);
                Element element = doc.getDocumentElement();
                if (element.getAttribute("type").equalsIgnoreCase("database")) {
                    dataSourceTableAndStreamInfo.setConfigurationName(element.getAttribute("name"));
                    dataSourceTableAndStreamInfo.setDataSourceName(element.getElementsByTagName("dataSource").item(0).getTextContent());
                    dataSourceTableAndStreamInfo.setTableName(element.getElementsByTagName("tableName").item(0).getTextContent());
                    dataSourceTableAndStreamInfo.setEventStreamID(element.getElementsByTagName("streamID").item(0).getTextContent());
                    dataSourceTableAndStreamInfo.setDelayBetweenEventsInMillis(Long.parseLong(element.getElementsByTagName("delayBetweenEventsInMilies").item(0).getTextContent()));
                    NodeList columnMappings = element.getElementsByTagName("columnMapping");
                    String[][] dataSourceColumnsAndTypes = new String[2][columnMappings.getLength()];
                    for (int i = 0; i < columnMappings.getLength(); ++i) {
                        dataSourceColumnsAndTypes[0][i] = columnMappings.item(i).getAttributes().item(0).getNodeValue();
                        dataSourceColumnsAndTypes[1][i] = columnMappings.item(i).getAttributes().item(1).getNodeValue();
                    }
                    dataSourceTableAndStreamInfo.setDataSourceColumnsAndTypes(dataSourceColumnsAndTypes);
                    break block4;
                }
                return null;
            }
            catch (Exception e) {
                log.error((Object)"Exception occurred when converting the datasource configuration file ", (Throwable)e);
            }
        }
        return dataSourceTableAndStreamInfo;
    }
}

