/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.simulator.core.internal.ds;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.wso2.carbon.event.processor.manager.core.EventManagementService;
import org.wso2.carbon.event.simulator.core.EventSimulator;
import org.wso2.carbon.event.simulator.core.internal.CarbonEventSimulator;
import org.wso2.carbon.event.simulator.core.internal.ds.EventSimulatorValueHolder;
import org.wso2.carbon.event.simulator.core.internal.util.EventStreamListenerImpl;
import org.wso2.carbon.event.stream.core.EventStreamListener;
import org.wso2.carbon.event.stream.core.EventStreamService;
import org.wso2.carbon.ndatasource.core.DataSourceService;

@Component(name="eventSimulatorService.component", immediate=true)
public class EventSimulatorDS {
    private static final Log log = LogFactory.getLog(EventSimulator.class);

    @Activate
    protected void activate(ComponentContext context) {
        try {
            CarbonEventSimulator carbonEventSimulator = this.createEventSimulator();
            this.setEventSimulator(carbonEventSimulator);
            context.getBundleContext().registerService(EventSimulator.class.getName(), (Object)carbonEventSimulator, null);
            context.getBundleContext().registerService(EventStreamListener.class.getName(), (Object)new EventStreamListenerImpl(), null);
            if (log.isDebugEnabled()) {
                log.debug((Object)"Successfully deployed EventSimulator");
            }
        }
        catch (RuntimeException e) {
            log.error((Object)("Could not create EventSimulator : " + e.getMessage()), (Throwable)e);
        }
    }

    @Reference(name="stream.carboneventstream.service", service=EventStreamService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.STATIC, unbind="unsetEventStreamService")
    protected void setEventStreamService(EventStreamService eventstreamservice) {
        EventSimulatorValueHolder.setEventStreamService(eventstreamservice);
    }

    protected void unsetEventStreamService(EventStreamService eventstreamservice) {
        EventSimulatorValueHolder.unsetEventStreamService();
    }

    private CarbonEventSimulator createEventSimulator() {
        return new CarbonEventSimulator();
    }

    protected void setEventSimulator(CarbonEventSimulator carbonEventSimulator) {
        EventSimulatorValueHolder.setEventSimulator(carbonEventSimulator);
    }

    @Reference(name="org.wso2.carbon.ndatasource", service=DataSourceService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetDataSourceService")
    protected void setDataSourceService(DataSourceService dataSourceService) {
        EventSimulatorValueHolder.setDataSourceService(dataSourceService);
    }

    protected void unsetDataSourceService(DataSourceService dataSourceService) {
        EventSimulatorValueHolder.setDataSourceService(null);
    }

    @Reference(name="eventManagement.service", service=EventManagementService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetEventManagementService")
    protected void setEventManagementService(EventManagementService eventManagementService) {
        EventSimulatorValueHolder.setEventManagementService(eventManagementService);
    }

    protected void unsetEventManagementService(EventManagementService eventManagementService) {
        EventSimulatorValueHolder.setEventManagementService(null);
    }
}

