/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.simulator.core.internal;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.activation.DataHandler;
import javax.sql.DataSource;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.axis2.AxisFault;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.databridge.commons.Attribute;
import org.wso2.carbon.databridge.commons.AttributeType;
import org.wso2.carbon.databridge.commons.StreamDefinition;
import org.wso2.carbon.event.processor.manager.core.EventManagementService;
import org.wso2.carbon.event.processor.manager.core.config.DistributedConfiguration;
import org.wso2.carbon.event.processor.manager.core.config.Mode;
import org.wso2.carbon.event.simulator.core.CSVFileInfo;
import org.wso2.carbon.event.simulator.core.DataSourceTableAndStreamInfo;
import org.wso2.carbon.event.simulator.core.Event;
import org.wso2.carbon.event.simulator.core.EventSimulator;
import org.wso2.carbon.event.simulator.core.EventSimulatorConstant;
import org.wso2.carbon.event.simulator.core.UploadedFileItem;
import org.wso2.carbon.event.simulator.core.internal.EventStreamProducer;
import org.wso2.carbon.event.simulator.core.internal.ds.EventSimulatorValueHolder;
import org.wso2.carbon.event.simulator.core.internal.util.EventSimulatorUtil;
import org.wso2.carbon.event.stream.core.EventProducer;
import org.wso2.carbon.event.stream.core.EventStreamService;
import org.wso2.carbon.event.stream.core.exception.EventStreamConfigurationException;
import org.wso2.carbon.ndatasource.common.DataSourceException;
import org.wso2.carbon.ndatasource.core.CarbonDataSource;
import org.wso2.carbon.utils.CarbonUtils;

public class CarbonEventSimulator
implements EventSimulator {
    private static final Log log = LogFactory.getLog(CarbonEventSimulator.class);
    private HashMap<Integer, HashMap<String, CSVFileInfo>> tenantSpecificCSVFileInfoMap = new HashMap();
    private HashMap<Integer, HashMap<String, DataSourceTableAndStreamInfo>> tenantSpecificDataSourceInfoMap = new HashMap();
    private Map<Integer, Map<String, EventCreator>> tenantSpecificFileEventSimulatorMap = new HashMap<Integer, Map<String, EventCreator>>();
    private Map<Integer, Map<String, EventCreatorForDB>> tenantSpecificDBEventSimulatorMap = new HashMap<Integer, Map<String, EventCreatorForDB>>();
    private boolean isWorkerNode = true;
    private Mode mode;

    public CarbonEventSimulator() {
        EventManagementService eventManagementService = EventSimulatorValueHolder.getEventManagementService();
        if (eventManagementService != null) {
            this.mode = eventManagementService.getManagementModeInfo().getMode();
            DistributedConfiguration distributedConfiguration = eventManagementService.getManagementModeInfo().getDistributedConfiguration();
            if (this.mode == Mode.Distributed && distributedConfiguration != null) {
                this.isWorkerNode = distributedConfiguration.isWorkerNode();
            }
        }
    }

    @Override
    public Collection<StreamDefinition> getAllEventStreamDefinitions() {
        try {
            EventStreamService eventStreamService = EventSimulatorValueHolder.getEventStreamService();
            ArrayList<StreamDefinition> collection = new ArrayList<StreamDefinition>();
            for (StreamDefinition streamDefinition : eventStreamService.getAllStreamDefinitions()) {
                collection.add(streamDefinition);
            }
            return collection;
        }
        catch (EventStreamConfigurationException e) {
            log.error((Object)"Exception when retrieving event stream definitions", (Throwable)e);
            return null;
        }
    }

    /*
     * Could not resolve type clashes
     */
    @Override
    public void sendEvent(Event eventDetail) throws AxisFault {
        EventStreamProducer existingEventStreamProducer;
        int tenantID;
        if (this.mode == Mode.Distributed && !this.isWorkerNode) {
            log.warn((Object)("Sending events via manager node in distributed mode is not allowed. Dropping event for stream: " + eventDetail.getStreamDefinition().getStreamId()));
            return;
        }
        EventStreamService eventstreamservice = EventSimulatorValueHolder.getEventStreamService();
        StreamDefinition streamDefinition = eventDetail.getStreamDefinition();
        String[] attributeValues = eventDetail.getAttributeValues();
        Object[] dataObjects = new Object[attributeValues.length];
        List<Attribute> streamAttributeList = this.getStreamAttributeList(eventDetail.getStreamDefinition());
        if (this.validateAttributeValues(streamAttributeList, attributeValues)) {
            block26: for (int i = 0; i < dataObjects.length; ++i) {
                Attribute attribute = streamAttributeList.get(i);
                String attributeType = attribute.getType().toString();
                String attributeValue = attributeValues[i].trim();
                switch (attributeType) {
                    case "STRING": {
                        dataObjects[i] = attributeValue;
                        continue block26;
                    }
                    case "INT": {
                        boolean val;
                        try {
                            val = Integer.parseInt(attributeValue);
                            dataObjects[i] = val ? 1 : 0;
                            continue block26;
                        }
                        catch (NumberFormatException e) {
                            throw new AxisFault("Incorrect value types for the attribute - " + attribute.getName() + ", expected " + attribute.getType().toString() + " : " + e.getMessage(), (Throwable)e);
                        }
                    }
                    case "LONG": {
                        try {
                            long val = Long.parseLong(attributeValue);
                            dataObjects[i] = val;
                            continue block26;
                        }
                        catch (NumberFormatException e) {
                            throw new AxisFault("Incorrect value types for the attribute - " + attribute.getName() + ", expected  " + attribute.getType().toString() + " : " + e.getMessage(), (Throwable)e);
                        }
                    }
                    case "DOUBLE": {
                        try {
                            double val = Double.parseDouble(attributeValue);
                            dataObjects[i] = val;
                            continue block26;
                        }
                        catch (NumberFormatException e) {
                            throw new AxisFault("Incorrect value types for the attribute - " + attribute.getName() + ", expected  " + attribute.getType().toString() + " : " + e.getMessage(), (Throwable)e);
                        }
                    }
                    case "FLOAT": {
                        try {
                            float val = Float.parseFloat(attributeValue);
                            dataObjects[i] = Float.valueOf(val);
                            continue block26;
                        }
                        catch (NumberFormatException e) {
                            throw new AxisFault("Incorrect value types for the attribute - " + attribute.getName() + ", expected  " + attribute.getType().toString() + " : " + e.getMessage(), (Throwable)e);
                        }
                    }
                    case "BOOL": {
                        boolean val;
                        if (attributeValue.equalsIgnoreCase("true") || attributeValue.equalsIgnoreCase("false")) {
                            val = Boolean.parseBoolean(attributeValue);
                            dataObjects[i] = val;
                            continue block26;
                        }
                        throw new AxisFault("Incorrect value types for the attribute - " + attribute.getName() + ", expected " + attribute.getType().toString());
                    }
                }
            }
        }
        if (null == EventSimulatorValueHolder.getEventProducerMap(tenantID = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId())) {
            EventSimulatorValueHolder.createEventProducerMapForTenant(tenantID);
        }
        if ((existingEventStreamProducer = EventSimulatorValueHolder.getEventProducerMap(tenantID).get(streamDefinition.getStreamId())) != null) {
            EventStreamProducer eventProducer = EventSimulatorValueHolder.getEventProducerMap(tenantID).get(streamDefinition.getStreamId());
            eventProducer.sendData(dataObjects);
        } else {
            EventStreamProducer eventStreamProducer = new EventStreamProducer();
            try {
                eventStreamProducer.setStreamID(streamDefinition.getStreamId());
                eventstreamservice.subscribe((EventProducer)eventStreamProducer);
            }
            catch (EventStreamConfigurationException e) {
                log.error((Object)"Exception occurred when subscribing to Event Stream service", (Throwable)e);
            }
            EventSimulatorValueHolder.getEventProducerMap(tenantID).put(streamDefinition.getStreamId(), eventStreamProducer);
            eventStreamProducer.sendData(dataObjects);
        }
    }

    @Override
    public List<CSVFileInfo> getAllCSVFileInfo() {
        int tenantID = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
        HashMap<String, CSVFileInfo> csvFileInfoMap = this.tenantSpecificCSVFileInfoMap.get(tenantID);
        if (csvFileInfoMap != null) {
            return new ArrayList<CSVFileInfo>(csvFileInfoMap.values());
        }
        return null;
    }

    public void addCSVFileInfo(CSVFileInfo csvFileInfo) {
        int tenantID = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
        csvFileInfo.setStatus(CSVFileInfo.Status.STOPPED);
        if (this.tenantSpecificCSVFileInfoMap.containsKey(tenantID)) {
            HashMap<String, CSVFileInfo> csvFileInfoMap = this.tenantSpecificCSVFileInfoMap.get(tenantID);
            csvFileInfoMap.put(csvFileInfo.getFileName(), csvFileInfo);
        } else {
            HashMap<String, CSVFileInfo> csvFileMap = new HashMap<String, CSVFileInfo>();
            csvFileMap.put(csvFileInfo.getFileName(), csvFileInfo);
            this.tenantSpecificCSVFileInfoMap.put(tenantID, csvFileMap);
        }
    }

    public void removeCSVFileInfo(String fileName) {
        CSVFileInfo oldCSVFileInfo;
        HashMap<String, CSVFileInfo> csvFileInfoMap;
        int tenantID = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
        if (this.tenantSpecificCSVFileInfoMap.containsKey(tenantID) && (csvFileInfoMap = this.tenantSpecificCSVFileInfoMap.get(tenantID)) != null && (oldCSVFileInfo = csvFileInfoMap.get(fileName)) != null) {
            CSVFileInfo newCSVFileInfo = new CSVFileInfo();
            newCSVFileInfo.setFileName(oldCSVFileInfo.getFileName());
            newCSVFileInfo.setFilePath(oldCSVFileInfo.getFilePath());
            newCSVFileInfo.setStatus(CSVFileInfo.Status.STOPPED);
            csvFileInfoMap.put(fileName, newCSVFileInfo);
        }
    }

    public void addEventMappingConfiguration(String fileName, String streamId, String separateChar, long delayBetweenEventsInMillis) {
        int tenantID = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
        HashMap<String, CSVFileInfo> csvFileInfoMap = this.tenantSpecificCSVFileInfoMap.get(tenantID);
        CSVFileInfo csvFileInfo = csvFileInfoMap.get(fileName);
        csvFileInfo.setStreamID(streamId);
        csvFileInfo.setSeparateCharacter(separateChar);
        csvFileInfo.setDelayBetweenEventsInMillis(delayBetweenEventsInMillis);
    }

    @Override
    public void createConfigurationXML(String fileName, String streamId, String separateChar, long delayBetweenEventsInMillis, AxisConfiguration axisConfiguration) {
        String repo = axisConfiguration.getRepository().getPath();
        String path = repo + "eventsimulatorfiles";
        try {
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            Document doc = docBuilder.newDocument();
            Element rootElement = doc.createElement("streamConfiguration");
            rootElement.setAttribute("type", "csv");
            doc.appendChild(rootElement);
            Element csvFileName = doc.createElement("file");
            csvFileName.appendChild(doc.createTextNode(fileName));
            rootElement.appendChild(csvFileName);
            Element streamID = doc.createElement("streamID");
            streamID.appendChild(doc.createTextNode(streamId));
            rootElement.appendChild(streamID);
            Element separateCharacter = doc.createElement("separateChar");
            separateCharacter.appendChild(doc.createTextNode(separateChar));
            rootElement.appendChild(separateCharacter);
            Element eventSendingDelayElement = doc.createElement("delayBetweenEventsInMilies");
            eventSendingDelayElement.appendChild(doc.createTextNode(String.valueOf(delayBetweenEventsInMillis)));
            rootElement.appendChild(eventSendingDelayElement);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            transformerFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            DOMSource source = new DOMSource(doc);
            String configFileName = fileName.substring(0, fileName.length() - 4) + "_streamConfiguration.xml";
            String absolutePath = path + File.separator + configFileName;
            EventSimulatorUtil.validatePath(fileName);
            StringWriter sw = new StringWriter();
            StreamResult result = new StreamResult(sw);
            transformer.transform(source, result);
            this.saveConfigurationXML(sw.toString(), configFileName, absolutePath);
            this.addEventMappingConfiguration(fileName, streamId, separateChar, delayBetweenEventsInMillis);
        }
        catch (ParserConfigurationException e) {
            log.error((Object)"Exception when parsing file event simulator configuration file", (Throwable)e);
        }
        catch (TransformerException e) {
            log.error((Object)"Exception when transforming file event simulator configuration file", (Throwable)e);
        }
    }

    @Override
    public void deleteFile(String fileName, AxisConfiguration axisConfiguration) throws AxisFault {
        int tenantID = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
        HashMap<String, CSVFileInfo> csvFileInfoMap = this.tenantSpecificCSVFileInfoMap.get(tenantID);
        CSVFileInfo csvFileInfo = csvFileInfoMap.get(fileName);
        File file = new File(csvFileInfo.getFilePath());
        if (!file.delete()) {
            throw new AxisFault("Failed to delete the file : " + csvFileInfo.getFileName() + " for tenant ID : " + tenantID);
        }
        Map<String, EventCreator> fileEventSimulatorMap = this.tenantSpecificFileEventSimulatorMap.get(tenantID);
        if (fileEventSimulatorMap != null) {
            fileEventSimulatorMap.remove(fileName);
        }
    }

    public HashMap<String, CSVFileInfo> getCSVFileInfoMap() {
        int tenantID = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
        return this.tenantSpecificCSVFileInfoMap.get(tenantID);
    }

    @Override
    public void sendEvents(String fileName) throws AxisFault {
        CSVFileInfo csvFileInfo;
        int tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
        EventCreator eventCreator = new EventCreator(fileName, tenantId);
        Thread eventCreatorThread = new Thread(eventCreator);
        Map<String, EventCreator> fileEventSimulatorMap = this.tenantSpecificFileEventSimulatorMap.get(tenantId);
        if (fileEventSimulatorMap == null) {
            fileEventSimulatorMap = new HashMap<String, EventCreator>();
            this.tenantSpecificFileEventSimulatorMap.put(tenantId, fileEventSimulatorMap);
        }
        fileEventSimulatorMap.put(fileName, eventCreator);
        eventCreatorThread.start();
        Map csvFileInfoMap = this.tenantSpecificCSVFileInfoMap.get(tenantId);
        if (csvFileInfoMap != null && (csvFileInfo = (CSVFileInfo)csvFileInfoMap.get(fileName)) != null) {
            csvFileInfo.setStatus(CSVFileInfo.Status.STARTED);
        }
    }

    @Override
    public void pauseEvents(String fileName) throws AxisFault {
        CSVFileInfo csvFileInfo;
        int tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
        Map<String, EventCreator> fileEventSimulatorMap = this.tenantSpecificFileEventSimulatorMap.get(tenantId);
        EventCreator eventCreator = fileEventSimulatorMap.get(fileName);
        eventCreator.pause();
        Map csvFileInfoMap = this.tenantSpecificCSVFileInfoMap.get(tenantId);
        if (csvFileInfoMap != null && (csvFileInfo = (CSVFileInfo)csvFileInfoMap.get(fileName)) != null) {
            csvFileInfo.setStatus(CSVFileInfo.Status.PAUSED);
        }
    }

    @Override
    public void resumeEvents(String fileName) throws AxisFault {
        CSVFileInfo csvFileInfo;
        int tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
        Map<String, EventCreator> fileEventSimulatorMap = this.tenantSpecificFileEventSimulatorMap.get(tenantId);
        EventCreator eventCreator = fileEventSimulatorMap.get(fileName);
        eventCreator.resume();
        Map csvFileInfoMap = this.tenantSpecificCSVFileInfoMap.get(tenantId);
        if (csvFileInfoMap != null && (csvFileInfo = (CSVFileInfo)csvFileInfoMap.get(fileName)) != null) {
            csvFileInfo.setStatus(CSVFileInfo.Status.RESUMED);
        }
    }

    @Override
    public void stopEvents(String fileName) throws AxisFault {
        CSVFileInfo csvFileInfo;
        int tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
        Map<String, EventCreator> fileEventSimulatorMap = this.tenantSpecificFileEventSimulatorMap.get(tenantId);
        EventCreator eventCreator = fileEventSimulatorMap.get(fileName);
        eventCreator.stop();
        Map csvFileInfoMap = this.tenantSpecificCSVFileInfoMap.get(tenantId);
        if (csvFileInfoMap != null && (csvFileInfo = (CSVFileInfo)csvFileInfoMap.get(fileName)) != null) {
            csvFileInfo.setStatus(CSVFileInfo.Status.STOPPED);
        }
    }

    @Override
    public void uploadService(UploadedFileItem[] fileItems, AxisConfiguration axisConfiguration) throws AxisFault {
        String repo = axisConfiguration.getRepository().getPath();
        if (CarbonUtils.isURL((String)repo)) {
            throw new AxisFault("URL Repositories are not supported: " + repo);
        }
        String csvDirectory = repo + "eventsimulatorfiles";
        String csvTemp = CarbonUtils.getCarbonHome() + EventSimulatorConstant.TEMP_DIR_PATH;
        File csvTempDir = new File(csvTemp);
        if (!csvTempDir.exists() && !csvTempDir.mkdirs()) {
            throw new AxisFault("Fail to create the directory: " + csvTempDir.getAbsolutePath());
        }
        File csvDir = new File(csvDirectory);
        if (!csvDir.exists() && !csvDir.mkdirs()) {
            throw new AxisFault("Fail to create the directory: " + csvDir.getAbsolutePath());
        }
        for (UploadedFileItem uploadedFile : fileItems) {
            String fileName = uploadedFile.getFileName();
            if (fileName == null || fileName.equals("")) {
                throw new AxisFault("Invalid file name. File name is not available");
            }
            if (uploadedFile.getFileType().equals("csv")) {
                try {
                    this.writeResource(uploadedFile.getDataHandler(), csvTemp, fileName, csvDir);
                    continue;
                }
                catch (IOException e) {
                    throw new AxisFault("IOError: Writing resource failed.", (Throwable)e);
                }
            }
            throw new AxisFault("Invalid file type : " + uploadedFile.getFileType() + " .csv file type is expected");
        }
    }

    private void writeResource(DataHandler dataHandler, String destPath, String fileName, File csvDest) throws IOException {
        File tempDestinationFile = new File(destPath, fileName);
        FileOutputStream fos = null;
        File destinationFile = new File(csvDest, fileName);
        try {
            fos = new FileOutputStream(tempDestinationFile);
            dataHandler.writeTo((OutputStream)fos);
            FileUtils.copyFile((File)tempDestinationFile, (File)destinationFile);
        }
        catch (FileNotFoundException e) {
            log.error((Object)"Cannot find the file that specified", (Throwable)e);
            throw e;
        }
        catch (IOException e) {
            log.error((Object)"Exception when reading the file", (Throwable)e);
            throw e;
        }
        finally {
            if (fos == null) {
                return;
            }
            try {
                fos.close();
            }
            catch (IOException e) {
                log.warn((Object)"Can't close file streams.", (Throwable)e);
            }
        }
        boolean isDeleted = tempDestinationFile.delete();
        if (!isDeleted) {
            log.warn((Object)("temp file: " + tempDestinationFile.getAbsolutePath() + " deletion failed, scheduled deletion on server exit."));
            tempDestinationFile.deleteOnExit();
        }
    }

    private List<Attribute> getStreamAttributeList(StreamDefinition streamDefinition) {
        ArrayList<Attribute> attributeList = new ArrayList<Attribute>();
        if (streamDefinition != null) {
            if (streamDefinition.getMetaData() != null) {
                for (Attribute attribute : streamDefinition.getMetaData()) {
                    attributeList.add(attribute);
                }
            }
            if (streamDefinition.getCorrelationData() != null) {
                for (Attribute attribute : streamDefinition.getCorrelationData()) {
                    attributeList.add(attribute);
                }
            }
            if (streamDefinition.getPayloadData() != null) {
                for (Attribute attribute : streamDefinition.getPayloadData()) {
                    attributeList.add(attribute);
                }
            }
        }
        return attributeList;
    }

    private StreamDefinition getStreamDefinition(String streamId) {
        EventStreamService eventStreamService = EventSimulatorValueHolder.getEventStreamService();
        StreamDefinition streamDefinition = null;
        try {
            List streamDefinitions = eventStreamService.getAllStreamDefinitions();
            for (StreamDefinition streamdef : streamDefinitions) {
                if (!streamdef.getStreamId().equals(streamId)) continue;
                streamDefinition = streamdef;
                break;
            }
        }
        catch (Exception e) {
            log.error((Object)"Exception when retrieving the stream definition", (Throwable)e);
        }
        return streamDefinition;
    }

    private boolean validateAttributeValues(List<Attribute> attributeList, String[] valueArray) throws AxisFault {
        if (attributeList.size() != valueArray.length) {
            throw new AxisFault("Failed configuration of event stream in this file or file is corrupted ");
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveConfigurationXML(String xmlContent, String configFileName, String filePath) {
        try {
            OutputStreamWriter writer = null;
            try {
                File file = new File(filePath);
                writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");
                writer.write(xmlContent);
                log.info((Object)("Event Simulator configuration file: " + configFileName + " saved in the filesystem"));
            }
            finally {
                if (writer != null) {
                    writer.flush();
                    writer.close();
                }
            }
        }
        catch (IOException e) {
            log.error((Object)("Error while saving " + configFileName), (Throwable)e);
        }
    }

    public void addDataSourceTableAndStreamInfo(DataSourceTableAndStreamInfo dataSourceTableAndStreamInfo) {
        int tenantID = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
        if (this.tenantSpecificDataSourceInfoMap.containsKey(tenantID)) {
            HashMap<String, DataSourceTableAndStreamInfo> dataSourceTableAndStreamInfoMap = this.tenantSpecificDataSourceInfoMap.get(tenantID);
            dataSourceTableAndStreamInfoMap.put(dataSourceTableAndStreamInfo.getConfigurationName(), dataSourceTableAndStreamInfo);
        } else {
            HashMap<String, DataSourceTableAndStreamInfo> dataSourceTableAndStreamInfoMap = new HashMap<String, DataSourceTableAndStreamInfo>();
            dataSourceTableAndStreamInfoMap.put(dataSourceTableAndStreamInfo.getConfigurationName(), dataSourceTableAndStreamInfo);
            this.tenantSpecificDataSourceInfoMap.put(tenantID, dataSourceTableAndStreamInfoMap);
        }
    }

    public void removeDataSourceTableAndStreamInfo(String datasourceConfigFileName) {
        HashMap<String, DataSourceTableAndStreamInfo> dataSourceTableAndStreamInfoMap;
        int tenantID = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
        if (this.tenantSpecificDataSourceInfoMap.containsKey(tenantID) && (dataSourceTableAndStreamInfoMap = this.tenantSpecificDataSourceInfoMap.get(tenantID)) != null) {
            dataSourceTableAndStreamInfoMap.remove(datasourceConfigFileName);
        }
    }

    @Override
    public List<DataSourceTableAndStreamInfo> getAllDataSourceInfo() {
        int tenantID = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
        HashMap<String, DataSourceTableAndStreamInfo> dataSourceTableAndStreamInfoMap = this.tenantSpecificDataSourceInfoMap.get(tenantID);
        if (dataSourceTableAndStreamInfoMap != null) {
            return new ArrayList<DataSourceTableAndStreamInfo>(dataSourceTableAndStreamInfoMap.values());
        }
        return null;
    }

    @Override
    public void createConfigurationXMLForDataSource(String tableAndAttributeMappingInfo, AxisConfiguration axisConfiguration) throws AxisFault {
        String repo = axisConfiguration.getRepository().getPath();
        String path = repo + "eventsimulatorfiles";
        try {
            JSONObject tableAndAttributeMappingJsonObj = new JSONObject(tableAndAttributeMappingInfo);
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            String fileName = tableAndAttributeMappingJsonObj.getString("name");
            Document doc = docBuilder.newDocument();
            Element rootElement = doc.createElement("streamConfiguration");
            rootElement.setAttribute("type", "database");
            rootElement.setAttribute("name", tableAndAttributeMappingJsonObj.getString("name"));
            doc.appendChild(rootElement);
            Element dataSourceName = doc.createElement("dataSource");
            dataSourceName.appendChild(doc.createTextNode(tableAndAttributeMappingJsonObj.getString("dataSource")));
            rootElement.appendChild(dataSourceName);
            Element tableName = doc.createElement("tableName");
            tableName.appendChild(doc.createTextNode(tableAndAttributeMappingJsonObj.getString("tableName")));
            rootElement.appendChild(tableName);
            Element streamNameID = doc.createElement("streamID");
            streamNameID.appendChild(doc.createTextNode(tableAndAttributeMappingJsonObj.getString("streamID")));
            rootElement.appendChild(streamNameID);
            Element delayBetweenEventsInMilies = doc.createElement("delayBetweenEventsInMilies");
            delayBetweenEventsInMilies.appendChild(doc.createTextNode(String.valueOf(tableAndAttributeMappingJsonObj.getLong("delayBetweenEventsInMilies"))));
            rootElement.appendChild(delayBetweenEventsInMilies);
            Element columnMappings = doc.createElement("columnMappings");
            JSONArray databaseColumnAndStreamAttributeInfo1 = tableAndAttributeMappingJsonObj.getJSONArray("dataSourceColumnsAndTypes");
            for (int i = 0; i < databaseColumnAndStreamAttributeInfo1.length(); ++i) {
                JSONObject temp = databaseColumnAndStreamAttributeInfo1.getJSONObject(i);
                Element columnMapping = doc.createElement("columnMapping");
                columnMapping.setAttribute("columnName", temp.getString("columnName"));
                columnMapping.setAttribute("streamAttribute", temp.getString("streamAttribute"));
                columnMappings.appendChild(columnMapping);
            }
            rootElement.appendChild(columnMappings);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            transformerFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            DOMSource source = new DOMSource(doc);
            String absolutePath = path + File.separator + fileName + "_datSourceStreamConfiguration.xml";
            EventSimulatorUtil.validatePath(fileName);
            StreamResult result = new StreamResult(new File(absolutePath));
            this.uploadXMLFile(axisConfiguration);
            transformer.transform(source, result);
        }
        catch (ParserConfigurationException e) {
            log.error((Object)"Exception when parsing the DB event simulator configuration file", (Throwable)e);
        }
        catch (TransformerException e) {
            log.error((Object)"Exception when transforming the DB event simulator configuration file", (Throwable)e);
        }
        catch (JSONException e) {
            log.error((Object)"Exception occurred when manipulating JSON DB configuration", (Throwable)e);
        }
    }

    private void uploadXMLFile(AxisConfiguration axisConfiguration) throws AxisFault {
        String repo = axisConfiguration.getRepository().getPath();
        if (CarbonUtils.isURL((String)repo)) {
            throw new AxisFault("URL Repositories are not supported: " + repo);
        }
        String xmlDirectory = repo + "eventsimulatorfiles";
        File csvDir = new File(xmlDirectory);
        if (!csvDir.exists() && !csvDir.mkdirs()) {
            throw new AxisFault("Fail to create the directory: " + csvDir.getAbsolutePath());
        }
    }

    @Override
    public void deleteDBConfigFile(String fileName, AxisConfiguration axisConfiguration) throws AxisFault {
        int tenantID = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
        HashMap<String, DataSourceTableAndStreamInfo> dataSourceTableAndStreamInfoMap = this.tenantSpecificDataSourceInfoMap.get(tenantID);
        fileName = fileName.replace("_datSourceStreamConfiguration.xml", "");
        DataSourceTableAndStreamInfo dataSourceTableAndStreamInfo = dataSourceTableAndStreamInfoMap.get(fileName);
        String repo = axisConfiguration.getRepository().getPath();
        String path = repo + "eventsimulatorfiles";
        String xmlFilePath = path + File.separator + dataSourceTableAndStreamInfo.getFileName();
        EventSimulatorUtil.validatePath(fileName);
        File xmlFile = new File(xmlFilePath);
        if (xmlFile.exists()) {
            dataSourceTableAndStreamInfoMap.remove(fileName);
            xmlFile.delete();
            Map<String, EventCreatorForDB> dbEventSimulatorMap = this.tenantSpecificDBEventSimulatorMap.get(tenantID);
            if (dbEventSimulatorMap != null) {
                dbEventSimulatorMap.remove(fileName);
            }
        }
    }

    @Override
    public String createTableAndAttributeMappingInfo(String fileName) throws AxisFault {
        int tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
        PrivilegedCarbonContext.startTenantFlow();
        PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantId(tenantId, true);
        fileName = fileName.replace("_datSourceStreamConfiguration.xml", "");
        HashMap<String, DataSourceTableAndStreamInfo> dataSourceInfoMap = this.tenantSpecificDataSourceInfoMap.get(tenantId);
        DataSourceTableAndStreamInfo dataSourceTableAndStreamInfo = dataSourceInfoMap.get(fileName);
        String jsonFormattedAllInfo = "{\"streamID\":\"" + dataSourceTableAndStreamInfo.getEventStreamID() + "\",\"" + "dataSource" + "\":\"" + dataSourceTableAndStreamInfo.getDataSourceName() + "\",\"" + "tableName" + "\":\"" + dataSourceTableAndStreamInfo.getTableName() + "\", \"" + "name" + "\":\"" + dataSourceTableAndStreamInfo.getConfigurationName() + "\", \"" + "delayBetweenEventsInMilies" + "\":" + dataSourceTableAndStreamInfo.getDelayBetweenEventsInMillis() + ",\"" + "dataSourceColumnsAndTypes" + "\":[";
        String jsonAttribute = "";
        String[][] columnAndStreamAttributeNames = dataSourceTableAndStreamInfo.getDataSourceColumnsAndTypes();
        StreamDefinition streamDefinition = this.getStreamDefinition(dataSourceTableAndStreamInfo.getEventStreamID());
        ArrayList metaAttributeList = streamDefinition.getMetaData();
        ArrayList correlationAttributeList = streamDefinition.getCorrelationData();
        ArrayList payloadAttributeList = streamDefinition.getPayloadData();
        if (metaAttributeList == null) {
            metaAttributeList = new ArrayList(0);
        }
        if (correlationAttributeList == null) {
            correlationAttributeList = new ArrayList(0);
        }
        if (payloadAttributeList == null) {
            payloadAttributeList = new ArrayList(0);
        }
        int q = 0;
        int r = 0;
        for (int i = 0; i < columnAndStreamAttributeNames[0].length; ++i) {
            int j;
            if (i < metaAttributeList.size()) {
                for (j = 0; j < columnAndStreamAttributeNames[0].length; ++j) {
                    if (!((Attribute)metaAttributeList.get(i)).getName().equalsIgnoreCase(columnAndStreamAttributeNames[1][j])) continue;
                    jsonAttribute = jsonAttribute + "{\"" + "streamAttribute" + "\":\"" + ((Attribute)metaAttributeList.get(i)).getName() + "\",\"" + "columnName" + "\":\"" + columnAndStreamAttributeNames[0][j] + "\",\"" + "columnType" + "\":\"" + ((Attribute)metaAttributeList.get(i)).getType() + "\"},";
                }
                q = 0;
                continue;
            }
            if (i >= metaAttributeList.size() && q < correlationAttributeList.size()) {
                for (j = 0; j < columnAndStreamAttributeNames[0].length; ++j) {
                    if (!((Attribute)correlationAttributeList.get(q)).getName().equalsIgnoreCase(columnAndStreamAttributeNames[1][j])) continue;
                    jsonAttribute = jsonAttribute + "{\"" + "streamAttribute" + "\":\"" + ((Attribute)correlationAttributeList.get(q)).getName() + "\",\"" + "columnName" + "\":\"" + columnAndStreamAttributeNames[0][j] + "\",\"" + "columnType" + "\":\"" + ((Attribute)correlationAttributeList.get(q)).getType() + "\"},";
                }
                ++q;
                r = 0;
                continue;
            }
            for (j = 0; j < columnAndStreamAttributeNames[0].length; ++j) {
                if (!((Attribute)payloadAttributeList.get(r)).getName().equalsIgnoreCase(columnAndStreamAttributeNames[1][j])) continue;
                jsonAttribute = jsonAttribute + "{\"" + "streamAttribute" + "\":\"" + ((Attribute)payloadAttributeList.get(r)).getName() + "\",\"" + "columnName" + "\":\"" + columnAndStreamAttributeNames[0][j] + "\",\"" + "columnType" + "\":\"" + ((Attribute)payloadAttributeList.get(r)).getType() + "\"},";
            }
            ++r;
        }
        jsonFormattedAllInfo = jsonFormattedAllInfo + jsonAttribute + "]}";
        return jsonFormattedAllInfo;
    }

    @Override
    public void sendEventsViaDB(String fileName, JSONObject allInfo, String getPreparedSelectStatement) throws AxisFault {
        DataSourceTableAndStreamInfo dataSourceTableAndStreamInfo;
        int tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
        EventCreatorForDB eventCreatorForDB = new EventCreatorForDB(fileName, tenantId, allInfo, getPreparedSelectStatement);
        Thread eventCreatorThread = new Thread(eventCreatorForDB);
        Map<String, EventCreatorForDB> dbEventSimulatorMap = this.tenantSpecificDBEventSimulatorMap.get(tenantId);
        if (dbEventSimulatorMap == null) {
            dbEventSimulatorMap = new HashMap<String, EventCreatorForDB>();
            this.tenantSpecificDBEventSimulatorMap.put(tenantId, dbEventSimulatorMap);
        }
        dbEventSimulatorMap.put(fileName, eventCreatorForDB);
        eventCreatorThread.start();
        Map dataSourceTableAndStreamInfoHashMap = this.tenantSpecificDataSourceInfoMap.get(tenantId);
        if (dataSourceTableAndStreamInfoHashMap != null && (dataSourceTableAndStreamInfo = (DataSourceTableAndStreamInfo)dataSourceTableAndStreamInfoHashMap.get(fileName)) != null) {
            dataSourceTableAndStreamInfo.setStatus(DataSourceTableAndStreamInfo.Status.STARTED);
        }
    }

    @Override
    public void pauseEventsViaDB(String fileName) throws AxisFault {
        DataSourceTableAndStreamInfo dataSourceTableAndStreamInfo;
        int tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
        Map<String, EventCreatorForDB> dbEventSimulatorMap = this.tenantSpecificDBEventSimulatorMap.get(tenantId);
        EventCreatorForDB eventCreator = dbEventSimulatorMap.get(fileName);
        eventCreator.pause();
        Map dataSourceTableAndStreamInfoHashMap = this.tenantSpecificDataSourceInfoMap.get(tenantId);
        if (dataSourceTableAndStreamInfoHashMap != null && (dataSourceTableAndStreamInfo = (DataSourceTableAndStreamInfo)dataSourceTableAndStreamInfoHashMap.get(fileName)) != null) {
            dataSourceTableAndStreamInfo.setStatus(DataSourceTableAndStreamInfo.Status.PAUSED);
        }
    }

    @Override
    public void resumeEventsViaDB(String fileName) throws AxisFault {
        DataSourceTableAndStreamInfo dataSourceTableAndStreamInfo;
        int tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
        Map<String, EventCreatorForDB> dbEventSimulatorMap = this.tenantSpecificDBEventSimulatorMap.get(tenantId);
        EventCreatorForDB eventCreator = dbEventSimulatorMap.get(fileName);
        eventCreator.resume();
        Map dataSourceTableAndStreamInfoHashMap = this.tenantSpecificDataSourceInfoMap.get(tenantId);
        if (dataSourceTableAndStreamInfoHashMap != null && (dataSourceTableAndStreamInfo = (DataSourceTableAndStreamInfo)dataSourceTableAndStreamInfoHashMap.get(fileName)) != null) {
            dataSourceTableAndStreamInfo.setStatus(DataSourceTableAndStreamInfo.Status.RESUMED);
        }
    }

    @Override
    public void stopEventsViaDB(String fileName) throws AxisFault {
        DataSourceTableAndStreamInfo dataSourceTableAndStreamInfo;
        int tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
        Map<String, EventCreatorForDB> dbEventSimulatorMap = this.tenantSpecificDBEventSimulatorMap.get(tenantId);
        EventCreatorForDB eventCreator = dbEventSimulatorMap.get(fileName);
        eventCreator.stop();
        Map dataSourceTableAndStreamInfoHashMap = this.tenantSpecificDataSourceInfoMap.get(tenantId);
        if (dataSourceTableAndStreamInfoHashMap != null && (dataSourceTableAndStreamInfo = (DataSourceTableAndStreamInfo)dataSourceTableAndStreamInfoHashMap.get(fileName)) != null) {
            dataSourceTableAndStreamInfo.setStatus(DataSourceTableAndStreamInfo.Status.STOPPED);
        }
    }

    class EventCreatorForDB
    implements Runnable {
        private String fileName;
        private ResultSet resultSet;
        private int tenantId;
        private JSONObject allInfo;
        private DataSource datasource;
        private JSONArray columnAndAttributeMapping;
        private long delayBetweenEventsInMillis;
        private final Object lock = new Object();
        private volatile boolean isPaused = false;
        private volatile boolean isStopped = false;

        public EventCreatorForDB(String fileName, int tenantId, JSONObject tableAndAttributeMappingJsonObj, String preparedSelectStatement) throws AxisFault {
            this.fileName = fileName;
            this.tenantId = tenantId;
            this.allInfo = tableAndAttributeMappingJsonObj;
            try {
                String dataSourceName = tableAndAttributeMappingJsonObj.getString("dataSource");
                this.delayBetweenEventsInMillis = tableAndAttributeMappingJsonObj.getLong("delayBetweenEventsInMilies");
                if (this.delayBetweenEventsInMillis <= 0L) {
                    log.warn((Object)("Events will be sent continuously since the delay between events are set to " + this.delayBetweenEventsInMillis + "milliseconds"));
                    this.delayBetweenEventsInMillis = 0L;
                }
                try {
                    CarbonDataSource carbonDataSource = EventSimulatorValueHolder.getDataSourceService().getDataSource(dataSourceName);
                    this.datasource = (DataSource)carbonDataSource.getDSObject();
                    try (Connection con = this.datasource.getConnection();
                         Statement stmt = con.createStatement();){
                        this.resultSet = stmt.executeQuery(preparedSelectStatement);
                    }
                    catch (SQLException e) {
                        log.error((Object)("Exception when getting connection string for : " + dataSourceName), (Throwable)e);
                        throw new AxisFault("Exception when getting connection string for : " + dataSourceName, (Throwable)e);
                    }
                }
                catch (DataSourceException e) {
                    log.error((Object)("There is no any data source found named: " + dataSourceName), (Throwable)e);
                    throw new AxisFault("There is no any data source found named: " + dataSourceName, (Throwable)e);
                }
            }
            catch (JSONException e) {
                log.error((Object)"Json Exception occurred", (Throwable)e);
                throw new AxisFault("Json Exception occurred", (Throwable)e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                PrivilegedCarbonContext.startTenantFlow();
                PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantId(this.tenantId, true);
                this.columnAndAttributeMapping = this.allInfo.getJSONArray("dataSourceColumnsAndTypes");
                StreamDefinition streamDefinition = CarbonEventSimulator.this.getStreamDefinition(this.allInfo.getString("streamID"));
                List metaAttributeList = streamDefinition.getMetaData();
                List correlationAttributeList = streamDefinition.getCorrelationData();
                List payloadAttributeList = streamDefinition.getPayloadData();
                while (this.resultSet.next()) {
                    String columnName;
                    int columnIndex;
                    int noOfAttributes;
                    String[] attributeValues;
                    Event event;
                    block57: {
                        Iterator iterator;
                        block58: {
                            block56: {
                                if (this.isPaused) break block56;
                                event = new Event();
                                event.setStreamDefinition(streamDefinition);
                                attributeValues = new String[this.columnAndAttributeMapping.length()];
                                noOfAttributes = 0;
                                columnIndex = 0;
                                columnName = this.columnAndAttributeMapping.getJSONObject(columnIndex).getString("columnName");
                                if (metaAttributeList == null) break block57;
                                iterator = metaAttributeList.iterator();
                                break block58;
                            }
                            if (this.isStopped) {
                                return;
                            }
                            Object object = this.lock;
                            synchronized (object) {
                                try {
                                    this.lock.wait();
                                }
                                catch (InterruptedException e) {
                                    Thread.currentThread().interrupt();
                                    continue;
                                }
                            }
                        }
                        while (iterator.hasNext()) {
                            Attribute metaAttribute = (Attribute)iterator.next();
                            if (metaAttribute.getType() == AttributeType.INT) {
                                attributeValues[noOfAttributes] = String.valueOf(this.resultSet.getInt(columnName));
                            } else if (metaAttribute.getType() == AttributeType.LONG) {
                                attributeValues[noOfAttributes] = String.valueOf(this.resultSet.getLong(columnName));
                            } else if (metaAttribute.getType() == AttributeType.FLOAT) {
                                attributeValues[noOfAttributes] = String.valueOf(this.resultSet.getFloat(columnName));
                            } else if (metaAttribute.getType() == AttributeType.DOUBLE) {
                                attributeValues[noOfAttributes] = String.valueOf(this.resultSet.getDouble(columnName));
                            } else if (metaAttribute.getType() == AttributeType.STRING) {
                                attributeValues[noOfAttributes] = String.valueOf(this.resultSet.getString(columnName));
                            } else if (metaAttribute.getType() == AttributeType.BOOL) {
                                attributeValues[noOfAttributes] = String.valueOf(this.resultSet.getBoolean(columnName));
                            }
                            if (columnIndex >= this.columnAndAttributeMapping.length() - 1) continue;
                            ++noOfAttributes;
                            columnName = this.columnAndAttributeMapping.getJSONObject(++columnIndex).getString("columnName");
                        }
                    }
                    if (correlationAttributeList != null) {
                        for (Attribute correlationAttribute : correlationAttributeList) {
                            if (correlationAttribute.getType() == AttributeType.INT) {
                                attributeValues[noOfAttributes] = String.valueOf(this.resultSet.getInt(columnName));
                            } else if (correlationAttribute.getType() == AttributeType.LONG) {
                                attributeValues[noOfAttributes] = String.valueOf(this.resultSet.getLong(columnName));
                            } else if (correlationAttribute.getType() == AttributeType.FLOAT) {
                                attributeValues[noOfAttributes] = String.valueOf(this.resultSet.getFloat(columnName));
                            } else if (correlationAttribute.getType() == AttributeType.DOUBLE) {
                                attributeValues[noOfAttributes] = String.valueOf(this.resultSet.getDouble(columnName));
                            } else if (correlationAttribute.getType() == AttributeType.STRING) {
                                attributeValues[noOfAttributes] = String.valueOf(this.resultSet.getString(columnName));
                            } else if (correlationAttribute.getType() == AttributeType.BOOL) {
                                attributeValues[noOfAttributes] = String.valueOf(this.resultSet.getBoolean(columnName));
                            }
                            if (columnIndex >= this.columnAndAttributeMapping.length() - 1) continue;
                            ++noOfAttributes;
                            columnName = this.columnAndAttributeMapping.getJSONObject(++columnIndex).getString("columnName");
                        }
                    }
                    if (payloadAttributeList != null) {
                        for (Attribute payloadAttribute : payloadAttributeList) {
                            if (payloadAttribute.getType() == AttributeType.INT) {
                                attributeValues[noOfAttributes] = String.valueOf(this.resultSet.getInt(columnName));
                            } else if (payloadAttribute.getType() == AttributeType.LONG) {
                                attributeValues[noOfAttributes] = String.valueOf(this.resultSet.getLong(columnName));
                            } else if (payloadAttribute.getType() == AttributeType.FLOAT) {
                                attributeValues[noOfAttributes] = String.valueOf(this.resultSet.getFloat(columnName));
                            } else if (payloadAttribute.getType() == AttributeType.DOUBLE) {
                                attributeValues[noOfAttributes] = String.valueOf(this.resultSet.getDouble(columnName));
                            } else if (payloadAttribute.getType() == AttributeType.STRING) {
                                attributeValues[noOfAttributes] = String.valueOf(this.resultSet.getString(columnName));
                            } else if (payloadAttribute.getType() == AttributeType.BOOL) {
                                attributeValues[noOfAttributes] = String.valueOf(this.resultSet.getBoolean(columnName));
                            }
                            if (columnIndex >= this.columnAndAttributeMapping.length() - 1) continue;
                            ++noOfAttributes;
                            columnName = this.columnAndAttributeMapping.getJSONObject(++columnIndex).getString("columnName");
                        }
                    }
                    event.setAttributeValues(attributeValues);
                    CarbonEventSimulator.this.sendEvent(event);
                    if (this.delayBetweenEventsInMillis <= 0L) continue;
                    Thread.sleep(this.delayBetweenEventsInMillis);
                }
                return;
            }
            catch (SQLException e) {
                log.error((Object)("database exception occurred: " + e.getMessage()), (Throwable)e);
                return;
            }
            catch (JSONException e) {
                log.error((Object)"JSON Exception occurred when manipulating ", (Throwable)e);
                return;
            }
            catch (AxisFault axisFault) {
                log.error((Object)axisFault.getMessage(), (Throwable)axisFault);
                return;
            }
            catch (InterruptedException e) {
                log.error((Object)("Error when delaying sending events: " + e.getMessage()), (Throwable)e);
                return;
            }
            finally {
                DataSourceTableAndStreamInfo dataSourceTableAndStreamInfo;
                PrivilegedCarbonContext.endTenantFlow();
                Map dataSourceTableAndStreamInfoHashMap = (Map)CarbonEventSimulator.this.tenantSpecificDataSourceInfoMap.get(this.tenantId);
                if (dataSourceTableAndStreamInfoHashMap != null && (dataSourceTableAndStreamInfo = (DataSourceTableAndStreamInfo)dataSourceTableAndStreamInfoHashMap.get(this.fileName)) != null) {
                    dataSourceTableAndStreamInfo.setStatus(DataSourceTableAndStreamInfo.Status.STOPPED);
                }
            }
        }

        public void pause() {
            this.isPaused = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void resume() {
            this.isPaused = false;
            Object object = this.lock;
            synchronized (object) {
                this.lock.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stop() {
            this.isPaused = true;
            this.isStopped = true;
            Object object = this.lock;
            synchronized (object) {
                this.lock.notifyAll();
            }
        }
    }

    class EventCreator
    implements Runnable {
        String fileName;
        int tenantId;
        private final Object lock = new Object();
        private volatile boolean isPaused = false;
        private volatile boolean isStopped = false;

        public EventCreator(String fileName, int tenantId) {
            this.fileName = fileName;
            this.tenantId = tenantId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            Map csvFileInfoMap;
            try {
                PrivilegedCarbonContext.startTenantFlow();
                PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantId(this.tenantId, true);
                csvFileInfoMap = (HashMap)CarbonEventSimulator.this.tenantSpecificCSVFileInfoMap.get(this.tenantId);
                CSVFileInfo fileInfo = (CSVFileInfo)((HashMap)csvFileInfoMap).get(this.fileName);
                String path = fileInfo.getFilePath();
                long delayBetweenEventsInMillis = fileInfo.getDelayBetweenEventsInMillis();
                if (delayBetweenEventsInMillis <= 0L) {
                    log.warn((Object)("Events will be sent continuously since the delay between events are set to " + delayBetweenEventsInMillis + "milliseconds"));
                    delayBetweenEventsInMillis = 0L;
                }
                File file = new File(path);
                FileInputStream fileInputStream = null;
                BufferedInputStream bufferedInputStream = null;
                DataInputStream dataInputStream = null;
                StreamDefinition streamDefinition = CarbonEventSimulator.this.getStreamDefinition(fileInfo.getStreamID());
                try {
                    fileInputStream = new FileInputStream(file);
                    bufferedInputStream = new BufferedInputStream(fileInputStream);
                    dataInputStream = new DataInputStream(bufferedInputStream);
                    int rowNumber = 0;
                    while (dataInputStream.available() != 0) {
                        if (!this.isPaused) {
                            block17: {
                                String eventValues = dataInputStream.readLine();
                                try {
                                    String[] attributeValueList = eventValues.split(Pattern.quote(fileInfo.getSeparateCharacter()));
                                    Event event = new Event();
                                    event.setStreamDefinition(streamDefinition);
                                    event.setAttributeValues(attributeValueList);
                                    CarbonEventSimulator.this.sendEvent(event);
                                    if (delayBetweenEventsInMillis <= 0L) break block17;
                                    Thread.sleep(delayBetweenEventsInMillis);
                                }
                                catch (Exception e) {
                                    log.error((Object)("Error in row " + rowNumber + "-failed to create an event " + e));
                                    ++rowNumber;
                                    continue;
                                }
                            }
                            ++rowNumber;
                            continue;
                        }
                        if (this.isStopped) break;
                        Object object = this.lock;
                        synchronized (object) {
                            try {
                                this.lock.wait();
                            }
                            catch (InterruptedException e) {
                                Thread.currentThread().interrupt();
                            }
                        }
                    }
                }
                catch (IOException e) {
                    try {
                        log.error((Object)("Exception occurred while reading the data file: " + path), (Throwable)e);
                    }
                    catch (Throwable throwable) {
                        this.closedQuietly(path, dataInputStream, bufferedInputStream, fileInputStream);
                        throw throwable;
                    }
                    this.closedQuietly(path, dataInputStream, bufferedInputStream, fileInputStream);
                    return;
                }
                this.closedQuietly(path, dataInputStream, bufferedInputStream, fileInputStream);
                return;
            }
            finally {
                CSVFileInfo csvFileInfo;
                PrivilegedCarbonContext.endTenantFlow();
                csvFileInfoMap = (Map)CarbonEventSimulator.this.tenantSpecificCSVFileInfoMap.get(this.tenantId);
                if (csvFileInfoMap != null && (csvFileInfo = (CSVFileInfo)csvFileInfoMap.get(this.fileName)) != null) {
                    csvFileInfo.setStatus(CSVFileInfo.Status.STOPPED);
                }
            }
        }

        private void closedQuietly(String closingFile, Closeable ... closeables) {
            if (closeables == null) {
                return;
            }
            for (Closeable closeable : closeables) {
                try {
                    if (closeable == null) continue;
                    closeable.close();
                }
                catch (IOException e) {
                    log.error((Object)("Exception occurred while closing the stream related to data file: " + closingFile), (Throwable)e);
                }
            }
        }

        public void pause() {
            this.isPaused = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void resume() {
            this.isPaused = false;
            Object object = this.lock;
            synchronized (object) {
                this.lock.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stop() {
            this.isPaused = true;
            this.isStopped = true;
            Object object = this.lock;
            synchronized (object) {
                this.lock.notifyAll();
            }
        }
    }
}

