/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.simulator.core;

import java.io.File;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.deployment.AbstractDeployer;
import org.apache.axis2.deployment.DeploymentException;
import org.apache.axis2.deployment.repository.util.DeploymentFileData;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.event.simulator.core.CSVFileInfo;
import org.wso2.carbon.event.simulator.core.DataSourceTableAndStreamInfo;
import org.wso2.carbon.event.simulator.core.internal.CarbonEventSimulator;
import org.wso2.carbon.event.simulator.core.internal.ds.EventSimulatorValueHolder;
import org.wso2.carbon.event.simulator.core.internal.util.DeploymentHelper;

public class XMLFileDeployer
extends AbstractDeployer {
    private static final Log log = LogFactory.getLog(XMLFileDeployer.class);
    private ConfigurationContext configurationContext;

    public void init(ConfigurationContext configurationContext) {
        this.configurationContext = configurationContext;
    }

    public void deploy(DeploymentFileData deploymentFileData) throws DeploymentException {
        String path = deploymentFileData.getAbsolutePath();
        try {
            if (deploymentFileData.getName().contains("_streamConfiguration.xml")) {
                this.processDeployStreamConfig(deploymentFileData);
            } else if (deploymentFileData.getName().contains("_datSourceStreamConfiguration.xml")) {
                this.processDeployDatasourceConfig(deploymentFileData);
            } else {
                log.warn((Object)("XML file : " + deploymentFileData.getName() + " not deployed. Name should contain either " + "_streamConfiguration.xml" + " or " + "_datSourceStreamConfiguration.xml"));
            }
        }
        catch (Throwable t) {
            File file = new File(path);
            log.error((Object)("Could not deploy XML file : " + file.getName()), t);
            throw new DeploymentException("XML file not deployed and in inactive state :  " + new File(path).getName(), t);
        }
    }

    public void undeploy(String filePath) throws DeploymentException {
        try {
            File file = new File(filePath);
            if (file.getName().contains("_streamConfiguration.xml")) {
                this.processUndeployStreamConfig(file);
            } else if (file.getName().contains("_datSourceStreamConfiguration.xml")) {
                this.processUndeployDatasourceConfig(file);
            }
        }
        catch (Throwable t) {
            File file = new File(filePath);
            log.error((Object)("Could not deploy XML file : " + file.getName()), t);
            throw new DeploymentException("XML file could not be undeployed :  " + file.getName(), t);
        }
    }

    public void setDirectory(String s) {
    }

    public void setExtension(String s) {
    }

    public void processDeployDatasourceConfig(DeploymentFileData deploymentFileData) throws DeploymentException {
        File xmlFile = deploymentFileData.getFile();
        DataSourceTableAndStreamInfo dataSourceTableAndStreamInfo = DeploymentHelper.getEventMappingConfiguration(xmlFile);
        dataSourceTableAndStreamInfo.setFileName(xmlFile.getName());
        dataSourceTableAndStreamInfo.setFilePath(xmlFile.getAbsolutePath());
        dataSourceTableAndStreamInfo.setStatus(DataSourceTableAndStreamInfo.Status.STOPPED);
        CarbonEventSimulator eventSimulator = EventSimulatorValueHolder.getEventSimulator();
        if (dataSourceTableAndStreamInfo != null) {
            eventSimulator.addDataSourceTableAndStreamInfo(dataSourceTableAndStreamInfo);
        }
    }

    public void processUndeployDatasourceConfig(File datasourceConfigFile) {
        String datasourceConfigFileName = datasourceConfigFile.getName().replace("_datSourceStreamConfiguration.xml", "");
        CarbonEventSimulator eventSimulator = EventSimulatorValueHolder.getEventSimulator();
        eventSimulator.removeDataSourceTableAndStreamInfo(datasourceConfigFileName);
    }

    public void processDeployStreamConfig(DeploymentFileData deploymentFileData) throws DeploymentException {
        CSVFileInfo csvFileInfo = DeploymentHelper.getCSVFileInfo(deploymentFileData.getFile(), this.configurationContext.getAxisConfiguration());
        CarbonEventSimulator eventSimulator = EventSimulatorValueHolder.getEventSimulator();
        eventSimulator.addCSVFileInfo(csvFileInfo);
    }

    public void processUndeployStreamConfig(File csvFile) {
        String csvFileName = csvFile.getName().replace("_streamConfiguration.xml", ".csv");
        CarbonEventSimulator eventSimulator = EventSimulatorValueHolder.getEventSimulator();
        eventSimulator.removeCSVFileInfo(csvFileName);
    }
}

