/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.simulator.core;

import java.io.File;
import java.util.HashMap;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.deployment.AbstractDeployer;
import org.apache.axis2.deployment.DeploymentException;
import org.apache.axis2.deployment.repository.util.DeploymentFileData;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.event.simulator.core.CSVFileInfo;
import org.wso2.carbon.event.simulator.core.internal.CarbonEventSimulator;
import org.wso2.carbon.event.simulator.core.internal.ds.EventSimulatorValueHolder;
import org.wso2.carbon.event.simulator.core.internal.util.DeploymentHelper;

public class CSVFileDeployer
extends AbstractDeployer {
    private static final Log log = LogFactory.getLog(CSVFileDeployer.class);
    private ConfigurationContext configurationContext;

    public void init(ConfigurationContext configurationContext) {
        this.configurationContext = configurationContext;
    }

    public void deploy(DeploymentFileData deploymentFileData) throws DeploymentException {
        String path = deploymentFileData.getAbsolutePath();
        try {
            this.processDeploy(deploymentFileData);
        }
        catch (Throwable t) {
            File file = new File(path);
            log.error((Object)("Could not deploy CSV file : " + file.getName()), t);
            throw new DeploymentException("CSV file not deployed and in inactive state :  " + file.getName(), t);
        }
    }

    public void undeploy(String filePath) throws DeploymentException {
        try {
            this.processUndeploy(filePath);
        }
        catch (Throwable t) {
            File file = new File(filePath);
            log.error((Object)("Could not undeploy CSV file : " + file.getName()), t);
            throw new DeploymentException("CSV file could not be undeployed :  " + file.getName(), t);
        }
    }

    public void setDirectory(String s) {
    }

    public void setExtension(String s) {
    }

    public void processDeploy(DeploymentFileData deploymentFileData) throws DeploymentException {
        CSVFileInfo csvFileInfo = null;
        File csvFile = deploymentFileData.getFile();
        String xmlName = csvFile.getName().substring(0, csvFile.getName().length() - 4) + "_streamConfiguration.xml";
        String repo = this.configurationContext.getAxisConfiguration().getRepository().getPath();
        String dirPath = repo + "eventsimulatorfiles";
        String absolutePath = dirPath + File.separator + xmlName;
        File xmlFile = new File(absolutePath);
        if (xmlFile.exists()) {
            csvFileInfo = DeploymentHelper.getCSVFileInfo(xmlFile, this.configurationContext.getAxisConfiguration());
        }
        if (csvFileInfo == null) {
            csvFileInfo = new CSVFileInfo();
        }
        csvFileInfo.setFileName(csvFile.getName());
        csvFileInfo.setFilePath(csvFile.getAbsolutePath());
        CarbonEventSimulator eventSimulator = EventSimulatorValueHolder.getEventSimulator();
        eventSimulator.addCSVFileInfo(csvFileInfo);
        log.info((Object)("CSV file " + csvFile.getName() + " deployed successfully."));
    }

    public void processUndeploy(String filePath) throws DeploymentException {
        CarbonEventSimulator eventSimulator = EventSimulatorValueHolder.getEventSimulator();
        HashMap<String, CSVFileInfo> csvFileInfoMap = eventSimulator.getCSVFileInfoMap();
        File csvFile = new File(filePath);
        CSVFileInfo csvFileInfo = csvFileInfoMap.get(csvFile.getName());
        String repo = this.configurationContext.getAxisConfiguration().getRepository().getPath();
        String path = repo + "eventsimulatorfiles";
        String xmlFileName = csvFileInfo.getFileName().substring(0, csvFileInfo.getFileName().length() - 4) + "_streamConfiguration.xml";
        String xmlFilePath = path + File.separator + xmlFileName;
        File xmlFile = new File(xmlFilePath);
        csvFileInfoMap.remove(csvFile.getName());
        if (xmlFile.exists() && !xmlFile.delete()) {
            int tenantID = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
            throw new DeploymentException(xmlFileName + " could not be deleted for tenant ID : " + tenantID);
        }
        log.info((Object)("CSV file " + csvFile.getName() + " undeployed successfully."));
    }
}

