/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.auth.valve.internal;

import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.wso2.carbon.identity.auth.service.AuthenticationManager;
import org.wso2.carbon.identity.auth.service.factory.AuthenticationRequestBuilderFactory;
import org.wso2.carbon.identity.auth.valve.internal.AuthenticationValveServiceHolder;
import org.wso2.carbon.identity.core.handler.HandlerComparator;

@Component(name="org.wso2.carbon.identity.auth.valve", immediate=true)
public class AuthenticationValveServiceComponent {
    private static final Log log = LogFactory.getLog(AuthenticationValveServiceComponent.class);

    @Activate
    protected void activate(ComponentContext cxt) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"AuthenticationValveServiceComponent is activated");
        }
    }

    @Reference(name="org.wso2.carbon.identity.auth.service.manager", service=AuthenticationManager.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetAuthenticationManager")
    protected void setAuthenticationManager(AuthenticationManager authenticationManager) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Set AuthenticationManager, " + authenticationManager != null ? authenticationManager.getName() : " Unknown"));
        }
        List<AuthenticationManager> authenticationManagers = AuthenticationValveServiceHolder.getInstance().getAuthenticationManagers();
        authenticationManagers.add(authenticationManager);
        Collections.sort(authenticationManagers, new HandlerComparator());
    }

    protected void unsetAuthenticationManager(AuthenticationManager authenticationManager) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Unset AuthenticationManager, " + authenticationManager != null ? authenticationManager.getName() : " Unknown"));
        }
        List<AuthenticationManager> authenticationManagers = AuthenticationValveServiceHolder.getInstance().getAuthenticationManagers();
        authenticationManagers.remove(authenticationManager);
    }

    @Reference(name="org.wso2.carbon.identity.auth.service.factory.auth", service=AuthenticationRequestBuilderFactory.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, unbind="removeAuthenticationRequestBuilderFactory")
    protected void addAuthenticationRequestBuilderFactory(AuthenticationRequestBuilderFactory requestBuilderFactory) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Set AuthenticationRequestBuilderFactory, " + requestBuilderFactory != null ? requestBuilderFactory.getName() : "Unknown"));
        }
        AuthenticationValveServiceHolder.getInstance().getRequestBuilderFactories().add(requestBuilderFactory);
    }

    protected void removeAuthenticationRequestBuilderFactory(AuthenticationRequestBuilderFactory requestBuilderFactory) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Unset AuthenticationRequestBuilderFactory, " + requestBuilderFactory != null ? requestBuilderFactory.getName() : "Unknown"));
        }
        AuthenticationValveServiceHolder.getInstance().getRequestBuilderFactories().remove(requestBuilderFactory);
    }
}

