/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.auth.valve;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import javax.servlet.ServletException;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.valves.ValveBase;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.slf4j.MDC;
import org.wso2.carbon.identity.application.common.util.IdentityApplicationManagementUtil;
import org.wso2.carbon.identity.auth.service.AuthenticationContext;
import org.wso2.carbon.identity.auth.service.AuthenticationManager;
import org.wso2.carbon.identity.auth.service.AuthenticationRequest;
import org.wso2.carbon.identity.auth.service.AuthenticationResult;
import org.wso2.carbon.identity.auth.service.AuthenticationStatus;
import org.wso2.carbon.identity.auth.service.exception.AuthClientException;
import org.wso2.carbon.identity.auth.service.exception.AuthRuntimeException;
import org.wso2.carbon.identity.auth.service.exception.AuthServerException;
import org.wso2.carbon.identity.auth.service.exception.AuthenticationFailException;
import org.wso2.carbon.identity.auth.service.module.ResourceConfig;
import org.wso2.carbon.identity.auth.service.module.ResourceConfigKey;
import org.wso2.carbon.identity.auth.service.util.AuthConfigurationUtil;
import org.wso2.carbon.identity.auth.valve.util.AuthHandlerManager;
import org.wso2.carbon.identity.base.IdentityRuntimeException;
import org.wso2.carbon.identity.core.util.IdentityConfigParser;
import org.wso2.carbon.identity.core.util.IdentityUtil;

public class AuthenticationValve
extends ValveBase {
    private static final String AUTH_CONTEXT = "auth-context";
    private static final String AUTH_HEADER_NAME = "WWW-Authenticate";
    private static final String USER_AGENT = "User-Agent";
    private static final String REMOTE_ADDRESS = "remoteAddress";
    private static final String SERVICE_PROVIDER = "serviceProvider";
    private final String SERVICE_PROVIDER_TENANT_DOMAIN = "serviceProviderTenantDomain";
    private static final String X_FORWARDED_USER_AGENT = "X-Forwarded-User-Agent";
    private final String CONFIG_CONTEXTUAL_PARAM = "LoggableContextualParams.contextual_param";
    private final String CONFIG_LOG_PARAM_USER_AGENT = "user_agent";
    private final String CONFIG_LOG_PARAM_REMOTE_ADDRESS = "remote_address";
    private static final Log log = LogFactory.getLog(AuthenticationValve.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(Request request, Response response) throws IOException, ServletException {
        AuthenticationContext authenticationContext = null;
        AuthenticationResult authenticationResult = null;
        try {
            AuthenticationManager authenticationManager = AuthHandlerManager.getInstance().getAuthenticationManager();
            ResourceConfig securedResource = authenticationManager.getSecuredResource(new ResourceConfigKey(request.getRequestURI(), request.getMethod()));
            String userAgent = request.getHeader(USER_AGENT);
            String forwardedUserAgent = request.getHeader(X_FORWARDED_USER_AGENT);
            if (StringUtils.isNotEmpty((String)forwardedUserAgent)) {
                userAgent = forwardedUserAgent;
            }
            String remoteAddr = request.getRemoteAddr();
            if (StringUtils.isNotEmpty((String)userAgent) && this.isLoggableParam("user_agent")) {
                MDC.put((String)USER_AGENT, (String)request.getHeader(USER_AGENT));
            }
            if (StringUtils.isNotEmpty((String)remoteAddr) && this.isLoggableParam("remote_address")) {
                MDC.put((String)REMOTE_ADDRESS, (String)remoteAddr);
            }
            if (this.isUnauthorized(securedResource)) {
                this.handleErrorResponse(null, response, 401, null);
                return;
            }
            if (securedResource == null || !securedResource.isSecured()) {
                this.getNext().invoke(request, response);
                return;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("AuthenticationValve hit on secured resource : " + request.getRequestURI()));
            }
            AuthenticationRequest.AuthenticationRequestBuilder authenticationRequestBuilder = AuthHandlerManager.getInstance().getRequestBuilder(request, response).createRequestBuilder(request, response);
            authenticationContext = new AuthenticationContext(authenticationRequestBuilder.build());
            authenticationContext.setResourceConfig(securedResource);
            authenticationResult = authenticationManager.authenticate(authenticationContext);
            AuthenticationStatus authenticationStatus = authenticationResult.getAuthenticationStatus();
            if (authenticationStatus.equals((Object)AuthenticationStatus.SUCCESS)) {
                this.setThreadLocalServiceProvider(authenticationContext);
                request.setAttribute(AUTH_CONTEXT, (Object)authenticationContext);
                this.getNext().invoke(request, response);
            } else {
                this.handleErrorResponse(authenticationContext, response, 401, null);
            }
        }
        catch (AuthClientException e) {
            this.handleErrorResponse(authenticationContext, response, 400, (Exception)((Object)e));
        }
        catch (AuthServerException e) {
            log.error((Object)"Auth Server Exception occurred in Authentication valve :", (Throwable)e);
            this.handleErrorResponse(authenticationContext, response, 400, null);
        }
        catch (AuthenticationFailException e) {
            this.handleErrorResponse(authenticationContext, response, 401, (Exception)((Object)e));
        }
        catch (AuthRuntimeException e) {
            log.error((Object)"Auth Runtime Exception occurred in Authentication valve :", (Throwable)e);
            this.handleErrorResponse(authenticationContext, response, 401, null);
        }
        catch (IdentityRuntimeException e) {
            log.error((Object)"Identity Runtime Exception occurred in Authentication valve :", (Throwable)e);
            this.handleErrorResponse(authenticationContext, response, 401, null);
        }
        finally {
            if (IdentityUtil.getIdentityErrorMsg() != null) {
                IdentityUtil.clearIdentityErrorMsg();
            }
            this.unsetThreadLocalServiceProvider();
            this.unsetCurrentSessionIdThreadLocal();
            IdentityApplicationManagementUtil.resetThreadLocalProvisioningServiceProvider();
        }
    }

    private boolean isUnauthorized(ResourceConfig securedResource) {
        String defaultAccess = AuthConfigurationUtil.getInstance().getDefaultAccess();
        return "deny".equalsIgnoreCase(defaultAccess) && securedResource == null;
    }

    private void setThreadLocalServiceProvider(AuthenticationContext authenticationContext) {
        Object serviceProvider = authenticationContext.getParameter((Object)SERVICE_PROVIDER);
        Object serviceProviderTenantDomain = authenticationContext.getParameter((Object)"serviceProviderTenantDomain");
        if (serviceProvider != null && serviceProviderTenantDomain != null) {
            ((Map)IdentityUtil.threadLocalProperties.get()).put(SERVICE_PROVIDER, serviceProvider);
            ((Map)IdentityUtil.threadLocalProperties.get()).put("serviceProviderTenantDomain", serviceProviderTenantDomain);
        }
    }

    private void unsetThreadLocalServiceProvider() {
        ((Map)IdentityUtil.threadLocalProperties.get()).remove(SERVICE_PROVIDER);
        ((Map)IdentityUtil.threadLocalProperties.get()).remove("serviceProviderTenantDomain");
    }

    private void handleErrorResponse(AuthenticationContext authenticationContext, Response response, int error, Exception e) throws IOException {
        if (log.isDebugEnabled() && e != null) {
            log.debug((Object)"Authentication Error ", (Throwable)e);
        }
        StringBuilder value = new StringBuilder(16);
        value.append("realm user=\"");
        if (authenticationContext != null && authenticationContext.getUser() != null) {
            value.append(authenticationContext.getUser().getUserName());
        }
        value.append('\"');
        response.setHeader(AUTH_HEADER_NAME, value.toString());
        response.sendError(error);
    }

    private boolean isLoggableParam(String param) {
        if (IdentityConfigParser.getInstance() != null) {
            Object configValue = IdentityConfigParser.getInstance().getConfiguration().get("LoggableContextualParams.contextual_param");
            ArrayList claimsFilters = new ArrayList();
            if (configValue instanceof ArrayList) {
                claimsFilters = (ArrayList)configValue;
            } else if (configValue instanceof String) {
                claimsFilters.add((String)configValue);
            }
            return claimsFilters.contains(param);
        }
        return false;
    }

    private void unsetCurrentSessionIdThreadLocal() {
        if (((Map)IdentityUtil.threadLocalProperties.get()).get("currentSessionIdentifier") != null) {
            ((Map)IdentityUtil.threadLocalProperties.get()).remove("currentSessionIdentifier");
        }
    }
}

