/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.governance.lcm.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.om.xpath.AXIOMXPath;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jaxen.JaxenException;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.context.RegistryType;
import org.wso2.carbon.governance.api.common.dataobjects.GovernanceArtifactImpl;
import org.wso2.carbon.governance.api.exception.GovernanceException;
import org.wso2.carbon.governance.lcm.beans.BoundaryBean;
import org.wso2.carbon.governance.lcm.beans.CheckpointBean;
import org.wso2.carbon.governance.lcm.beans.DurationBean;
import org.wso2.carbon.governance.lcm.util.CommonUtil;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.registry.core.utils.RegistryUtils;

public class LifecycleStateDurationUtils {
    private static final Log log = LogFactory.getLog(LifecycleStateDurationUtils.class);

    public static DurationBean getCurrentLifecycleStateDuration(String registryPathToResource, String lifecycleName, Registry registry) throws GovernanceException {
        if (StringUtils.isEmpty((String)registryPathToResource) || StringUtils.isEmpty((String)lifecycleName) || registry == null) {
            throw new IllegalArgumentException("Invalid arguments supplied as registryPathToResource: '" + registryPathToResource + "', lifecycleName: " + lifecycleName + " and registry.");
        }
        DurationBean durationBean = null;
        String historyResourcePath = "/_system/governance/repository/components/org.wso2.carbon.governance/lifecycles/history/" + registryPathToResource.replaceAll("/", "_");
        UserRegistry userRegistry = (UserRegistry)registry;
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Resource history file accessed in: " + historyResourcePath));
            }
            if (userRegistry.resourceExists(historyResourcePath)) {
                String textContent = RegistryUtils.decodeBytes((byte[])((byte[])userRegistry.get(historyResourcePath).getContent()));
                boolean historyFileEmpty = StringUtils.isEmpty((String)textContent);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Resource history file empty = " + historyFileEmpty));
                }
                if (!historyFileEmpty) {
                    OMElement omElement = LifecycleStateDurationUtils.getHistoryElement(textContent, lifecycleName, historyResourcePath);
                    String lastStateChangedTime = omElement.getAttribute(new QName("timestamp")).getAttributeValue();
                    durationBean = LifecycleStateDurationUtils.getCheckpointByDuration(lifecycleName, LifecycleStateDurationUtils.calculateTimeDifference(LifecycleStateDurationUtils.getCurrentTime(), lastStateChangedTime), registryPathToResource, registry);
                }
            }
        }
        catch (RegistryException e) {
            throw new GovernanceException("Error while checking resource exists for: '" + registryPathToResource + "'", (Throwable)e);
        }
        return durationBean;
    }

    public static long calculateTimeDifference(String timeStampOne, String timeStampTwo) {
        if (StringUtils.isEmpty((String)timeStampOne) && StringUtils.isEmpty((String)timeStampTwo)) {
            throw new IllegalArgumentException("Invalid arguments supplied as timestamp one: '" + timeStampOne + "' or timestamp two: '" + timeStampTwo + "' is not set");
        }
        return Timestamp.valueOf(timeStampOne).getTime() - Timestamp.valueOf(timeStampTwo).getTime();
    }

    private static AXIOMXPath getAxiomPath(String XpathString) throws GovernanceException {
        try {
            return new AXIOMXPath(XpathString);
        }
        catch (JaxenException e) {
            throw new GovernanceException("Error while getting value relevant to Xpath: " + XpathString, (Throwable)e);
        }
    }

    private static DurationBean getCheckpointByDuration(String lifecycleName, long duration, String registryPathToResource, Registry registry) throws GovernanceException {
        DurationBean durationBean = new DurationBean();
        String lifecycleCurrentState = LifecycleStateDurationUtils.getCurrentLifecycleState(registry, registryPathToResource, lifecycleName);
        if (StringUtils.isNotEmpty((String)lifecycleCurrentState)) {
            OMElement lifecycleConfigurationElement = LifecycleStateDurationUtils.getLifecycleConfigurationElement(lifecycleName);
            String xpathString = "/aspect/configuration/lifecycle/*[name()='scxml']/*[name()='state'][@id='" + lifecycleCurrentState + "']" + "/*[name()='checkpoints']/*[name()='checkpoint']";
            List checkpoints = CommonUtil.evaluateXpath(lifecycleConfigurationElement, xpathString, null);
            CheckpointBean checkpointBean = new CheckpointBean();
            if (!checkpoints.isEmpty()) {
                for (Object checkpoint : checkpoints) {
                    String maxTimestamp;
                    OMElement checkpointElement = (OMElement)checkpoint;
                    OMElement boundary = checkpointElement.getFirstChildWithName(new QName("http://www.w3.org/2005/07/scxml", "boundary"));
                    String minTimestamp = boundary.getAttribute(new QName("min")).getAttributeValue();
                    if (!LifecycleStateDurationUtils.isDurationBetweenTimestamps(duration, minTimestamp, maxTimestamp = boundary.getAttribute(new QName("max")).getAttributeValue())) continue;
                    String durationColour = checkpointElement.getAttribute(new QName("durationColour")).getAttributeValue();
                    String checkpointName = checkpointElement.getAttribute(new QName("id")).getAttributeValue();
                    BoundaryBean checkpointBoundaries = new BoundaryBean();
                    checkpointBoundaries.setMin(minTimestamp);
                    checkpointBoundaries.setMax(maxTimestamp);
                    checkpointBean.setCheckpointBoundaries(checkpointBoundaries);
                    checkpointBean.setDurationColour(durationColour.toLowerCase());
                    checkpointBean.setName(checkpointName);
                }
            }
            durationBean.setDuration(duration);
            durationBean.setCheckpoint(checkpointBean);
        }
        return durationBean;
    }

    private static boolean isDurationBetweenTimestamps(long duration, String minTime, String maxTime) {
        boolean result = false;
        long durationInMillySeconds = TimeUnit.MILLISECONDS.convert(duration, TimeUnit.MILLISECONDS);
        long minBoundaryInMillySeconds = LifecycleStateDurationUtils.getMillySecondsByDuration(minTime);
        long maxBoundaryInMillySeconds = LifecycleStateDurationUtils.getMillySecondsByDuration(maxTime);
        if (minBoundaryInMillySeconds < durationInMillySeconds && durationInMillySeconds < maxBoundaryInMillySeconds) {
            result = true;
        }
        return result;
    }

    public static long getMillySecondsByDuration(String duration) {
        if (StringUtils.isEmpty((String)duration)) {
            throw new IllegalArgumentException("Invalid arguments supplied as duration: " + duration);
        }
        String formattedDuration = duration.replaceAll("d", "").replaceAll("h", "").replaceAll("m", "").replaceAll("s", "");
        String[] tokens = formattedDuration.split(":");
        long secondsToMillySeconds = Long.parseLong(tokens[3]) * 1000L;
        long minutesToMillySeconds = Long.parseLong(tokens[2]) * 60L * 1000L;
        long hoursToMillySeconds = Long.parseLong(tokens[1]) * 60L * 60L * 1000L;
        long daysToMillySeconds = Long.parseLong(tokens[0]) * 24L * 60L * 60L * 1000L;
        return daysToMillySeconds + secondsToMillySeconds + minutesToMillySeconds + hoursToMillySeconds;
    }

    private static String getCurrentLifecycleState(Registry registry, String registryPathToResource, String lifecycleName) throws GovernanceException {
        String currentLifecycleState;
        block9: {
            currentLifecycleState = null;
            try {
                GovernanceArtifactImpl governanceArtifact;
                if (!registry.resourceExists(registryPathToResource)) break block9;
                currentLifecycleState = registry.get(registryPathToResource).getProperty("registry.lifecycle." + lifecycleName + ".state");
                if (currentLifecycleState != null) {
                    return currentLifecycleState;
                }
                String lifecycleStateProperty = registry.get(registryPathToResource).getProperty("registry.custom_lifecycle.checklist.option." + lifecycleName + ".0" + ".item");
                if (lifecycleStateProperty != null && StringUtils.isNotEmpty((String)lifecycleStateProperty)) {
                    String[] lifecycleStateProperties = lifecycleStateProperty.split(":");
                    currentLifecycleState = lifecycleStateProperties[1];
                    break block9;
                }
                try {
                    governanceArtifact = GovernanceArtifactImpl.create((Registry)registry, (String)registry.get(registryPathToResource).getUUID());
                }
                catch (RegistryException e) {
                    throw new GovernanceException("Error while creating generic artifact to resource" + registryPathToResource, (Throwable)e);
                }
                try {
                    return governanceArtifact.getLifecycleState(lifecycleName);
                }
                catch (GovernanceException e) {
                    throw new GovernanceException("Error while current lifecycle state of lifecycle" + lifecycleName, (Throwable)e);
                }
            }
            catch (RegistryException e) {
                throw new GovernanceException("Error while getting " + registryPathToResource + " from registry.", (Throwable)e);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Lifecycle " + lifecycleName + "current state" + currentLifecycleState));
        }
        return currentLifecycleState;
    }

    public static List getDurationBeans(String lifecycleName, String lifecycleState) throws GovernanceException {
        if (StringUtils.isEmpty((String)lifecycleName) || StringUtils.isEmpty((String)lifecycleState)) {
            throw new IllegalArgumentException("Invalid supplied for lifecycle name: " + lifecycleName + "state: " + lifecycleState);
        }
        List durationBeans = null;
        OMElement lifecycleConfigurationElement = LifecycleStateDurationUtils.getLifecycleConfigurationElement(lifecycleName);
        if (lifecycleConfigurationElement != null) {
            String xpathString = "/aspect/configuration/lifecycle/*[name()='scxml']/*[name()='state'][@id='" + lifecycleState + "']" + "/*[name()='checkpoints']/*[name()='checkpoint']";
            durationBeans = CommonUtil.evaluateXpath(lifecycleConfigurationElement, xpathString, null);
        }
        return durationBeans;
    }

    private static OMElement getLifecycleConfigurationElement(String lifecycleName) throws GovernanceException {
        String lifecycleConfiguration;
        Registry systemRegistry = (Registry)PrivilegedCarbonContext.getThreadLocalCarbonContext().getRegistry(RegistryType.SYSTEM_CONFIGURATION);
        try {
            lifecycleConfiguration = CommonUtil.getLifecycleConfiguration(lifecycleName, systemRegistry);
        }
        catch (RegistryException e) {
            throw new GovernanceException("Registry error while getting lifecycle configurations of '" + lifecycleName + "' lifecycle.", (Throwable)e);
        }
        catch (XMLStreamException e) {
            throw new GovernanceException("XML stream error while getting lifecycle configurations of '" + lifecycleName + "' lifecycle.", (Throwable)e);
        }
        try {
            if (lifecycleConfiguration != null && StringUtils.isNotEmpty((String)lifecycleConfiguration)) {
                return CommonUtil.buildOMElement(lifecycleConfiguration);
            }
            throw new GovernanceException("Can not get lifecycle configurations of '" + lifecycleName + "' lifecycle.");
        }
        catch (RegistryException e) {
            throw new GovernanceException("Error while building OM element to lifecycle configurations of '" + lifecycleName + "' lifecycle.", (Throwable)e);
        }
    }

    public static String getCurrentTime() {
        Date currentTimeStamp = new Date();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        return dateFormat.format(currentTimeStamp);
    }

    private static OMElement getHistoryFileDocumentElement(String textContent) throws GovernanceException {
        ByteArrayInputStream byteArrayInputStream = null;
        try {
            byteArrayInputStream = new ByteArrayInputStream(textContent.getBytes());
            OMElement oMElement = new StAXOMBuilder((InputStream)byteArrayInputStream).getDocumentElement();
            return oMElement;
        }
        catch (XMLStreamException e) {
            throw new GovernanceException("Error while creating history file document element from " + textContent, (Throwable)e);
        }
        finally {
            if (byteArrayInputStream != null) {
                try {
                    byteArrayInputStream.close();
                }
                catch (IOException e) {
                    throw new GovernanceException("Error while closing byte array input for " + textContent, (Throwable)e);
                }
            }
        }
    }

    private static List getTransitionNodeList(AXIOMXPath targetStateXpath, OMElement documentElement, String historyResourcePath) throws GovernanceException {
        try {
            return targetStateXpath.selectNodes((Object)documentElement);
        }
        catch (JaxenException e) {
            throw new GovernanceException("Error while selecting nodes relevant to Xpath: //item[@targetState] from document element generated from " + historyResourcePath, (Throwable)e);
        }
    }

    private static OMElement getHistoryElement(String textContent, String lifecycleName, String historyResourcePath) throws GovernanceException {
        OMElement omElement;
        OMElement documentElement = LifecycleStateDurationUtils.getHistoryFileDocumentElement(textContent);
        String XpathString = "//item[@targetState][@aspect='" + lifecycleName + "']";
        AXIOMXPath targetStateXpath = LifecycleStateDurationUtils.getAxiomPath(XpathString);
        List transitionNodesList = LifecycleStateDurationUtils.getTransitionNodeList(targetStateXpath, documentElement, historyResourcePath);
        if (transitionNodesList != null && !transitionNodesList.isEmpty()) {
            omElement = (OMElement)transitionNodesList.get(0);
        } else {
            XpathString = "//item[@timestamp][@aspect='" + lifecycleName + "']";
            targetStateXpath = LifecycleStateDurationUtils.getAxiomPath(XpathString);
            transitionNodesList = LifecycleStateDurationUtils.getTransitionNodeList(targetStateXpath, documentElement, textContent);
            omElement = (OMElement)transitionNodesList.get(transitionNodesList.size() - 1);
        }
        return omElement;
    }
}

