/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.governance.lcm.util;

import java.io.CharArrayReader;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.util.AXIOMUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.scxml.io.SCXMLParser;
import org.wso2.carbon.governance.lcm.beans.ChecklistBean;
import org.wso2.carbon.governance.lcm.beans.JSBean;
import org.wso2.carbon.governance.lcm.beans.LifecycleBean;
import org.wso2.carbon.governance.lcm.beans.LifecycleStateBean;
import org.wso2.carbon.governance.lcm.beans.PermissionBean;
import org.wso2.carbon.governance.lcm.beans.ScriptBean;
import org.wso2.carbon.governance.lcm.beans.ScriptElementBean;
import org.wso2.carbon.governance.lcm.beans.ScriptFunctionBean;
import org.wso2.carbon.governance.lcm.util.CommonUtil;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.utils.RegistryUtils;
import org.xml.sax.InputSource;

public class LifecycleBeanPopulator {
    private static final Log log = LogFactory.getLog(LifecycleBeanPopulator.class);

    public static String serializeLifecycleBean(LifecycleBean bean) throws XMLStreamException {
        LifecycleStateBean[] states;
        OMFactory factory = OMAbstractFactory.getOMFactory();
        OMElement aspect = factory.createOMElement("aspect", null);
        aspect.addAttribute(factory.createOMAttribute("name", null, bean.getName()));
        aspect.addAttribute(factory.createOMAttribute("class", null, bean.getReflectionClassName()));
        OMElement configuration = factory.createOMElement("configuration", null);
        configuration.addAttribute(factory.createOMAttribute("type", null, "literal"));
        OMElement lifecycle = factory.createOMElement("lifecycle", null);
        for (LifecycleStateBean lifecycleState : states = bean.getStates()) {
            String extensionsXmlString;
            JSBean js;
            PermissionBean[] permissionBeans;
            ChecklistBean checklistBean;
            OMElement state = factory.createOMElement("state", null);
            state.addAttribute(factory.createOMAttribute("name", null, lifecycleState.getStateName()));
            if (lifecycleState.getLocation() != null) {
                state.addAttribute(factory.createOMAttribute("location", null, lifecycleState.getLocation()));
            }
            if ((checklistBean = lifecycleState.getChecklist()) != null) {
                String[] items;
                for (String item : items = checklistBean.getItems()) {
                    OMElement itemElement = factory.createOMElement("checkitem", null);
                    itemElement.setText(item);
                    state.addChild((OMNode)itemElement);
                }
            }
            if ((permissionBeans = lifecycleState.getPermissions()) != null && permissionBeans.length > 0) {
                OMElement permissionsElement = factory.createOMElement("permissions", null);
                for (PermissionBean permissionBean : permissionBeans) {
                    OMElement permissionElement = factory.createOMElement("permission", null);
                    permissionElement.addAttribute(factory.createOMAttribute("action", null, permissionBean.getAction()));
                    permissionsElement.addChild((OMNode)permissionElement);
                }
                state.addChild((OMNode)permissionsElement);
            }
            if ((js = lifecycleState.getJs()) != null) {
                OMElement jsElement = factory.createOMElement("js", null);
                ScriptBean consoleScriptBean = js.getConsoleScript();
                ScriptFunctionBean[] consoleScriptFunctionBeans = js.getConsoleFunctions();
                if (consoleScriptBean != null) {
                    OMElement consoleElement = factory.createOMElement("console", null);
                    ScriptElementBean[] scripts = consoleScriptBean.getScripts();
                    if (scripts != null && scripts.length > 0) {
                        for (ScriptElementBean script : scripts) {
                            OMElement scriptElement = factory.createOMElement("script", null);
                            if (script.getSrc() != null) {
                                scriptElement.addAttribute(factory.createOMAttribute("src", null, script.getSrc()));
                            }
                            scriptElement.addAttribute(factory.createOMAttribute("type", null, "text/javascript"));
                            scriptElement.setText(script.getContent());
                            consoleElement.addChild((OMNode)scriptElement);
                        }
                    }
                    if (consoleScriptFunctionBeans != null && consoleScriptFunctionBeans.length > 0) {
                        for (ScriptFunctionBean consoleScriptFunctionBean : consoleScriptFunctionBeans) {
                            consoleElement.addAttribute(factory.createOMAttribute(consoleScriptFunctionBean.getName(), null, consoleScriptFunctionBean.getValue()));
                        }
                    }
                    jsElement.addChild((OMNode)consoleElement);
                }
                ScriptBean serverScriptBean = js.getServerScript();
                ScriptFunctionBean[] serverScriptFunctionBeans = js.getServerFunctions();
                if (serverScriptBean != null) {
                    OMElement serverElement = factory.createOMElement("server", null);
                    ScriptElementBean[] scripts = serverScriptBean.getScripts();
                    if (scripts != null && scripts.length > 0) {
                        for (ScriptElementBean script : scripts) {
                            OMElement scriptElement = factory.createOMElement("script", null);
                            if (script.getSrc() != null) {
                                scriptElement.addAttribute(factory.createOMAttribute("src", null, script.getSrc()));
                            }
                            scriptElement.addAttribute(factory.createOMAttribute("type", null, "text/javascript"));
                            scriptElement.setText(script.getContent());
                            serverElement.addChild((OMNode)scriptElement);
                        }
                    }
                    if (serverScriptFunctionBeans != null && serverScriptFunctionBeans.length > 0) {
                        for (ScriptFunctionBean serverScriptFunctionBean : serverScriptFunctionBeans) {
                            serverElement.addAttribute(factory.createOMAttribute(serverScriptFunctionBean.getName(), null, serverScriptFunctionBean.getValue()));
                        }
                    }
                    jsElement.addChild((OMNode)serverElement);
                }
                state.addChild((OMNode)jsElement);
            }
            if ((extensionsXmlString = lifecycleState.getExtensionsXml()) != null && extensionsXmlString.length() > 0) {
                OMElement extensionsElement = factory.createOMElement("extensions", null);
                OMElement dummyElement = AXIOMUtil.stringToOM((String)("<dummy>" + extensionsXmlString + "</dummy>"));
                Iterator dummyElementItr = dummyElement.getChildElements();
                while (dummyElementItr.hasNext()) {
                    OMElement elem = (OMElement)dummyElementItr.next();
                    if (elem == null) continue;
                    extensionsElement.addChild((OMNode)elem);
                }
                state.addChild((OMNode)extensionsElement);
            }
            lifecycle.addChild((OMNode)state);
        }
        configuration.addChild((OMNode)lifecycle);
        aspect.addChild((OMNode)configuration);
        return aspect.toString();
    }

    public static boolean deserializeLifecycleBean(String configuration, Registry registry) throws Exception {
        OMElement configurationElement = CommonUtil.buildOMElement(configuration);
        return LifecycleBeanPopulator.deserializeLifecycleBean(configurationElement, registry);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean deserializeLifecycleBean(OMElement configurationElement, Registry registry) throws Exception {
        CommonUtil.validateOMContent(configurationElement, CommonUtil.getLifecycleSchemaValidator(CommonUtil.getLifecycleSchemaLocation()));
        try {
            OMElement scxmlElement = null;
            OMElement lifecycleElement = null;
            OMElement configuration = configurationElement.getFirstElement();
            String type = configuration.getAttributeValue(new QName("type"));
            if (type.equals("literal")) {
                lifecycleElement = configuration.getFirstElement();
            } else {
                if (!type.equals("resource")) {
                    String msg = "The type must be either literal or resource";
                    log.error((Object)msg);
                    throw new RegistryException(msg);
                }
                String resourcePath = configuration.getText();
                if (!registry.resourceExists(resourcePath)) {
                    String msg = "Resource not found at " + resourcePath;
                    log.error((Object)msg);
                    throw new RegistryException(msg);
                }
                Resource resource = registry.get(resourcePath);
                if (resource.getContent() == null) {
                    String msg = "Resource does not contain a valid lifecycle configuration";
                    log.error((Object)msg);
                    throw new RegistryException(msg);
                }
                if (resource.getContent() instanceof String) {
                    lifecycleElement = CommonUtil.buildOMElement((String)resource.getContent());
                } else {
                    if (!(resource.getContent() instanceof byte[])) {
                        String msg = "Could not find valid lifecycle configuration";
                        log.error((Object)msg);
                        throw new RegistryException(msg);
                    }
                    lifecycleElement = CommonUtil.buildOMElement(RegistryUtils.decodeBytes((byte[])((byte[])resource.getContent())));
                }
            }
            scxmlElement = lifecycleElement.getFirstElement();
            CommonUtil.validateOMContent(scxmlElement);
            CommonUtil.validateLifeCycle(scxmlElement);
            SCXMLParser.parse((InputSource)new InputSource(new CharArrayReader(scxmlElement.toString().toCharArray())), null);
            if (CommonUtil.validateSCXMLDataModel(scxmlElement)) return true;
            throw new RegistryException("Failed to validate the data model. Invalid forEvent found");
        }
        catch (RegistryException e) {
            throw e;
        }
        catch (Exception e) {
            String msg = e.getMessage() + ". Please check whether there are any whitespaces in state names";
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg);
        }
    }
}

