/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.governance.lcm.util;

import com.ctc.wstx.exc.WstxParsingException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMText;
import org.apache.axiom.om.xpath.AXIOMXPath;
import org.apache.axis2.util.XMLUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xerces.util.SecurityManager;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.wso2.carbon.governance.lcm.beans.LifecycleBean;
import org.wso2.carbon.governance.lcm.internal.LifeCycleServiceHolder;
import org.wso2.carbon.governance.lcm.util.LifecycleBeanPopulator;
import org.wso2.carbon.registry.common.AttributeSearchService;
import org.wso2.carbon.registry.common.ResourceData;
import org.wso2.carbon.registry.core.Aspect;
import org.wso2.carbon.registry.core.Collection;
import org.wso2.carbon.registry.core.CollectionImpl;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.ResourceImpl;
import org.wso2.carbon.registry.core.config.RegistryConfigurationProcessor;
import org.wso2.carbon.registry.core.config.RegistryContext;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.registry.core.utils.RegistryUtils;
import org.wso2.carbon.utils.CarbonUtils;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class CommonUtil {
    private static final Log log = LogFactory.getLog(CommonUtil.class);
    private static String contextRoot = null;
    private static final int ENTITY_EXPANSION_LIMIT = 0;
    public static final String searchLCMPropertiesQuery = "/repository/components/org.wso2.carbon.registry/queries/governance/searchLCMProperties";
    private static Validator lifecycleSchemaValidator = null;

    public static UserRegistry getRootSystemRegistry() throws RegistryException {
        if (LifeCycleServiceHolder.getInstance().getRegistryService() == null) {
            return null;
        }
        return LifeCycleServiceHolder.getInstance().getRegistryService().getRegistry("wso2.system.user");
    }

    public static UserRegistry getRootSystemRegistry(int tenantId) throws RegistryException {
        if (LifeCycleServiceHolder.getInstance().getRegistryService() == null) {
            return null;
        }
        return LifeCycleServiceHolder.getInstance().getRegistryService().getRegistry("wso2.system.user", tenantId);
    }

    public static boolean updateLifecycle(String oldName, LifecycleBean bean, Registry registry, Registry rootRegistry) throws RegistryException, XMLStreamException {
        String payload = LifecycleBeanPopulator.serializeLifecycleBean(bean);
        return CommonUtil.updateLifecycle(oldName, payload, registry, rootRegistry);
    }

    public static boolean updateLifecycle(String oldName, String payload, Registry registry, Registry rootRegistry) throws RegistryException, XMLStreamException {
        String newName = null;
        OMElement element = CommonUtil.buildOMElement(payload);
        CommonUtil.validateOMContent(element);
        if (element != null) {
            newName = element.getAttributeValue(new QName("name"));
        }
        if (newName == null || newName.equals("")) {
            return false;
        }
        if (oldName == null || oldName.equals("")) {
            String path = CommonUtil.getContextRoot() + newName;
            if (CommonUtil.lifeCycleExists(newName, registry)) {
                return false;
            }
            ResourceImpl resource = new ResourceImpl();
            resource.setContent((Object)payload);
            try {
                registry.beginTransaction();
                registry.put(path, (Resource)resource);
                CommonUtil.generateAspect(path, registry);
                registry.commitTransaction();
            }
            catch (Exception e) {
                registry.rollbackTransaction();
                String errorMsg = "Unable to update aspect. ";
                if (e.getCause() instanceof ClassNotFoundException) {
                    errorMsg = errorMsg + "Could not find class " + e.getCause().getMessage();
                } else if (e.getCause() instanceof WstxParsingException) {
                    errorMsg = errorMsg + e.getCause().getMessage();
                }
                throw new RegistryException(errorMsg, (Throwable)e);
            }
            return true;
        }
        if (newName.equals(oldName)) {
            String oldPath = CommonUtil.getContextRoot() + oldName;
            Object resource = CommonUtil.lifeCycleExists(oldName, registry) ? registry.get(oldPath) : new ResourceImpl();
            resource.setContent((Object)payload);
            try {
                registry.beginTransaction();
                registry.put(oldPath, resource);
                CommonUtil.generateAspect(oldPath, registry);
                registry.commitTransaction();
            }
            catch (Exception e) {
                registry.rollbackTransaction();
                String errorMsg = "Unable to update aspect. ";
                if (e.getCause() instanceof ClassNotFoundException) {
                    errorMsg = errorMsg + "Could not find class " + e.getCause().getMessage();
                } else if (e.getCause() instanceof WstxParsingException) {
                    errorMsg = errorMsg + e.getCause().getMessage();
                }
                throw new RegistryException(errorMsg, (Throwable)e);
            }
            return true;
        }
        String oldPath = CommonUtil.getContextRoot() + oldName;
        String newPath = CommonUtil.getContextRoot() + newName;
        if (CommonUtil.lifeCycleExists(newName, registry)) {
            return false;
        }
        Object resource = CommonUtil.lifeCycleExists(oldName, registry) ? registry.get(oldPath) : new ResourceImpl();
        resource.setContent((Object)payload);
        try {
            registry.beginTransaction();
            registry.put(newPath, resource);
            CommonUtil.generateAspect(newPath, registry);
            registry.delete(oldPath);
            CommonUtil.removeAspect(oldName, registry);
            registry.commitTransaction();
        }
        catch (Exception e) {
            registry.rollbackTransaction();
            throw new RegistryException("Unable to renew aspect", (Throwable)e);
        }
        return true;
    }

    public static boolean createLifecycle(String configuration, Registry registry, Registry rootRegistry) throws RegistryException, XMLStreamException {
        return CommonUtil.addLifecycle(configuration, registry, rootRegistry);
    }

    public static boolean addLifecycle(String payload, Registry registry, Registry rootRegistry) throws RegistryException, XMLStreamException {
        OMElement element = null;
        element = CommonUtil.buildOMElement(payload);
        CommonUtil.validateOMContent(element);
        String name = element.getAttributeValue(new QName("name"));
        if (CommonUtil.isLifecycleNameInUse(name, registry, rootRegistry)) {
            String msg = String.format("The lifecycle name %s is already in use", name);
            throw new RegistryException(msg);
        }
        String path = CommonUtil.getContextRoot() + name;
        if (CommonUtil.lifeCycleExists(name, registry)) {
            return false;
        }
        ResourceImpl resource = new ResourceImpl();
        resource.setContent((Object)payload);
        try {
            registry.beginTransaction();
            registry.put(path, (Resource)resource);
            CommonUtil.generateAspect(path, registry);
            registry.commitTransaction();
        }
        catch (Exception e) {
            registry.rollbackTransaction();
            String errorMsg = "Unable to initiate aspect. ";
            if (e.getCause() instanceof ClassNotFoundException) {
                errorMsg = errorMsg + "Could not find class " + e.getCause().getMessage();
            } else if (e.getCause() instanceof WstxParsingException) {
                errorMsg = errorMsg + e.getCause().getMessage();
            }
            throw new RegistryException(errorMsg.replaceAll("<", "&lt;").replaceAll(">", "&gt;"), (Throwable)e);
        }
        return true;
    }

    public static void validateOMContent(OMElement element) throws RegistryException {
        if (!CommonUtil.validateOMContent(element, CommonUtil.getLifecycleSchemaValidator(CommonUtil.getLifecycleSchemaLocation()))) {
            String message = "Unable to validate the lifecycle configuration";
            log.error((Object)message);
            throw new RegistryException(message);
        }
    }

    public static OMElement buildOMElement(String payload) throws RegistryException {
        OMElement element = CommonUtil.getOMElementFromString(payload);
        element.build();
        return element;
    }

    public static boolean lifeCycleExists(String name, Registry registry) throws RegistryException {
        return registry.resourceExists(CommonUtil.getContextRoot() + name);
    }

    public static boolean deleteLifecycle(String name, Registry registry, Registry rootRegistry) throws RegistryException, XMLStreamException {
        if (CommonUtil.isLifecycleNameInUse(name, registry, rootRegistry)) {
            throw new RegistryException("Lifecycle could not be deleted, since it is already in use!");
        }
        String path = CommonUtil.getContextRoot() + name;
        if (registry.resourceExists(path)) {
            try {
                registry.beginTransaction();
                registry.delete(path);
                CommonUtil.removeAspect(name, registry);
                registry.commitTransaction();
            }
            catch (Exception e) {
                registry.rollbackTransaction();
                throw new RegistryException("Unable to remove aspect", (Throwable)e);
            }
            return true;
        }
        return false;
    }

    public static String getLifecycleConfiguration(String name, Registry registry) throws RegistryException, XMLStreamException {
        String path = CommonUtil.getContextRoot() + name;
        if (CommonUtil.lifeCycleExists(name, registry)) {
            Resource resource = registry.get(path);
            return RegistryUtils.decodeBytes((byte[])((byte[])resource.getContent()));
        }
        return null;
    }

    public static String getLifecycleConfigurationVersion(String name, Registry registry) throws RegistryException, XMLStreamException {
        String path = CommonUtil.getContextRoot() + name;
        if (CommonUtil.lifeCycleExists(name, registry)) {
            Resource resource = registry.get(path);
            return String.valueOf(((ResourceImpl)resource).getVersionNumber());
        }
        return null;
    }

    public static boolean generateAspect(String resourceFullPath, Registry registry) throws RegistryException {
        RegistryContext registryContext = registry.getRegistryContext();
        if (registryContext == null) {
            return false;
        }
        Resource resource = registry.get(resourceFullPath);
        if (resource != null) {
            OMElement aspect;
            String content = null;
            if (resource.getContent() != null) {
                content = RegistryUtils.decodeBytes((byte[])((byte[])resource.getContent()));
            }
            if (content != null && (aspect = CommonUtil.getOMElementFromString(content)) != null) {
                OMElement dummy = OMAbstractFactory.getOMFactory().createOMElement("dummy", null);
                dummy.addChild((OMNode)aspect);
                Aspect aspectinstance = RegistryConfigurationProcessor.updateAspects((OMElement)dummy);
                Iterator aspectElement = dummy.getChildrenWithName(new QName("aspect"));
                String name = "";
                if (aspectElement != null) {
                    OMElement aspectelement = (OMElement)aspectElement.next();
                    name = aspectelement.getAttributeValue(new QName("name"));
                }
                registry.addAspect(name, aspectinstance);
                return true;
            }
        }
        return false;
    }

    public static OMElement getOMElementFromString(String payload) throws RegistryException {
        try {
            DocumentBuilderFactory dbf = CommonUtil.getSecuredDocumentBuilder();
            DocumentBuilder builder = dbf.newDocumentBuilder();
            Document document = builder.parse(new InputSource(new StringReader(payload)));
            return XMLUtils.toOM((Element)document.getDocumentElement());
        }
        catch (Exception e) {
            String message = "Unable to parse the XML configuration. Please validate the XML configuration";
            log.error((Object)message, (Throwable)e);
            throw new RegistryException(message, (Throwable)e);
        }
    }

    public static boolean removeAspect(String aspectname, Registry registry) throws RegistryException {
        return registry.removeAspect(aspectname);
    }

    public static String[] getLifecycleList(Registry registry) throws RegistryException {
        Collection collection;
        try {
            collection = (Collection)registry.get(CommonUtil.getContextRoot());
        }
        catch (Exception e) {
            return null;
        }
        if (collection == null) {
            CollectionImpl lifeCycleCollection = new CollectionImpl();
            registry.put(CommonUtil.getContextRoot(), (Resource)lifeCycleCollection);
            return null;
        }
        if (collection.getChildCount() == 0) {
            return null;
        }
        String[] childrenList = collection.getChildren();
        String[] lifeCycleNameList = new String[collection.getChildCount()];
        for (int i = 0; i < childrenList.length; ++i) {
            String path = childrenList[i];
            lifeCycleNameList[i] = path.substring(path.lastIndexOf("/") + 1);
        }
        return lifeCycleNameList;
    }

    public static String getContextRoot() {
        if (contextRoot == null) {
            return "/repository/components/org.wso2.carbon.governance/lifecycles/";
        }
        return contextRoot;
    }

    public static void setContextRoot(String contextRoot) {
        if (!contextRoot.endsWith("/")) {
            contextRoot = contextRoot + "/";
        }
        CommonUtil.contextRoot = contextRoot;
    }

    public static boolean addDefaultLifecyclesIfNotAvailable(Registry registry, Registry rootRegistry) throws RegistryException, FileNotFoundException, XMLStreamException {
        block14: {
            block13: {
                if (registry.resourceExists("/repository/components/org.wso2.carbon.governance/lifecycles/")) break block13;
                CollectionImpl lifeCycleConfigurationCollection = new CollectionImpl();
                registry.put("/repository/components/org.wso2.carbon.governance/lifecycles/", (Resource)lifeCycleConfigurationCollection);
                String defaultLifecycleConfigLocation = CommonUtil.getDefaltLifecycleConfigLocation();
                File defaultLifecycleConfigDirectory = new File(defaultLifecycleConfigLocation);
                if (!defaultLifecycleConfigDirectory.exists()) {
                    return false;
                }
                FilenameFilter filenameFilter = new FilenameFilter(){

                    @Override
                    public boolean accept(File file, String name) {
                        return name.endsWith(".xml");
                    }
                };
                File[] lifecycleConfigFiles = defaultLifecycleConfigDirectory.listFiles(filenameFilter);
                if (lifecycleConfigFiles != null && lifecycleConfigFiles.length == 0) {
                    return false;
                }
                for (File lifecycleConfigFile : lifecycleConfigFiles) {
                    String msg;
                    String fileName = FilenameUtils.removeExtension((String)lifecycleConfigFile.getName());
                    String resourcePath = "/repository/components/org.wso2.carbon.governance/lifecycles/" + fileName;
                    String fileContent = null;
                    if (!registry.resourceExists(resourcePath)) {
                        try {
                            fileContent = FileUtils.readFileToString((File)lifecycleConfigFile);
                        }
                        catch (IOException e) {
                            msg = String.format("Error while reading lifecycle config file %s ", fileName);
                            log.error((Object)msg, (Throwable)e);
                        }
                        if (fileContent == null || fileContent.isEmpty()) continue;
                        try {
                            OMElement omElement = CommonUtil.buildOMElement(fileContent);
                            String aspectName = omElement.getAttributeValue(new QName("name"));
                            if (fileName.equalsIgnoreCase(aspectName)) {
                                CommonUtil.addLifecycle(fileContent, registry, rootRegistry);
                                continue;
                            }
                            String msg2 = String.format("Configuration file name %s not matched with aspect name %s ", fileName, aspectName);
                            log.error((Object)msg2);
                        }
                        catch (RegistryException e) {
                            msg = String.format("Error while adding aspect %s ", fileName);
                            log.error((Object)msg, (Throwable)e);
                        }
                        continue;
                    }
                    try {
                        CommonUtil.generateAspect(resourcePath, registry);
                    }
                    catch (Exception e) {
                        msg = String.format("Error while generating aspect %s ", fileName);
                        log.error((Object)msg, (Throwable)e);
                    }
                }
                break block14;
            }
            Resource lifecycleRoot = registry.get(CommonUtil.getContextRoot());
            if (!(lifecycleRoot instanceof Collection)) {
                String msg = "Failed to continue as the lifecycle configuration root: " + CommonUtil.getContextRoot() + " is not a collection.";
                log.error((Object)msg);
                throw new RegistryException(msg);
            }
            Collection lifecycleRootCol = (Collection)lifecycleRoot;
            String[] lifecycleConfigPaths = lifecycleRootCol.getChildren();
            if (lifecycleConfigPaths == null) break block14;
            for (String lifecycleConfigPath : lifecycleConfigPaths) {
                CommonUtil.generateAspect(lifecycleConfigPath, registry);
            }
        }
        return true;
    }

    public static String getDefaltLifecycleConfigLocation() {
        return System.getProperty("carbon.home") + File.separator + "repository" + File.separator + "resources" + File.separator + "lifecycles";
    }

    public static boolean isLifecycleNameInUse(String name, Registry registry, Registry rootRegistry) throws RegistryException {
        if (name.contains("<aspect")) {
            OMElement element = CommonUtil.getOMElementFromString(name);
            if (element != null) {
                name = element.getAttributeValue(new QName("name"));
                boolean aspectFound = false;
                String[] aspects = registry.getAvailableAspects();
                if (aspects != null) {
                    for (String aspect : aspects) {
                        if (!name.equals(aspect)) continue;
                        return true;
                    }
                }
                return false;
            }
            throw new RegistryException("Lifecycle Configuration does not contain the name attribute");
        }
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("propertyName", "registry.Aspects");
        parameters.put("rightPropertyValue", name);
        parameters.put("rightOp", "eq");
        AttributeSearchService searchService = LifeCycleServiceHolder.getInstance().getAttributeSearchService();
        if (searchService != null) {
            ResourceData[] resourceData = (ResourceData[])searchService.search(parameters);
            return resourceData.length != 0;
        }
        return false;
    }

    public static DocumentBuilderFactory getSecuredDocumentBuilder() {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        dbf.setXIncludeAware(false);
        dbf.setExpandEntityReferences(false);
        try {
            dbf.setFeature("http://xml.org/sax/features/external-general-entities", false);
            dbf.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            dbf.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        }
        catch (ParserConfigurationException e) {
            log.error((Object)"Failed to load XML Processor Feature external-general-entities or external-parameter-entities or nonvalidating/load-external-dtd");
        }
        SecurityManager securityManager = new SecurityManager();
        securityManager.setEntityExpansionLimit(0);
        dbf.setAttribute("http://apache.org/xml/properties/security-manager", securityManager);
        return dbf;
    }

    public static boolean validateOMContent(OMElement omContent, Validator validator) {
        try {
            ByteArrayInputStream is = new ByteArrayInputStream(omContent.toString().getBytes("utf-8"));
            StreamSource xmlFile = new StreamSource(is);
            if (validator != null) {
                validator.validate(xmlFile);
            }
        }
        catch (SAXException e) {
            log.error((Object)"Unable to parse the XML configuration. Please validate the XML configuration", (Throwable)e);
            return false;
        }
        catch (UnsupportedEncodingException e) {
            log.error((Object)"Unsupported content", (Throwable)e);
            return false;
        }
        catch (IOException e) {
            log.error((Object)"Unable to parse the XML configuration. Please validate the XML configuration", (Throwable)e);
            return false;
        }
        return true;
    }

    public static Validator getLifecycleSchemaValidator(String schemaPath) {
        if (lifecycleSchemaValidator == null) {
            try {
                SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
                Schema schema = schemaFactory.newSchema(new File(schemaPath));
                lifecycleSchemaValidator = schema.newValidator();
            }
            catch (SAXException e) {
                log.error((Object)("Unable to get a schema validator from the given file path : " + schemaPath));
            }
        }
        return lifecycleSchemaValidator;
    }

    public static String getLifecycleSchemaLocation() {
        return CarbonUtils.getCarbonHome() + File.separator + "repository" + File.separator + "resources" + File.separator + "lifecycle-config.xsd";
    }

    public static boolean validateSCXMLDataModel(OMElement content) {
        String stateXpath = "//x:state";
        String forEventXpath = "//@forEvent";
        String transitionXpath = "//x:transition";
        List stateList = CommonUtil.evaluateXpath(content, stateXpath, "x");
        if (stateList != null) {
            for (Object stateObject : stateList) {
                List allForEvents;
                OMElement state = ((OMElement)stateObject).cloneOMElement();
                ArrayList<String> stateForEvents = new ArrayList<String>();
                List transitions = CommonUtil.evaluateXpath(state, transitionXpath, "x");
                if (transitions != null) {
                    for (Object transition : transitions) {
                        OMElement transitionElement = (OMElement)transition;
                        stateForEvents.add(transitionElement.getAttributeValue(new QName("event")));
                    }
                }
                if ((allForEvents = CommonUtil.evaluateXpath(state, forEventXpath, null)) == null) continue;
                for (Object forEvent : allForEvents) {
                    String[] forEvents;
                    OMAttribute forEventElement = (OMAttribute)forEvent;
                    if (forEventElement.getAttributeValue().equals("")) continue;
                    for (String event : forEvents = forEventElement.getAttributeValue().split(",")) {
                        if (stateForEvents.contains(event)) continue;
                        return false;
                    }
                }
            }
        }
        return true;
    }

    public static List evaluateXpath(OMElement contentElement, String xpathString, String nsPrefix) {
        ArrayList ret = new ArrayList();
        try {
            AXIOMXPath xpath = new AXIOMXPath(xpathString);
            Iterator nsIterator = contentElement.getAllDeclaredNamespaces();
            if (nsIterator.hasNext()) {
                while (nsIterator.hasNext()) {
                    OMNamespace next = (OMNamespace)nsIterator.next();
                    xpath.addNamespace(nsPrefix, next.getNamespaceURI());
                    ret.addAll(xpath.selectNodes((Object)contentElement));
                }
            } else if (contentElement.getDefaultNamespace() != null) {
                xpath.addNamespace(nsPrefix, contentElement.getDefaultNamespace().getNamespaceURI());
                ret.addAll(xpath.selectNodes((Object)contentElement));
            } else if (nsPrefix != null) {
                xpathString = xpathString.replace(nsPrefix + ":", "");
                xpath = new AXIOMXPath(xpathString);
                ret.addAll(xpath.selectNodes((Object)contentElement));
            } else {
                xpath = new AXIOMXPath(xpathString);
                ret.addAll(xpath.selectNodes((Object)contentElement));
            }
            return ret;
        }
        catch (Exception e) {
            log.error((Object)e);
            return null;
        }
    }

    public static void validateLifeCycle(OMElement element) throws RegistryException {
        String stateXpath = "//x:state";
        String checkItems = "//x:data[@name='checkItems']";
        String transitionValidation = "//x:data[@name='transitionValidation']";
        String transitionPermission = "//x:data[@name='transitionPermission']";
        String transitionScripts = "//x:data[@name='transitionScripts']";
        String transitionExecution = "//x:data[@name='transitionExecution']";
        String transitionUI = "//x:data[@name='transitionUI']";
        String transitionApproval = "//x:data[@name='transitionApproval']";
        List stateList = CommonUtil.evaluateXpath(element, stateXpath, "x");
        if (stateList != null) {
            for (Object stateObject : stateList) {
                OMElement state = ((OMElement)stateObject).cloneOMElement();
                CommonUtil.validateElements(state, checkItems, "item");
                CommonUtil.validateElements(state, transitionValidation, "validation");
                CommonUtil.validateElements(state, transitionPermission, "permission");
                CommonUtil.validateElements(state, transitionScripts, "js");
                CommonUtil.validateElements(state, transitionExecution, "execution");
                CommonUtil.validateElements(state, transitionUI, "ui");
                CommonUtil.validateElements(state, transitionApproval, "approval");
            }
        }
    }

    private static void validateElements(OMElement element, String xpath, String childElement) throws RegistryException {
        List elements = CommonUtil.evaluateXpath(element, xpath, "x");
        if (elements != null) {
            for (Object object : elements) {
                OMElement cloneElement = ((OMElement)object).cloneOMElement();
                Iterator children = cloneElement.getChildElements();
                while (children.hasNext()) {
                    String elementName = "";
                    Object node = children.next();
                    if (node instanceof OMText) {
                        elementName = ((OMText)node).getText();
                    } else if (node instanceof OMElement) {
                        elementName = ((OMElement)node).getLocalName();
                    }
                    if (elementName.equals(childElement)) continue;
                    String message = "Unable to validate the lifecycle configuration";
                    log.error((Object)message);
                    throw new RegistryException(message);
                }
            }
        }
    }
}

