/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.governance.lcm.tasks;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.governance.api.exception.GovernanceException;
import org.wso2.carbon.governance.lcm.internal.LifeCycleServiceHolder;
import org.wso2.carbon.governance.lcm.tasks.LCNotification;
import org.wso2.carbon.governance.lcm.tasks.events.LifecycleNotificationEvent;
import org.wso2.carbon.governance.lcm.util.CommonUtil;
import org.wso2.carbon.governance.lcm.util.LifecycleStateDurationUtils;
import org.wso2.carbon.registry.common.AttributeSearchService;
import org.wso2.carbon.registry.common.ResourceData;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.ResourceImpl;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.eventing.services.EventingServiceImpl;

public class LCNotificationScheduler {
    private static final Log log = LogFactory.getLog(LCNotificationScheduler.class);
    private final long durationOfADay = 86400000L;
    private final String checkpointId = "id";
    private final String dateSeparator = "-";
    private final int dateLength = 10;
    private final String dateFormat = "yyyy-M-d";
    private final String lcCheckPointPropertyName = "registry.LCCheckpoints";
    private final String superAdminUsername = "admin";
    private final String superTenantDomain = "carbon.super";
    private final int superTenantId = -1234;
    private final String equals = "eq";
    private final String notApplicable = "na";

    public void run() {
        try {
            ArrayList<LCNotification> notifications = this.getValidNotifications();
            if (notifications.size() > 0) {
                for (LCNotification schedulerBean : notifications) {
                    String notificationMessage = this.getNotificationMessage(schedulerBean);
                    LifecycleNotificationEvent<String> notificationEvent = new LifecycleNotificationEvent<String>(notificationMessage);
                    notificationEvent.setTenantId(-1234);
                    notificationEvent.setResourcePath(schedulerBean.getRegPath());
                    EventingServiceImpl notificationService = new EventingServiceImpl();
                    try {
                        notificationService.notify(notificationEvent);
                        if (!log.isDebugEnabled()) continue;
                        log.debug((Object)("Notification '" + notificationMessage + "' sent to notification service."));
                    }
                    catch (Exception e) {
                        log.error((Object)"Error getting registry while getting scheduler objects to send notifications", (Throwable)e);
                    }
                }
            }
        }
        catch (RegistryException e) {
            log.error((Object)("Error while getting valid notifications on " + this.getCurrentDate()), (Throwable)e);
        }
    }

    public void addScheduler(ResourceImpl resource, String lifecycleName, String lifecycleState, boolean isInvokeAspect) throws GovernanceException {
        if (resource != null && StringUtils.isNotEmpty((String)lifecycleName) && StringUtils.isNotEmpty((String)lifecycleState)) {
            List checkpointsList = LifecycleStateDurationUtils.getDurationBeans(lifecycleName, lifecycleState);
            if (checkpointsList != null) {
                for (Object checkpoint : checkpointsList) {
                    OMElement checkpointElement = (OMElement)checkpoint;
                    OMElement boundary = checkpointElement.getFirstChildWithName(new QName("http://www.w3.org/2005/07/scxml", "boundary"));
                    String minTimestamp = boundary.getAttribute(new QName("min")).getAttributeValue();
                    String maxTimestamp = boundary.getAttribute(new QName("max")).getAttributeValue();
                    long durationDifference = this.getDurationDifference(minTimestamp, maxTimestamp);
                    String propertyValue = lifecycleName + "." + checkpointElement.getAttribute(new QName("id")).getAttributeValue() + "." + this.getNotificationDate(durationDifference);
                    resource.addProperty("registry.LCCheckpoints", propertyValue);
                    if (!isInvokeAspect) continue;
                    try {
                        CommonUtil.getRootSystemRegistry().put(resource.getPath(), (Resource)resource);
                    }
                    catch (RegistryException e) {
                        throw new GovernanceException("Error while saving resource when lifecycle is invoked after adding property '" + propertyValue + "' to " + resource.getPath(), (Throwable)e);
                    }
                }
            } else if (log.isDebugEnabled()) {
                log.debug((Object)("Invalid arguments supplied as lifecycle name: " + lifecycleName + ", lifecycle state: " + lifecycleState));
            }
        }
    }

    private long getDurationDifference(String timeStampOne, String timeStampTwo) {
        return LifecycleStateDurationUtils.getMillySecondsByDuration(timeStampTwo) - LifecycleStateDurationUtils.getMillySecondsByDuration(timeStampOne);
    }

    private String getNotificationDate(long durationDifference) {
        long currentTimeInMillySeconds = Calendar.getInstance().getTimeInMillis();
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(durationDifference + currentTimeInMillySeconds - 86400000L);
        int mYear = calendar.get(1);
        int mMonth = calendar.get(2);
        int mDay = calendar.get(5);
        StringBuilder dateBuilder = new StringBuilder(10);
        dateBuilder.append(mYear);
        dateBuilder.append("-");
        dateBuilder.append(mMonth + 1);
        dateBuilder.append("-");
        dateBuilder.append(mDay);
        return dateBuilder.toString();
    }

    private String getNotificationMessage(LCNotification schedulerBean) {
        String[] pathParams = schedulerBean.getRegPath().split("/");
        String resourceName = pathParams[pathParams.length - 1];
        StringBuilder stringBuilder = new StringBuilder("Resource '").append(resourceName).append("'s lifecycle '").append(schedulerBean.getLcName()).append("' is reaching lifecycle checkpoint '").append(schedulerBean.getLcCheckpointId()).append("' on ").append(schedulerBean.getNotificationDate()).append(".");
        return stringBuilder.toString();
    }

    private String getCurrentDate() {
        SimpleDateFormat dateFormat = new SimpleDateFormat(this.dateFormat);
        Calendar cal = Calendar.getInstance();
        return dateFormat.format(cal.getTime());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<LCNotification> getValidNotifications() throws RegistryException {
        ArrayList<LCNotification> notifications = new ArrayList<LCNotification>();
        AttributeSearchService attributeSearchService = LifeCycleServiceHolder.getInstance().getAttributeSearchService();
        HashMap<String, String> searchAttributes = new HashMap<String, String>();
        searchAttributes.put("propertyName", "registry.LCCheckpoints");
        searchAttributes.put("rightPropertyValue", "%" + this.getCurrentDate().replaceAll("-", "\\\\-"));
        searchAttributes.put("rightOp", "eq");
        searchAttributes.put("leftOp", "na");
        ResourceData[] resourceDataList = null;
        try {
            PrivilegedCarbonContext.startTenantFlow();
            PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantDomain("carbon.super");
            PrivilegedCarbonContext.getThreadLocalCarbonContext().setUsername("admin");
            PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantId(-1234);
            resourceDataList = (ResourceData[])attributeSearchService.search(CommonUtil.getRootSystemRegistry(), searchAttributes);
        }
        finally {
            PrivilegedCarbonContext.endTenantFlow();
        }
        if (resourceDataList != null) {
            for (ResourceData resourceData : resourceDataList) {
                LCNotification lcNotification = new LCNotification();
                ArrayList propValues = this.getLcNotificationProperties(resourceData);
                if (propValues.size() > 0) {
                    for (Object propValueObject : propValues) {
                        String propValue = (String)propValueObject;
                        String[] lcCheckpointValues = propValue.split("\\.");
                        lcNotification.setLcName(lcCheckpointValues[0]);
                        lcNotification.setLcCheckpointId(lcCheckpointValues[1]);
                        lcNotification.setNotificationDate(lcCheckpointValues[2]);
                        lcNotification.setRegPath(resourceData.getResourcePath());
                    }
                }
                notifications.add(lcNotification);
            }
        }
        return notifications;
    }

    private ArrayList getLcNotificationProperties(ResourceData resourceData) throws RegistryException {
        Properties propertyNameValues = CommonUtil.getRootSystemRegistry().get(resourceData.getResourcePath()).getProperties();
        Iterator<Map.Entry<Object, Object>> propIterator = propertyNameValues.entrySet().iterator();
        ArrayList propValues = new ArrayList();
        while (propIterator.hasNext()) {
            Map.Entry<Object, Object> entry = propIterator.next();
            String propertyName = (String)entry.getKey();
            if (!"registry.LCCheckpoints".equals(propertyName)) continue;
            propValues = (ArrayList)entry.getValue();
        }
        return propValues;
    }
}

