/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.governance.lcm.services;

import org.wso2.carbon.governance.api.exception.GovernanceException;
import org.wso2.carbon.governance.lcm.beans.DurationBean;
import org.wso2.carbon.governance.lcm.beans.LifecycleBean;
import org.wso2.carbon.governance.lcm.util.CommonUtil;
import org.wso2.carbon.governance.lcm.util.LifecycleBeanPopulator;
import org.wso2.carbon.governance.lcm.util.LifecycleStateDurationUtils;
import org.wso2.carbon.registry.admin.api.governance.ILifecycleManagementService;
import org.wso2.carbon.registry.common.services.RegistryAbstractAdmin;
import org.wso2.carbon.registry.core.utils.RegistryUtils;

public class LifeCycleManagementService
extends RegistryAbstractAdmin
implements ILifecycleManagementService {
    public String getLifecyclesCollectionLocation() throws Exception {
        return CommonUtil.getContextRoot();
    }

    public void setLifecyclesCollectionLocation(String location) throws Exception {
        CommonUtil.setContextRoot(location);
    }

    public String[] getLifecycleList() throws Exception {
        return CommonUtil.getLifecycleList(this.getConfigSystemRegistry());
    }

    public LifecycleBean getLifecycleBean(String name) throws Exception {
        throw new UnsupportedOperationException("This operation is no longer supported");
    }

    public String getLifecycleConfiguration(String name) throws Exception {
        return CommonUtil.getLifecycleConfiguration(name, this.getConfigSystemRegistry());
    }

    public boolean createLifecycle(String configuration) throws Exception {
        RegistryUtils.recordStatistics((Object[])new Object[]{configuration});
        return CommonUtil.createLifecycle(configuration, this.getConfigSystemRegistry(), this.getRootRegistry());
    }

    public boolean updateLifecycle(String oldName, String configuration) throws Exception {
        RegistryUtils.recordStatistics((Object[])new Object[]{oldName, configuration});
        return CommonUtil.updateLifecycle(oldName, configuration, this.getConfigSystemRegistry(), this.getRootRegistry());
    }

    public boolean deleteLifecycle(String name) throws Exception {
        RegistryUtils.recordStatistics((Object[])new Object[]{name});
        return CommonUtil.deleteLifecycle(name, this.getConfigSystemRegistry(), this.getRootRegistry());
    }

    public boolean isLifecycleNameInUse(String name) throws Exception {
        return CommonUtil.isLifecycleNameInUse(name, this.getConfigSystemRegistry(), this.getRootRegistry());
    }

    public boolean parseConfiguration(String configuration) throws Exception {
        return LifecycleBeanPopulator.deserializeLifecycleBean(configuration, this.getRootRegistry());
    }

    public String getLifecycleConfigurationVersion(String name) throws Exception {
        return CommonUtil.getLifecycleConfigurationVersion(name, this.getConfigSystemRegistry());
    }

    public DurationBean getLifecycleCurrentStateDuration(String registryPathToResource, String lifecycleName) throws GovernanceException {
        return LifecycleStateDurationUtils.getCurrentLifecycleStateDuration(registryPathToResource, lifecycleName, this.getRootRegistry());
    }
}

