/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.governance.lcm.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.cache.Cache;
import org.apache.commons.lang.ArrayUtils;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.context.RegistryType;
import org.wso2.carbon.governance.api.common.dataobjects.GovernanceArtifact;
import org.wso2.carbon.governance.api.util.GovernanceUtils;
import org.wso2.carbon.governance.lcm.beans.DurationBean;
import org.wso2.carbon.governance.lcm.beans.LCStateBean;
import org.wso2.carbon.governance.lcm.beans.LifeCycleActionsBean;
import org.wso2.carbon.governance.lcm.beans.LifeCycleApprovalBean;
import org.wso2.carbon.governance.lcm.beans.LifeCycleCheckListItemBean;
import org.wso2.carbon.governance.lcm.beans.LifeCycleInputBean;
import org.wso2.carbon.governance.lcm.exception.LifeCycleException;
import org.wso2.carbon.governance.lcm.services.LifeCycleService;
import org.wso2.carbon.governance.lcm.util.CommonUtil;
import org.wso2.carbon.governance.lcm.util.LifecycleStateDurationUtils;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.caching.RegistryCacheKey;
import org.wso2.carbon.registry.core.config.DataBaseConfiguration;
import org.wso2.carbon.registry.core.config.Mount;
import org.wso2.carbon.registry.core.config.RemoteConfiguration;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.registry.core.utils.RegistryUtils;
import org.wso2.carbon.user.core.UserRealm;
import org.wso2.carbon.user.core.UserStoreException;

public class LifeCycleServiceImpl
implements LifeCycleService {
    public static final String REGISTRY_CUSTOM_LIFECYCLE_INPUTS = "registry.custom_lifecycle.inputs.";

    @Override
    public boolean createLifecycle(String lifecycleConfiguration) throws LifeCycleException {
        throw new UnsupportedOperationException("Not implemented, yet");
    }

    @Override
    public boolean updateLifecycle(String lifCycleName, String lifecycleConfiguration) throws LifeCycleException {
        throw new UnsupportedOperationException("Not implemented, yet");
    }

    @Override
    public boolean deleteLifecycle(String lifCycleName) throws LifeCycleException {
        throw new UnsupportedOperationException("Not implemented, yet");
    }

    @Override
    public boolean isLifecycleNameInUse(String name) throws LifeCycleException {
        throw new UnsupportedOperationException("Not implemented, yet");
    }

    @Override
    public boolean validateLifeCycleConfiguration(String lifecycleConfiguration) throws LifeCycleException {
        throw new UnsupportedOperationException("Not implemented, yet");
    }

    @Override
    public DurationBean getLifecycleCurrentStateDuration(String artifactId, String lifecycleName) throws LifeCycleException {
        try {
            UserRegistry registry = CommonUtil.getRootSystemRegistry(this.getTenantId());
            String path = GovernanceUtils.getDirectArtifactPath((Registry)registry, (String)artifactId);
            if (path != null) {
                return LifecycleStateDurationUtils.getCurrentLifecycleStateDuration(path, lifecycleName, (Registry)registry);
            }
            throw new LifeCycleException("Unable to find the artifact " + artifactId);
        }
        catch (RegistryException e) {
            throw new LifeCycleException(e);
        }
    }

    @Override
    public LCStateBean getLifeCycleStateBean(String artifactId, String artifactLC) throws LifeCycleException {
        try {
            UserRegistry registry = (UserRegistry)this.getGovernanceUserRegistry();
            UserRealm userRealm = registry.getUserRealm();
            String[] roleNames = userRealm.getUserStoreManager().getRoleListOfUser(registry.getUserName());
            String path = GovernanceUtils.getArtifactPath((Registry)registry, (String)artifactId);
            if (path != null) {
                LifeCycleServiceImpl.removeCache((Registry)registry, path);
                Resource resource = registry.get(path);
                LCStateBean lifeCycleStateBean = this.getCheckListItems(resource, artifactLC, roleNames, registry);
                GovernanceArtifact governanceArtifact = GovernanceUtils.retrieveGovernanceArtifactById((Registry)registry, (String)artifactId);
                Map currentStateDurationData = governanceArtifact.getCurrentStateDuration(artifactId, artifactLC);
                if (currentStateDurationData != null && !currentStateDurationData.isEmpty()) {
                    lifeCycleStateBean.setLifeCycleCurrentStateDuration((String)currentStateDurationData.get("currentStateDuration"));
                    lifeCycleStateBean.setLifeCycleCurrentStateDurationColour((String)currentStateDurationData.get("durationColour"));
                }
                return lifeCycleStateBean;
            }
            throw new LifeCycleException("Unable to find the artifact " + artifactId);
        }
        catch (RegistryException | UserStoreException e) {
            throw new LifeCycleException(e);
        }
    }

    @Override
    public List<LCStateBean> getLifeCycleStateBeans(String artifactId) throws LifeCycleException {
        try {
            ArrayList<LCStateBean> lifeCycleStateBeans = new ArrayList<LCStateBean>();
            UserRegistry registry = (UserRegistry)this.getGovernanceUserRegistry();
            UserRealm userRealm = registry.getUserRealm();
            String[] rolesList = userRealm.getUserStoreManager().getRoleListOfUser(registry.getUserName());
            String path = GovernanceUtils.getArtifactPath((Registry)registry, (String)artifactId);
            if (path != null) {
                Resource resource = registry.get(path);
                List aspects = resource.getAspects();
                if (aspects != null) {
                    for (String aspect : aspects) {
                        LCStateBean lifeCycleStateBean = this.getCheckListItems(resource, aspect, rolesList, registry);
                        GovernanceArtifact governanceArtifact = GovernanceUtils.retrieveGovernanceArtifactByPath((Registry)registry, (String)resource.getPath());
                        lifeCycleStateBean.setLifeCycleCurrentStateDuration((String)governanceArtifact.getCurrentStateDuration(resource.getPath(), aspect).get("currentStateDuration"));
                        lifeCycleStateBean.setLifeCycleCurrentStateDurationColour((String)governanceArtifact.getCurrentStateDuration(resource.getPath(), aspect).get("durationColour"));
                        lifeCycleStateBeans.add(lifeCycleStateBean);
                    }
                }
            } else {
                throw new LifeCycleException("Unable to find the artifact " + artifactId);
            }
            return lifeCycleStateBeans;
        }
        catch (RegistryException | UserStoreException e) {
            throw new LifeCycleException(e);
        }
    }

    private Registry getGovernanceUserRegistry() {
        return (Registry)PrivilegedCarbonContext.getThreadLocalCarbonContext().getRegistry(RegistryType.USER_GOVERNANCE);
    }

    private int getTenantId() {
        return PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
    }

    private LCStateBean getCheckListItems(Resource artifactResource, String artifactLC, String[] roleNames, UserRegistry registry) throws RegistryException {
        String artifactLCState = artifactResource.getProperty("registry.lifecycle." + artifactLC + ".state");
        LCStateBean lifeCycleStateBean = new LCStateBean();
        if (artifactLCState == null) {
            return lifeCycleStateBean;
        }
        lifeCycleStateBean.setLifeCycleName(artifactLC);
        lifeCycleStateBean.setLifeCycleState(artifactLCState);
        ArrayList<LifeCycleCheckListItemBean> checkListItemList = new ArrayList<LifeCycleCheckListItemBean>();
        ArrayList<LifeCycleApprovalBean> lifeCycleApprovalBeanList = new ArrayList<LifeCycleApprovalBean>();
        String[] aspectActions = registry.getAspectActions(artifactResource.getPath(), artifactLC);
        if (aspectActions != null && aspectActions.length > 0) {
            LifeCycleActionsBean lifecycleActionsEntry = new LifeCycleActionsBean();
            lifecycleActionsEntry.setLifecycle(artifactLC);
            lifecycleActionsEntry.setActions(aspectActions);
            lifeCycleStateBean.setLifeCycleActionsBean(lifecycleActionsEntry);
        }
        Properties lifecycleProps = artifactResource.getProperties();
        ArrayList<String> permissionList = new ArrayList<String>();
        ArrayList<String> approvePermissionList = new ArrayList<String>();
        HashMap<String, List<LifeCycleInputBean>> lifeCycleInputBeanMap = new HashMap<String, List<LifeCycleInputBean>>();
        Set<Object> propertyKeys = lifecycleProps.keySet();
        for (Object propertyObj : propertyKeys) {
            String key;
            List propValues;
            String propertyKey = (String)propertyObj;
            String checkListPrefix = "registry.custom_lifecycle.checklist.";
            String permissionSuffix = ".item.permission";
            String votePrefix = "registry.custom_lifecycle.votes.";
            String votePermissionSuffix = ".vote.permission";
            if (propertyKey.startsWith(checkListPrefix) && propertyKey.endsWith(permissionSuffix) && propertyKey.contains("." + artifactLC + ".")) {
                for (String string : roleNames) {
                    propValues = (List)lifecycleProps.get(propertyKey);
                    for (String propValue : propValues) {
                        key = propertyKey.replace(checkListPrefix, "").replace(permissionSuffix, "");
                        if (propValue.equals(string)) {
                            permissionList.add(key);
                            continue;
                        }
                        if (!propValue.startsWith(checkListPrefix) || !propValue.endsWith(permissionSuffix)) continue;
                        permissionList.add(key);
                    }
                }
            }
            if (!propertyKey.startsWith(votePrefix) || !propertyKey.endsWith(votePermissionSuffix) || !propertyKey.contains("." + artifactLC + ".")) continue;
            for (String string : roleNames) {
                propValues = (List)lifecycleProps.get(propertyKey);
                for (String propValue : propValues) {
                    key = propertyKey.replace(votePrefix, "").replace(votePermissionSuffix, "");
                    if (propValue.equals(string)) {
                        approvePermissionList.add(key);
                        continue;
                    }
                    if (!propValue.startsWith(votePrefix) || !propValue.endsWith(votePermissionSuffix)) continue;
                    approvePermissionList.add(key);
                }
            }
        }
        String lifecyleInputs = REGISTRY_CUSTOM_LIFECYCLE_INPUTS;
        for (Object key : lifecycleProps.keySet()) {
            if (!key.toString().startsWith(lifecyleInputs + artifactLC + "." + artifactLCState)) continue;
            List propValues = (List)lifecycleProps.get(key);
            LifeCycleInputBean lifeCycleInputBean = new LifeCycleInputBean();
            lifeCycleInputBean.setName((String)propValues.get(1));
            lifeCycleInputBean.setRequired(Boolean.getBoolean((String)propValues.get(2)));
            lifeCycleInputBean.setLabel((String)propValues.get(3));
            lifeCycleInputBean.setPlaceHolder((String)propValues.get(4));
            lifeCycleInputBean.setTooltip((String)propValues.get(5));
            lifeCycleInputBean.setRegex((String)propValues.get(6));
            ArrayList<LifeCycleInputBean> lifeCycleInputBeanList = (ArrayList<LifeCycleInputBean>)lifeCycleInputBeanMap.get(propValues.get(0));
            if (lifeCycleInputBeanList == null) {
                lifeCycleInputBeanList = new ArrayList<LifeCycleInputBean>();
            }
            lifeCycleInputBeanList.add(lifeCycleInputBean);
            lifeCycleInputBeanMap.put((String)propValues.get(0), (List<LifeCycleInputBean>)lifeCycleInputBeanList);
        }
        for (Object propertyObj : propertyKeys) {
            String string;
            List propValues;
            String propertyKey = (String)propertyObj;
            String checkListPrefix = "registry.custom_lifecycle.checklist.";
            String checkListSuffix = ".item";
            String prefixVote = "registry.custom_lifecycle.votes.";
            String suffixVote = ".vote";
            if (propertyKey.startsWith(checkListPrefix) && propertyKey.endsWith(checkListSuffix) && propertyKey.contains("." + artifactLC + ".")) {
                String string2;
                propValues = (List)lifecycleProps.get(propertyKey);
                LifeCycleCheckListItemBean checkListItem = new LifeCycleCheckListItemBean();
                if (propValues != null && propValues.size() > 2) {
                    for (String param : propValues) {
                        if (param.startsWith("status:")) {
                            checkListItem.setStatus(param.substring(7));
                            continue;
                        }
                        if (param.startsWith("name:")) {
                            checkListItem.setName(param.substring(5));
                            continue;
                        }
                        if (param.startsWith("value:")) {
                            checkListItem.setValue(Boolean.parseBoolean(param.substring(6)));
                            continue;
                        }
                        if (!param.startsWith("order:")) continue;
                        checkListItem.setOrder(Integer.parseInt(param.substring(6)));
                    }
                }
                if (permissionList.contains(string2 = propertyKey.replace(checkListPrefix, "").replace(checkListSuffix, ""))) {
                    checkListItem.setVisible("true");
                }
                checkListItemList.add(checkListItem);
                continue;
            }
            if (!propertyKey.startsWith(prefixVote) || !propertyKey.endsWith(suffixVote) || !propertyKey.contains("." + artifactLC + ".")) continue;
            propValues = (List)lifecycleProps.get(propertyKey);
            LifeCycleApprovalBean approveItem = new LifeCycleApprovalBean();
            approveItem.setVisible("false");
            if (propValues != null && propValues.size() > 2) {
                for (String param : propValues) {
                    if (param.startsWith("name:")) {
                        approveItem.setName(param.substring(5));
                    }
                    if (param.startsWith("users:")) {
                        boolean userVoted = false;
                        String users = param.replace("users:", "");
                        String[] votedUsers = users.split(",");
                        userVoted = Arrays.asList(votedUsers).contains(registry.getUserName());
                        approveItem.setValue(userVoted);
                    }
                    if (param.startsWith("votes:")) {
                        approveItem.setRequiredVote(Integer.parseInt(param.substring(6)));
                    }
                    if (param.startsWith("current:")) {
                        approveItem.setCurrentVote(Integer.parseInt(param.substring(8)));
                    }
                    if (!param.startsWith("order:")) continue;
                    approveItem.setOrder(Integer.parseInt(param.substring(6)));
                }
            }
            if (approvePermissionList.contains(string = propertyKey.replace(prefixVote, "").replace(suffixVote, ""))) {
                approveItem.setVisible("true");
            }
            if (lifeCycleStateBean.getLifeCycleActionsBean() == null) continue;
            LifeCycleActionsBean lifeCycleActionsBean = lifeCycleStateBean.getLifeCycleActionsBean();
            List<String> lcActionList = Arrays.asList(lifeCycleActionsBean.getActions());
            if (lcActionList.contains(approveItem.getName()) && "true".equals(approveItem.getVisible())) {
                lifeCycleApprovalBeanList.add(approveItem);
            }
            if (approveItem.getCurrentVote() < approveItem.getRequiredVote()) {
                String[] newActions = (String[])ArrayUtils.removeElement((Object[])lifeCycleActionsBean.getActions(), (Object)approveItem.getName());
                lifeCycleActionsBean.setActions(newActions);
            }
            lifeCycleStateBean.setLifeCycleActionsBean(lifeCycleActionsBean);
        }
        lifeCycleStateBean.setLifeCycleApprovalBeanList(lifeCycleApprovalBeanList);
        lifeCycleStateBean.setLifeCycleCheckListItemBeans(checkListItemList);
        lifeCycleStateBean.setLifeCycleInputBeanMap(lifeCycleInputBeanMap);
        return lifeCycleStateBean;
    }

    private static void removeCache(Registry registry, String path) {
        String updatedPath = "/_system/governance" + path;
        int tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
        Cache cache = RegistryUtils.getResourceCache((String)"REG_CACHE_BACKED_ID");
        RegistryCacheKey cacheKey = null;
        if (registry.getRegistryContext().getRemoteInstances().size() > 0) {
            for (Mount mount : registry.getRegistryContext().getMounts()) {
                for (RemoteConfiguration configuration : registry.getRegistryContext().getRemoteInstances()) {
                    DataBaseConfiguration dataBaseConfiguration;
                    String connectionId;
                    if (!updatedPath.startsWith(mount.getPath()) || (cacheKey = RegistryUtils.buildRegistryCacheKey((String)(connectionId = ((dataBaseConfiguration = registry.getRegistryContext().getDBConfig(configuration.getDbConfig())).getUserName() != null ? dataBaseConfiguration.getUserName().split("@")[0] : dataBaseConfiguration.getUserName()) + "@" + dataBaseConfiguration.getDbUrl()), (int)tenantId, (String)updatedPath)) == null || !cache.containsKey((Object)cacheKey)) continue;
                    cache.remove((Object)cacheKey);
                }
            }
        } else {
            DataBaseConfiguration dataBaseConfiguration = registry.getRegistryContext().getDefaultDataBaseConfiguration();
            String connectionId = (dataBaseConfiguration.getUserName() != null ? dataBaseConfiguration.getUserName().split("@")[0] : dataBaseConfiguration.getUserName()) + "@" + dataBaseConfiguration.getDbUrl();
            cacheKey = RegistryUtils.buildRegistryCacheKey((String)connectionId, (int)tenantId, (String)updatedPath);
            if (cacheKey != null && cache.containsKey((Object)cacheKey)) {
                cache.remove((Object)cacheKey);
            }
        }
    }
}

