/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.governance.lcm.internal;

import java.io.FileNotFoundException;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.governance.lcm.internal.LifeCycleServiceHolder;
import org.wso2.carbon.governance.lcm.internal.LifeCycleServiceImpl;
import org.wso2.carbon.governance.lcm.listener.LifecycleLoader;
import org.wso2.carbon.governance.lcm.services.LifeCycleService;
import org.wso2.carbon.governance.lcm.util.CommonUtil;
import org.wso2.carbon.registry.common.AttributeSearchService;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.utils.Axis2ConfigurationContextObserver;

@Component(name="org.wso2.carbon.governance.lcm", immediate=true)
public class LCMServiceComponent {
    private static Log log = LogFactory.getLog(LCMServiceComponent.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Activate
    protected void activate(ComponentContext context) {
        BundleContext bundleContext = context.getBundleContext();
        try {
            PrivilegedCarbonContext.startTenantFlow();
            PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantId(-1234, true);
            PrivilegedCarbonContext.getThreadLocalCarbonContext().setUsername("wso2.system.user");
            RegistryService registryService = LifeCycleServiceHolder.getInstance().getRegistryService();
            CommonUtil.addDefaultLifecyclesIfNotAvailable((Registry)registryService.getConfigSystemRegistry(), (Registry)registryService.getRegistry("wso2.system.user"));
        }
        catch (FileNotFoundException | XMLStreamException | RegistryException e) {
            log.error((Object)"An error occurred while setting up Governance Life Cycle Management", e);
        }
        finally {
            PrivilegedCarbonContext.endTenantFlow();
        }
        LifecycleLoader lifecycleLoader = new LifecycleLoader();
        ServiceRegistration tenantMgtListenerSR = bundleContext.registerService(Axis2ConfigurationContextObserver.class.getName(), (Object)lifecycleLoader, null);
        bundleContext.registerService(LifeCycleService.class.getName(), (Object)new LifeCycleServiceImpl(), null);
        if (tenantMgtListenerSR != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Governance Life Cycle Management - LifecycleLoader registered");
            }
        } else {
            log.error((Object)"Governance Life Cycle Management - LifecycleLoader could not be registered");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Governance Life Cycle Management Service bundle is activated");
        }
    }

    @Deactivate
    protected void deactivate(ComponentContext context) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Governance Life Cycle Management Service bundle is deactivated");
        }
    }

    @Reference(name="registry.service", service=RegistryService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetRegistryService")
    protected void setRegistryService(RegistryService registryService) {
        PrivilegedCarbonContext carbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
        carbonContext.setTenantDomain("carbon.super");
        carbonContext.setTenantId(-1234);
        LifeCycleServiceHolder.getInstance().setRegistryService(registryService);
        try {
            CommonUtil.addDefaultLifecyclesIfNotAvailable((Registry)registryService.getConfigSystemRegistry(), (Registry)registryService.getRegistry("wso2.system.user"));
        }
        catch (Exception e) {
            log.error((Object)"An error occurred while setting up Governance Life Cycle Management", (Throwable)e);
        }
    }

    protected void unsetRegistryService(RegistryService registryService) {
        LifeCycleServiceHolder.getInstance().setRegistryService(null);
    }

    @Reference(name="registry.attribute.indexing", service=AttributeSearchService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetAttributeSearchService")
    protected void setAttributeSearchService(AttributeSearchService attributeSearchService) {
        LifeCycleServiceHolder.getInstance().setAttributeSearchService(attributeSearchService);
    }

    protected void unsetAttributeSearchService(AttributeSearchService attributeSearchService) {
        LifeCycleServiceHolder.getInstance().setAttributeSearchService(null);
    }
}

