/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.statistics.internal.jmx;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.wso2.carbon.event.statistics.EventStatisticsObserver;
import org.wso2.carbon.event.statistics.internal.data.CollectionDTO;
import org.wso2.carbon.event.statistics.internal.data.StatsDTO;
import org.wso2.carbon.event.statistics.internal.jmx.MBeanRegistrar;
import org.wso2.carbon.event.statistics.internal.jmx.StatisticsView;

public class JMXObserver
implements EventStatisticsObserver {
    private ConcurrentHashMap<String, List<String>> registeredMbeanIds = new ConcurrentHashMap();
    private ConcurrentHashMap<String, Map<String, StatisticsView>> data = new ConcurrentHashMap();

    @Override
    public void destroy() {
        for (Map.Entry<String, List<String>> entry : this.registeredMbeanIds.entrySet()) {
            for (String value : entry.getValue()) {
                MBeanRegistrar.getInstance().unRegisterMBean(entry.getKey(), value);
            }
        }
    }

    @Override
    public void updateStatistics(CollectionDTO collectionDTO) {
        String id = collectionDTO.getStatsDTO().getName();
        this.updateView(collectionDTO.getStatsDTO(), id);
        if (collectionDTO.getChildCollectionDTOs() != null) {
            for (CollectionDTO collectionDTO1 : collectionDTO.getChildCollectionDTOs()) {
                String id1 = id + "." + collectionDTO1.getStatsDTO().getName();
                this.updateView(collectionDTO1.getStatsDTO(), id1);
                if (collectionDTO1.getChildCollectionDTOs() == null) continue;
                for (CollectionDTO collectionDTO2 : collectionDTO1.getChildCollectionDTOs()) {
                    String id2 = id1 + "." + collectionDTO2.getStatsDTO().getName();
                    this.updateView(collectionDTO2.getStatsDTO(), id2);
                    if (collectionDTO2.getChildCollectionDTOs() == null) continue;
                    for (CollectionDTO collectionDTO3 : collectionDTO2.getChildCollectionDTOs()) {
                        String id3 = id2 + "." + collectionDTO3.getStatsDTO().getName();
                        this.updateView(collectionDTO3.getStatsDTO(), id3);
                    }
                }
            }
        }
    }

    private void updateView(StatsDTO statsDTO, String id) {
        StatisticsView view;
        Map<String, StatisticsView> map = this.data.get(statsDTO.getType());
        if (map == null) {
            this.data.putIfAbsent(statsDTO.getType(), new HashMap());
            map = this.data.get(statsDTO.getType());
        }
        if (!map.containsKey(id)) {
            view = new StatisticsView();
            MBeanRegistrar.getInstance().registerMBean(view, statsDTO.getType(), id);
            List<String> ids = this.registeredMbeanIds.get(statsDTO.getType());
            if (ids == null) {
                this.registeredMbeanIds.putIfAbsent(statsDTO.getType(), new ArrayList());
                ids = this.registeredMbeanIds.get(statsDTO.getType());
            }
            ids.add(id);
            map.put(id, view);
        } else {
            view = map.get(id);
        }
        this.updateView(view, statsDTO);
    }

    private void updateView(StatisticsView view, StatsDTO statsDTO) {
        view.setRequestCount(view.getRequestCount() + (statsDTO.getRequestTotalCount() - view.getRequestTotalCount()));
        view.setResponseCount(view.getResponseCount() + (statsDTO.getResponseTotalCount() - view.getResponseTotalCount()));
        view.setRequestTotalCount(statsDTO.getRequestTotalCount());
        view.setRequestAvgCountPerSec(statsDTO.getRequestAvgCountPerSec());
        view.setRequestMaxCountPerSec(statsDTO.getRequestMaxCountPerSec());
        view.setRequestLastUpdatedTime(statsDTO.getRequestLastUpdatedTime());
        view.setRequestLastSecCount(statsDTO.getRequestLastSecCount());
        view.setRequestLastMinCount(statsDTO.getRequestLastMinCount());
        view.setRequestLast15MinCount(statsDTO.getRequestLast15MinCount());
        view.setRequestLastHourCount(statsDTO.getRequestLastHourCount());
        view.setRequestLast6HourCount(statsDTO.getRequestLast6HourCount());
        view.setRequestLastDayCount(statsDTO.getRequestLastDayCount());
        view.setResponseTotalCount(statsDTO.getResponseTotalCount());
        view.setResponseAvgCountPerSec(statsDTO.getResponseAvgCountPerSec());
        view.setResponseMaxCountPerSec(statsDTO.getResponseMaxCountPerSec());
        view.setResponseLastUpdatedTime(statsDTO.getResponseLastUpdatedTime());
        view.setResponseLastSecCount(statsDTO.getResponseLastSecCount());
        view.setResponseLastMinCount(statsDTO.getResponseLastMinCount());
        view.setResponseLast15MinCount(statsDTO.getResponseLast15MinCount());
        view.setResponseLastHourCount(statsDTO.getResponseLastHourCount());
        view.setResponseLast6HourCount(statsDTO.getResponseLast6HourCount());
        view.setResponseLastDayCount(statsDTO.getResponseLastDayCount());
    }
}

