/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.statistics.internal.ds;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.wso2.carbon.base.ServerConfiguration;
import org.wso2.carbon.event.statistics.EventStatisticsService;
import org.wso2.carbon.event.statistics.internal.EventStatisticsManager;
import org.wso2.carbon.event.statistics.internal.ds.EventStatisticsServiceHolder;

@Component(name="mediation.statistics", immediate=true)
public class EventStatisticsDS {
    private static final Log log = LogFactory.getLog(EventStatisticsDS.class);

    @Activate
    protected void activate(ComponentContext context) throws Exception {
        try {
            this.createStatisticsManager();
            EventStatisticsServiceHolder.getInstance().setEventStatisticsService(new EventStatisticsService());
            context.getBundleContext().registerService(EventStatisticsService.class.getName(), (Object)EventStatisticsServiceHolder.getInstance().getEventStatisticsService(), null);
            if (log.isDebugEnabled()) {
                log.debug((Object)"Successfully deployed the event statistics monitoring service");
            }
        }
        catch (Throwable e) {
            log.error((Object)"Can not create the event statistics monitoring service ", e);
        }
    }

    private void createStatisticsManager() {
        boolean disabled;
        ServerConfiguration config = ServerConfiguration.getInstance();
        String confStatisticsReporterDisabled = config.getFirstProperty("StatisticsReporterDisabled");
        if (!"".equals(confStatisticsReporterDisabled) && (disabled = Boolean.valueOf(confStatisticsReporterDisabled).booleanValue())) {
            return;
        }
        EventStatisticsServiceHolder.getInstance().setEventStatisticsManager(new EventStatisticsManager());
    }

    @Deactivate
    protected void deactivate(ComponentContext compCtx) throws Exception {
    }
}

