/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.statistics.internal.counter;

import java.util.concurrent.ConcurrentHashMap;
import org.wso2.carbon.event.statistics.internal.counter.BasicStatsCounter;

public class StatsCounter {
    private BasicStatsCounter requestStatCounter = new BasicStatsCounter();
    private BasicStatsCounter responseStatCounter = new BasicStatsCounter();
    private ConcurrentHashMap<String, StatsCounter> childCounters = new ConcurrentHashMap();
    private String name;
    private String type;

    public StatsCounter(String name, String type) {
        this.name = name;
        this.type = type;
    }

    public void addChildCounter(String name, StatsCounter childCounter) {
        this.childCounters.putIfAbsent(name, childCounter);
    }

    public StatsCounter getChildCounter(String name) {
        return this.childCounters.get(name);
    }

    public String getName() {
        return this.name;
    }

    public void incrementRequest() {
        this.requestStatCounter.update();
    }

    public void incrementResponse() {
        this.responseStatCounter.update();
    }

    public void reset() {
        this.requestStatCounter.reset();
        this.responseStatCounter.reset();
        for (StatsCounter childStatsCounter : this.childCounters.values()) {
            childStatsCounter.reset();
        }
    }

    public BasicStatsCounter getRequestStatCounter() {
        return this.requestStatCounter;
    }

    public BasicStatsCounter getResponseStatCounter() {
        return this.responseStatCounter;
    }

    public ConcurrentHashMap<String, StatsCounter> getChildCounters() {
        return this.childCounters;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }
}

