/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.statistics.internal.counter;

public class BasicStatsCounter {
    private long startTime;
    private long lastUpdatedTime;
    private long totalCount;
    private long prevSecCount;
    private long prevMinCount;
    private long prev15MinCount;
    private long prevHourCount;
    private long prev6HourCount;
    private long prevDayCount;
    private long maxCountPerSec;
    private double avgCountPerSec;
    private long currentSecCount;
    private long currentMinCount;
    private long current15MinCount;
    private long currentHourCount;
    private long current6HourCount;
    private long currentDayCount;
    private long currentSec;
    private long currentMin;
    private long current15Min;
    private long currentHour;
    private long current6Hour;
    private long currentDay;

    public BasicStatsCounter() {
        this.reset();
    }

    public long getTotalCount() {
        return this.totalCount;
    }

    public long getLastSecCount() {
        return this.currentSecCount + this.prevSecCount * (1000L - (this.lastUpdatedTime - this.currentSec * 1000L)) / 1000L;
    }

    public long getLastMinCount() {
        return this.currentMinCount + this.prevMinCount * (60000L - (this.lastUpdatedTime - this.currentMin * 60000L)) / 60000L;
    }

    public long getLast15MinCount() {
        return this.current15MinCount + this.prev15MinCount * (900000L - (this.lastUpdatedTime - this.current15Min * 900000L)) / 900000L;
    }

    public long getLastHourCount() {
        return this.currentHourCount + this.prevHourCount * (3600000L - (this.lastUpdatedTime - this.currentHour * 3600000L)) / 3600000L;
    }

    public long getLast6HourCount() {
        return this.current6HourCount + this.prev6HourCount * (21600000L - (this.lastUpdatedTime - this.current6Hour * 21600000L)) / 21600000L;
    }

    public long getLastDayCount() {
        return this.currentDayCount + this.prevDayCount * (86400000L - (this.lastUpdatedTime - this.currentDay * 86400000L)) / 86400000L;
    }

    public long getMaxCountPerSec() {
        return this.maxCountPerSec;
    }

    public double getAvgCountPerSec() {
        return (double)Math.round(this.avgCountPerSec * 1000.0) / 1000.0;
    }

    public long getLastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public synchronized void update() {
        this.lastUpdatedTime = System.currentTimeMillis();
        ++this.totalCount;
        if (this.currentSec < this.lastUpdatedTime / 1000L) {
            this.currentSec = this.lastUpdatedTime / 1000L;
            this.prevSecCount = this.currentSecCount;
            this.currentSecCount = 0L;
            if (this.currentMin < this.lastUpdatedTime / 60000L) {
                this.currentMin = this.lastUpdatedTime / 60000L;
                this.prevMinCount = this.currentMinCount;
                this.currentMinCount = 0L;
                if (this.current15Min < this.lastUpdatedTime / 900000L) {
                    this.current15Min = this.lastUpdatedTime / 900000L;
                    this.prev15MinCount = this.current15MinCount;
                    this.current15MinCount = 0L;
                }
                if (this.currentHour < this.lastUpdatedTime / 3600000L) {
                    this.currentHour = this.lastUpdatedTime / 3600000L;
                    this.prevHourCount = this.currentHourCount;
                    this.currentHourCount = 0L;
                }
                if (this.current6Hour < this.lastUpdatedTime / 21600000L) {
                    this.current6Hour = this.lastUpdatedTime / 21600000L;
                    this.prev6HourCount = this.current6HourCount;
                    this.current6HourCount = 0L;
                }
                if (this.currentDay < this.lastUpdatedTime / 86400000L) {
                    this.currentDay = this.lastUpdatedTime / 86400000L;
                    this.prevDayCount = this.currentDayCount;
                    this.currentDayCount = 0L;
                }
            }
        }
        ++this.currentSecCount;
        ++this.currentMinCount;
        ++this.current15MinCount;
        ++this.currentHourCount;
        ++this.current6HourCount;
        ++this.currentDayCount;
        if (this.currentSecCount > this.maxCountPerSec) {
            this.maxCountPerSec = this.currentSecCount;
        }
        if (this.currentSec == this.startTime / 1000L) {
            this.startTime = this.lastUpdatedTime;
            this.avgCountPerSec = this.totalCount;
        } else {
            this.avgCountPerSec = (double)this.totalCount * (1000.0 / (double)(this.lastUpdatedTime - this.startTime));
        }
    }

    public String toString() {
        return "DataCounter{totalCount=" + this.getTotalCount() + ", avgCountPerSec=" + this.getAvgCountPerSec() + ", maxCountPerSec=" + this.getMaxCountPerSec() + ", lastSecCount=" + this.getLastSecCount() + ", lastMinCount=" + this.getLastMinCount() + ", last15MinCount=" + this.getLast15MinCount() + ", lastHourCount=" + this.getLastHourCount() + ", last6HourCount=" + this.getLast6HourCount() + ", lastDayCount=" + this.getLastDayCount() + '}';
    }

    public void reset() {
        this.startTime = System.currentTimeMillis();
        this.lastUpdatedTime = -1L;
        this.totalCount = 0L;
        this.prevSecCount = 0L;
        this.prevMinCount = 0L;
        this.prev15MinCount = 0L;
        this.prevHourCount = 0L;
        this.prev6HourCount = 0L;
        this.prevDayCount = 0L;
        this.maxCountPerSec = 0L;
        this.avgCountPerSec = 0.0;
        this.currentSecCount = 0L;
        this.currentMinCount = 0L;
        this.current15MinCount = 0L;
        this.currentHourCount = 0L;
        this.current6HourCount = 0L;
        this.currentDayCount = 0L;
        this.currentSec = 0L;
        this.currentMin = 0L;
        this.current15Min = 0L;
        this.currentHour = 0L;
        this.current6Hour = 0L;
        this.currentDay = 0L;
    }
}

