/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.statistics.internal;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.event.statistics.internal.EventStatisticsManager;
import org.wso2.carbon.event.statistics.internal.EventStatsHelper;
import org.wso2.carbon.event.statistics.internal.counter.StatsCounter;
import org.wso2.carbon.event.statistics.internal.data.CollectionDTO;
import org.wso2.carbon.event.statistics.internal.ds.EventStatisticsServiceHolder;

public class StatisticsReporterThread
extends Thread {
    private static Log log = LogFactory.getLog(StatisticsReporterThread.class);
    private boolean shutdownRequested = false;
    private long delay = 5000L;
    private int tenantId;

    public StatisticsReporterThread(int tenantId) {
        this.setName("event-stat-collector-" + tenantId);
        this.tenantId = tenantId;
    }

    public void setDelay(long delay) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Event statistics reporter delay set to " + delay + " ms"));
        }
        this.delay = delay;
    }

    private void delay() {
        if (this.delay <= 0L) {
            return;
        }
        try {
            StatisticsReporterThread.sleep(this.delay);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public void run() {
        while (!this.shutdownRequested) {
            try {
                this.collectDataAndReport();
            }
            catch (Throwable t) {
                log.error((Object)"Error while collecting and reporting event statistics", t);
            }
        }
    }

    private void collectDataAndReport() {
        if (log.isDebugEnabled()) {
            log.trace((Object)"Starting new mediation statistics collection cycle");
        }
        EventStatisticsManager eventStatisticsManager = EventStatisticsServiceHolder.getInstance().getEventStatisticsManager();
        CollectionDTO tenantCollectionDTO = new CollectionDTO();
        StatsCounter tenantCounter = eventStatisticsManager.getTenantDataMap().get(this.tenantId);
        if (tenantCounter == null) {
            tenantCounter = new StatsCounter(this.tenantId + "", "tenant");
            eventStatisticsManager.getTenantDataMap().putIfAbsent(this.tenantId, tenantCounter);
            tenantCounter = eventStatisticsManager.getTenantDataMap().get(this.tenantId);
        }
        tenantCollectionDTO.setStatsDTO(EventStatsHelper.constructStatsDTO(tenantCounter));
        if (tenantCounter.getChildCounters().size() > 0) {
            CollectionDTO[] categoryCollectionDTOs = new CollectionDTO[tenantCounter.getChildCounters().size()];
            tenantCollectionDTO.setChildCollectionDTOs(categoryCollectionDTOs);
            int categoryCount = 0;
            for (StatsCounter categoryCounter : tenantCounter.getChildCounters().values()) {
                categoryCollectionDTOs[categoryCount] = new CollectionDTO();
                categoryCollectionDTOs[categoryCount].setStatsDTO(EventStatsHelper.constructStatsDTO(categoryCounter));
                if (categoryCounter.getChildCounters().size() > 0) {
                    CollectionDTO[] deploymentCollectionDTOs = new CollectionDTO[categoryCounter.getChildCounters().size()];
                    categoryCollectionDTOs[categoryCount].setChildCollectionDTOs(deploymentCollectionDTOs);
                    int deploymentCount = 0;
                    for (StatsCounter deploymentCounter : categoryCounter.getChildCounters().values()) {
                        deploymentCollectionDTOs[deploymentCount] = new CollectionDTO();
                        deploymentCollectionDTOs[deploymentCount].setStatsDTO(EventStatsHelper.constructStatsDTO(deploymentCounter));
                        if (deploymentCounter.getChildCounters().size() > 0) {
                            CollectionDTO[] elementCollectionDTOs = new CollectionDTO[deploymentCounter.getChildCounters().size()];
                            deploymentCollectionDTOs[deploymentCount].setChildCollectionDTOs(elementCollectionDTOs);
                            int elementCount = 0;
                            for (StatsCounter elementCounter : deploymentCounter.getChildCounters().values()) {
                                elementCollectionDTOs[elementCount] = new CollectionDTO();
                                elementCollectionDTOs[elementCount].setStatsDTO(EventStatsHelper.constructStatsDTO(elementCounter));
                                ++elementCount;
                            }
                        }
                        ++deploymentCount;
                    }
                }
                ++categoryCount;
            }
        }
        eventStatisticsManager.updateStatistics(tenantCollectionDTO);
        this.delay();
    }

    public void shutdown() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Event statistics reporter thread is being stopped");
        }
        this.shutdownRequested = true;
    }
}

