/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.statistics.internal;

import java.text.DateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.concurrent.ConcurrentHashMap;
import org.wso2.carbon.event.statistics.internal.counter.StatsCounter;
import org.wso2.carbon.event.statistics.internal.data.StatsDTO;

public class EventStatsHelper {
    public static StatsDTO constructStatsDTO(StatsCounter statsCounter) {
        StatsDTO statsDTO = new StatsDTO();
        statsDTO.setName(statsCounter.getName());
        statsDTO.setType(statsCounter.getType());
        statsDTO.setRequestTotalCount(statsCounter.getRequestStatCounter().getTotalCount());
        statsDTO.setRequestAvgCountPerSec(statsCounter.getRequestStatCounter().getAvgCountPerSec());
        statsDTO.setRequestMaxCountPerSec(statsCounter.getRequestStatCounter().getMaxCountPerSec());
        statsDTO.setRequestLastUpdatedTime(DateFormat.getDateTimeInstance().format(new Date(statsCounter.getRequestStatCounter().getLastUpdatedTime())));
        statsDTO.setRequestLastSecCount(statsCounter.getRequestStatCounter().getLastSecCount());
        statsDTO.setRequestLastMinCount(statsCounter.getRequestStatCounter().getLastMinCount());
        statsDTO.setRequestLast15MinCount(statsCounter.getRequestStatCounter().getLast15MinCount());
        statsDTO.setRequestLastHourCount(statsCounter.getRequestStatCounter().getLastHourCount());
        statsDTO.setRequestLast6HourCount(statsCounter.getRequestStatCounter().getLast6HourCount());
        statsDTO.setRequestLastDayCount(statsCounter.getRequestStatCounter().getLastDayCount());
        statsDTO.setResponseTotalCount(statsCounter.getResponseStatCounter().getTotalCount());
        statsDTO.setResponseAvgCountPerSec(statsCounter.getResponseStatCounter().getAvgCountPerSec());
        statsDTO.setResponseMaxCountPerSec(statsCounter.getResponseStatCounter().getMaxCountPerSec());
        statsDTO.setResponseLastUpdatedTime(DateFormat.getDateTimeInstance().format(new Date(statsCounter.getResponseStatCounter().getLastUpdatedTime())));
        statsDTO.setResponseLastSecCount(statsCounter.getResponseStatCounter().getLastSecCount());
        statsDTO.setResponseLastMinCount(statsCounter.getResponseStatCounter().getLastMinCount());
        statsDTO.setResponseLast15MinCount(statsCounter.getResponseStatCounter().getLast15MinCount());
        statsDTO.setResponseLastHourCount(statsCounter.getResponseStatCounter().getLastHourCount());
        statsDTO.setResponseLast6HourCount(statsCounter.getResponseStatCounter().getLast6HourCount());
        statsDTO.setResponseLastDayCount(statsCounter.getResponseStatCounter().getLastDayCount());
        if (statsCounter.getChildCounters().size() > 0) {
            Object[] children = ((ConcurrentHashMap.CollectionView)((Object)statsCounter.getChildCounters().keySet())).toArray(new String[((ConcurrentHashMap.CollectionView)((Object)statsCounter.getChildCounters().keySet())).size()]);
            Arrays.sort(children);
            statsDTO.setChildStats((String[])children);
        }
        return statsDTO;
    }
}

