/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.statistics.internal;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.event.statistics.EventStatisticsMonitor;
import org.wso2.carbon.event.statistics.EventStatisticsObserver;
import org.wso2.carbon.event.statistics.internal.EventStatisticsMonitorImpl;
import org.wso2.carbon.event.statistics.internal.counter.StatsCounter;
import org.wso2.carbon.event.statistics.internal.data.CollectionDTO;

public class EventStatisticsManager {
    private static final Log log = LogFactory.getLog(EventStatisticsManager.class);
    ConcurrentHashMap<Integer, StatsCounter> tenantDataMap;
    private Set<EventStatisticsObserver> observers = new HashSet<EventStatisticsObserver>();
    private final ConcurrentHashMap<String, EventStatisticsMonitor> statisticsMonitorMap;

    public EventStatisticsManager() {
        this.tenantDataMap = new ConcurrentHashMap();
        this.statisticsMonitorMap = new ConcurrentHashMap();
    }

    private synchronized EventStatisticsMonitor createNewEventStatisticMonitor(int tenantId, String category, String deployment, String element) {
        StatsCounter deploymentData;
        StatsCounter categoryData;
        StatsCounter tenantData = this.tenantDataMap.get(tenantId);
        if (tenantData == null) {
            tenantData = new StatsCounter(tenantId + "", "tenant");
            this.tenantDataMap.putIfAbsent(tenantId, tenantData);
            this.tenantDataMap.putIfAbsent(tenantId, tenantData);
            tenantData = this.tenantDataMap.get(tenantId);
        }
        if ((categoryData = tenantData.getChildCounter(category)) == null) {
            categoryData = new StatsCounter(category, "tenant");
            tenantData.addChildCounter(category, categoryData);
            categoryData = tenantData.getChildCounter(category);
        }
        if ((deploymentData = categoryData.getChildCounter(deployment)) == null) {
            deploymentData = new StatsCounter(deployment, "tenant");
            categoryData.addChildCounter(deployment, deploymentData);
            deploymentData = categoryData.getChildCounter(deployment);
        }
        StatsCounter elementData = null;
        if (element != null && (elementData = deploymentData.getChildCounter(element)) == null) {
            elementData = new StatsCounter(element, "tenant");
            deploymentData.addChildCounter(element, elementData);
            elementData = deploymentData.getChildCounter(element);
        }
        return new EventStatisticsMonitorImpl(tenantData, categoryData, deploymentData, elementData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized EventStatisticsMonitor getEventStatisticMonitor(int tenantId, String category, String deployment, String element) {
        String key = String.valueOf(tenantId) + category + deployment + element;
        EventStatisticsMonitor statisticsMonitor = this.statisticsMonitorMap.get(key);
        if (statisticsMonitor == null) {
            EventStatisticsManager eventStatisticsManager = this;
            synchronized (eventStatisticsManager) {
                statisticsMonitor = this.statisticsMonitorMap.get(key);
                if (statisticsMonitor == null) {
                    statisticsMonitor = this.createNewEventStatisticMonitor(tenantId, category, deployment, element);
                    this.statisticsMonitorMap.put(key, statisticsMonitor);
                }
            }
        }
        return statisticsMonitor;
    }

    public synchronized void reset() {
        for (StatsCounter tenantData : this.tenantDataMap.values()) {
            tenantData.reset();
        }
    }

    public ConcurrentHashMap<Integer, StatsCounter> getTenantDataMap() {
        return this.tenantDataMap;
    }

    public void registerObserver(EventStatisticsObserver o) {
        this.observers.add(o);
    }

    public void unregisterObserver(EventStatisticsObserver o) {
        if (this.observers.contains(o)) {
            this.observers.remove(o);
            o.destroy();
        }
    }

    public void unregisterObservers() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Unregistering event statistics observers");
        }
        for (EventStatisticsObserver o : this.observers) {
            o.destroy();
        }
        this.observers.clear();
    }

    public void updateStatistics(CollectionDTO collectionDTO) {
        for (EventStatisticsObserver o : this.observers) {
            try {
                o.updateStatistics(collectionDTO);
            }
            catch (Throwable t) {
                log.error((Object)"Error occurred while notifying the event statistics observer", t);
            }
        }
    }
}

