/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.proxyadmin.observer;

import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.ParameterObserver;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.config.SynapseConfiguration;
import org.apache.synapse.core.axis2.ProxyService;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.proxyadmin.ProxyAdminException;
import org.wso2.carbon.proxyadmin.service.ProxyServiceAdmin;
import org.wso2.carbon.proxyadmin.util.ConfigHolder;

public class ProxyServiceParameterObserver
implements ParameterObserver {
    private AxisService service;
    private int tanentId;
    private static final Log log = LogFactory.getLog(ProxyServiceParameterObserver.class);
    private static String[] skipParams = new String[]{"wso2statistics.service.response.time", "org.apache.axis2.context.externalize.AxisServiceName", "lastUsedTime"};

    public ProxyServiceParameterObserver(AxisService service) {
        this.service = service;
        this.tanentId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
    }

    public void parameterChanged(String name, Object value) {
        SynapseConfiguration config = ConfigHolder.getInstance().getSynapseEnvironmentService(this.tanentId).getSynapseEnvironment().getSynapseConfiguration();
        ProxyService proxy = config.getProxyService(this.service.getName());
        if ("passwordCallbackRef".equals(name)) {
            proxy.setModuleEngaged(true);
        }
        if (proxy != null) {
            if (this.service.getParameter(name) != null) {
                proxy.addParameter(name, value);
            } else {
                proxy.getParameterMap().remove(name);
            }
            if (!this.isSkipPersistenceForParam(name)) {
                try {
                    new ProxyServiceAdmin().persistProxyService(proxy);
                }
                catch (ProxyAdminException e) {
                    log.error((Object)"Error While persisting proxy information", (Throwable)e);
                }
            }
        } else {
            log.error((Object)("Proxy Service " + name + " does not exist "));
        }
    }

    private boolean isSkipPersistenceForParam(String name) {
        for (String param : skipParams) {
            if (!param.equals(name)) continue;
            return true;
        }
        return false;
    }
}

