/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.proxyadmin.observer;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axis2.AxisFault;
import org.apache.axis2.description.AxisModule;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.AxisEvent;
import org.apache.axis2.engine.AxisObserver;
import org.apache.axis2.util.JavaUtils;
import org.apache.axis2.util.PolicyUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyEngine;
import org.apache.rampart.Rampart;
import org.apache.synapse.config.SynapseConfigUtils;
import org.apache.synapse.config.SynapseConfiguration;
import org.apache.synapse.core.axis2.ProxyService;
import org.apache.synapse.util.PolicyInfo;
import org.wso2.carbon.mediation.initializer.persistence.MediationPersistenceManager;
import org.wso2.carbon.mediation.initializer.services.SynapseEnvironmentService;
import org.wso2.carbon.proxyadmin.ProxyAdminException;
import org.wso2.carbon.registry.core.Collection;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.session.UserRegistry;

public class ProxyObserver
implements AxisObserver {
    private SynapseEnvironmentService synapseEnvironmentService;
    private Registry configSystemRegistry;
    private static final Log log = LogFactory.getLog(ProxyObserver.class);
    private static final String[] DEFAULT_MODULES = new String[]{"addressing", "ServerAdminModule", "wso2statistics", "POXSecurityModule", "pagination", "wso2tracer"};

    public ProxyObserver(SynapseEnvironmentService synapseEnvironmentService, Registry configRegistry) throws ProxyAdminException {
        if (synapseEnvironmentService.getSynapseEnvironment().getSynapseConfiguration() == null) {
            String msg = "Unable to initialize a ProxyObserver with a null SynapseConfiguration";
            log.error((Object)msg);
            throw new ProxyAdminException(msg);
        }
        this.synapseEnvironmentService = synapseEnvironmentService;
        this.configSystemRegistry = configRegistry;
    }

    public void init(AxisConfiguration axisConfiguration) {
    }

    public void serviceUpdate(AxisEvent event, AxisService axisService) {
        ProxyService proxy;
        Parameter serviceTypeParam = axisService.getParameter("serviceType");
        if (serviceTypeParam == null || !"proxy".equals(serviceTypeParam.getValue().toString())) {
            return;
        }
        if (this.getSynapseConfiguration() == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"SynapseConfiguration in ProxyObserver is null. The service update event will not be processed further.");
            }
            return;
        }
        if (-1 == event.getEventType()) {
            this.updateProxyServicePolicies(axisService, this.getSynapseConfiguration());
        }
        if (100 == event.getEventType() && (proxy = this.getSynapseConfiguration().getProxyService(axisService.getName())) != null && proxy.getTransports() != null) {
            List transports = axisService.getExposedTransports();
            for (String trp : transports) {
                if (proxy.getTransports().contains(trp)) continue;
                proxy.getTransports().add(trp);
            }
        }
        if (0 == event.getEventType()) {
            boolean keepHistory;
            Parameter keepServiceHistoryParam = axisService.getParameter("keepServiceHistory");
            Parameter originator = axisService.getParameter("originator");
            boolean bl = keepHistory = keepServiceHistoryParam != null && JavaUtils.isTrue((Object)keepServiceHistoryParam.getValue());
            if (originator != null && "ServiceAdmin".equals(originator.getValue().toString()) && !keepHistory) {
                ProxyService proxySvc = this.getSynapseConfiguration().getProxyService(axisService.getName());
                if (proxySvc != null) {
                    this.getSynapseConfiguration().removeProxyService(axisService.getName());
                    if (!Boolean.parseBoolean(System.getProperty("NonRegistryMode"))) {
                        MediationPersistenceManager pm = this.getMediationPersistenceManager();
                        pm.deleteItem(proxySvc.getName(), proxySvc.getFileName(), 0);
                    }
                    log.info((Object)("Deleted the proxy service : " + proxySvc.getName()));
                } else if (log.isDebugEnabled()) {
                    log.debug((Object)("Proxy Service representing the service " + axisService.getName() + " of type proxy is not found in the SynapseConfiguration"));
                }
            }
        }
    }

    public void moduleUpdate(AxisEvent event, AxisModule axisModule) {
        if (event != null && (event.getAxisDescription() instanceof AxisService || event.getAxisDescription() instanceof AxisOperation)) {
            AxisService axisService = event.getAxisDescription() instanceof AxisService ? (AxisService)event.getAxisDescription() : ((AxisOperation)event.getAxisDescription()).getAxisService();
            Parameter serviceTypeParam = axisService.getParameter("serviceType");
            if (serviceTypeParam == null || !"proxy".equals(serviceTypeParam.getValue().toString())) {
                return;
            }
            if (this.getSynapseConfiguration() == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"SynapseConfiguration in ProxyObserver is null. The module update event will not be processed further.");
                }
                return;
            }
            if (-1 == event.getEventType()) {
                this.updateProxyServicePolicies(axisService, this.getSynapseConfiguration());
            }
            if (6 == event.getEventType() && !this.isDefaultModule(axisModule)) {
                this.onEngageModule(axisService, axisModule, this.getSynapseConfiguration());
                this.updateProxyServicePolicies(axisService, this.getSynapseConfiguration());
            }
            if (7 == event.getEventType() && !this.isDefaultModule(axisModule)) {
                this.onDisEngageModule(axisService, axisModule, this.getSynapseConfiguration());
                this.updateProxyServicePolicies(axisService, this.getSynapseConfiguration());
            }
        }
    }

    private boolean isDefaultModule(AxisModule module) {
        String name = module.getName();
        for (String defaultModule : DEFAULT_MODULES) {
            if (!defaultModule.equals(name)) continue;
            return true;
        }
        return false;
    }

    public void serviceGroupUpdate(AxisEvent event, AxisServiceGroup axisServiceGroup) {
    }

    public void addParameter(Parameter parameter) throws AxisFault {
    }

    public void removeParameter(Parameter parameter) throws AxisFault {
    }

    public void deserializeParameters(OMElement omElement) throws AxisFault {
    }

    public Parameter getParameter(String s) {
        return null;
    }

    public ArrayList<Parameter> getParameters() {
        return null;
    }

    public boolean isParameterLocked(String s) {
        return false;
    }

    private void onEngageModule(AxisService service, AxisModule module, SynapseConfiguration config) {
        if (config.getProxyService(service.getName()) != null) {
            ProxyService proxy = config.getProxyService(service.getName());
            if (module.getModule() instanceof Rampart) {
                proxy.setWsSecEnabled(true);
            }
        }
    }

    private void onDisEngageModule(AxisService service, AxisModule module, SynapseConfiguration config) {
        if (config.getProxyService(service.getName()) != null) {
            ProxyService proxy = config.getProxyService(service.getName());
            if (module.getModule() instanceof Rampart) {
                proxy.setWsSecEnabled(false);
                proxy.getParameterMap().remove("secPolicyRegistryPath");
                proxy.getParameterMap().remove("disableREST");
            }
        }
    }

    private void updateProxyServicePolicies(AxisService axisService, SynapseConfiguration config) {
        if (config.getProxyService(axisService.getName()) == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Couldn't retrieve the proxy service with name " + axisService.getName() + " to update policies"));
            }
            return;
        }
        ProxyService proxyService = config.getProxyService(axisService.getName());
        try {
            Resource servicePoliciesResource;
            Registry registry = this.configSystemRegistry;
            String servicePath = "/repository/axis2/service-groups/" + axisService.getAxisServiceGroup().getServiceGroupName() + "/" + "services" + "/" + axisService.getName();
            String servicePoliciesPath = servicePath + "/" + "policies";
            ArrayList<PolicyInfo> remainingPolicies = new ArrayList<PolicyInfo>();
            for (PolicyInfo info : proxyService.getPolicies()) {
                if (info.getPolicyKey().startsWith("conf:" + servicePoliciesPath)) continue;
                remainingPolicies.add(info);
            }
            proxyService.setPolicies(remainingPolicies);
            if (registry.resourceExists(servicePoliciesPath) && (servicePoliciesResource = registry.get(servicePoliciesPath)) instanceof Collection) {
                Collection servicePoliciesCollection = (Collection)servicePoliciesResource;
                for (String servicePolicyResourcePath : servicePoliciesCollection.getChildren()) {
                    PolicyInfo pi = this.handlePolicy(config, proxyService, servicePolicyResourcePath, (UserRegistry)registry);
                    if (pi == null) continue;
                    pi.setPolicyKey("conf:" + pi.getPolicyKey());
                    proxyService.addPolicyInfo(pi);
                }
            }
            if (axisService.getExposedTransports() != null && !axisService.getExposedTransports().isEmpty()) {
                proxyService.setTransports(new ArrayList(axisService.getExposedTransports()));
            } else {
                proxyService.setTransports(new ArrayList());
            }
            this.persistChanges(axisService.getName(), axisService.getAxisConfiguration());
        }
        catch (RegistryException e) {
            log.error((Object)"Error checking the policies from the registry", (Throwable)e);
        }
    }

    private PolicyInfo handlePolicy(SynapseConfiguration config, ProxyService proxy, String policyPath, UserRegistry registry) throws RegistryException {
        if (!registry.resourceExists(policyPath)) {
            return null;
        }
        Resource policyResource = registry.get(policyPath);
        byte[] content = (byte[])policyResource.getContent();
        if (content == null || content.length == 0) {
            return null;
        }
        policyResource.discard();
        ByteArrayInputStream in = new ByteArrayInputStream(content);
        Policy policy = this.getPolicy(in);
        if (policy != null && !policy.isEmpty()) {
            for (PolicyInfo pi : proxy.getPolicies()) {
                if (!pi.isServicePolicy()) continue;
                config.getEntryDefinition(pi.getPolicyKey());
                Policy proxyPolicy = PolicyEngine.getPolicy((InputStream)SynapseConfigUtils.getStreamSource((Object)config.getEntry(pi.getPolicyKey())).getInputStream());
                if (!proxyPolicy.equal(policy.normalize(false))) continue;
                return null;
            }
            return new PolicyInfo(policyPath);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Policy getPolicy(InputStream is) {
        BufferedInputStream inputStream = new BufferedInputStream(is);
        try {
            XMLStreamReader parser = XMLInputFactory.newInstance().createXMLStreamReader(inputStream);
            StAXOMBuilder builder = new StAXOMBuilder(parser);
            OMElement elem = builder.getDocumentElement();
            Policy policy = PolicyUtil.getPolicyFromOMElement((OMElement)elem);
            return policy;
        }
        catch (XMLStreamException e) {
            Policy policy = null;
            return policy;
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    private void persistChanges(String proxyName, AxisConfiguration axisConfiguration) {
        MediationPersistenceManager mpm;
        Parameter param = axisConfiguration.getParameter("suspend.mediation.persistence");
        if (param != null && Boolean.parseBoolean((String)param.getValue())) {
            return;
        }
        if (!Boolean.parseBoolean(System.getProperty("NonRegistryMode")) && (mpm = this.getMediationPersistenceManager()) != null) {
            mpm.saveItem(proxyName, 0);
        }
    }

    private MediationPersistenceManager getMediationPersistenceManager() {
        Parameter p = this.getSynapseConfiguration().getAxisConfiguration().getParameter("PERSISTENCE_MANAGER");
        if (p != null) {
            return (MediationPersistenceManager)p.getValue();
        }
        return null;
    }

    public void setSynapseEnvironmentService(SynapseEnvironmentService synapseEnvironmentService) {
        this.synapseEnvironmentService = synapseEnvironmentService;
    }

    private SynapseConfiguration getSynapseConfiguration() {
        return this.synapseEnvironmentService.getSynapseEnvironment().getSynapseConfiguration();
    }
}

