/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.stream.core.internal.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.Random;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.databridge.commons.Attribute;
import org.wso2.carbon.databridge.commons.AttributeType;
import org.wso2.carbon.databridge.commons.StreamDefinition;
import org.wso2.carbon.event.stream.core.exception.EventStreamConfigurationException;

public class SampleEventGenerator {
    private static final Log log = LogFactory.getLog(SampleEventGenerator.class);
    private static double[] doubleValues = new double[]{1.23434, 4.504343, 5.443435, 20.44345, 90.34344};
    private static int[] intValues = new int[]{4, 50, 100, 45, 70};
    private static boolean[] booleanValues = new boolean[]{true, false};
    private static float[] floatValues = new float[]{6.6f, 4.5f, 8.9f, 2.3f, 9.8f};
    private static long[] longValues = new long[]{56783L, 545455L, 645565L, 323232L, 4354643L};
    private static String[] stringValues = new String[]{"data1", "data2", "data3", "data4", "data5"};

    private SampleEventGenerator() {
    }

    public static String generateXMLEvent(StreamDefinition streamDefinition) throws EventStreamConfigurationException {
        List payloadAttributes;
        List correlationAttributes;
        OMFactory factory = OMAbstractFactory.getOMFactory();
        OMElement sampleEventsElement = factory.createOMElement(new QName("events"));
        OMElement sampleEventElement = factory.createOMElement(new QName("event"));
        sampleEventsElement.addChild((OMNode)sampleEventElement);
        List metaDatAttributes = streamDefinition.getMetaData();
        if (metaDatAttributes != null && metaDatAttributes.size() > 0) {
            sampleEventElement.addChild((OMNode)SampleEventGenerator.createPropertyElement(factory, metaDatAttributes, "metaData"));
        }
        if ((correlationAttributes = streamDefinition.getCorrelationData()) != null && correlationAttributes.size() > 0) {
            sampleEventElement.addChild((OMNode)SampleEventGenerator.createPropertyElement(factory, correlationAttributes, "correlationData"));
        }
        if ((payloadAttributes = streamDefinition.getPayloadData()) != null && payloadAttributes.size() > 0) {
            sampleEventElement.addChild((OMNode)SampleEventGenerator.createPropertyElement(factory, payloadAttributes, "payloadData"));
        }
        return sampleEventsElement.toString();
    }

    public static String generateJSONEvent(StreamDefinition streamDefinition) throws EventStreamConfigurationException {
        List payloadAttributes;
        List correlationAttributes;
        JsonObject jsonEventObject = new JsonObject();
        JsonObject innerParentObject = new JsonObject();
        List metaDatAttributes = streamDefinition.getMetaData();
        if (metaDatAttributes != null && metaDatAttributes.size() > 0) {
            innerParentObject.add("metaData", (JsonElement)SampleEventGenerator.createPropertyElement(metaDatAttributes));
        }
        if ((correlationAttributes = streamDefinition.getCorrelationData()) != null && correlationAttributes.size() > 0) {
            innerParentObject.add("correlationData", (JsonElement)SampleEventGenerator.createPropertyElement(correlationAttributes));
        }
        if ((payloadAttributes = streamDefinition.getPayloadData()) != null && payloadAttributes.size() > 0) {
            innerParentObject.add("payloadData", (JsonElement)SampleEventGenerator.createPropertyElement(payloadAttributes));
        }
        jsonEventObject.add("event", (JsonElement)innerParentObject);
        return jsonEventObject.toString();
    }

    public static String generateTextEvent(StreamDefinition streamDefinition) throws EventStreamConfigurationException {
        List payloadAttributes;
        List correlationAttributes;
        String sampleEvent = "";
        List metaDatAttributes = streamDefinition.getMetaData();
        if (metaDatAttributes != null && metaDatAttributes.size() > 0) {
            for (Attribute attribute : metaDatAttributes) {
                sampleEvent = sampleEvent + "\nmeta_" + attribute.getName() + ":" + SampleEventGenerator.getSampleValue(attribute.getType()) + ",";
            }
        }
        if ((correlationAttributes = streamDefinition.getCorrelationData()) != null && correlationAttributes.size() > 0) {
            for (Attribute attribute : correlationAttributes) {
                sampleEvent = sampleEvent + "\ncorrelation_" + attribute.getName() + ":" + SampleEventGenerator.getSampleValue(attribute.getType()) + ",";
            }
        }
        if ((payloadAttributes = streamDefinition.getPayloadData()) != null && payloadAttributes.size() > 0) {
            for (Attribute attribute : payloadAttributes) {
                sampleEvent = sampleEvent + "\n" + attribute.getName() + ":" + SampleEventGenerator.getSampleValue(attribute.getType()) + ",";
            }
        }
        if (sampleEvent.trim().endsWith(",")) {
            return sampleEvent.substring(0, sampleEvent.length() - 1).trim();
        }
        return sampleEvent;
    }

    private static OMElement createPropertyElement(OMFactory factory, List<Attribute> attributeList, String propertyTag) {
        OMElement metaDataPropertyElement = factory.createOMElement(new QName(propertyTag));
        for (Attribute attribute : attributeList) {
            OMElement propertyElement = factory.createOMElement(new QName(attribute.getName()));
            propertyElement.setText(SampleEventGenerator.getSampleValue(attribute.getType()));
            metaDataPropertyElement.addChild((OMNode)propertyElement);
        }
        return metaDataPropertyElement;
    }

    private static JsonObject createPropertyElement(List<Attribute> attributeList) {
        JsonObject innerObject = new JsonObject();
        for (Attribute attribute : attributeList) {
            if (attribute.getType().name().toLowerCase().equals("string")) {
                innerObject.addProperty(attribute.getName(), SampleEventGenerator.getSampleValue(attribute.getType()));
                continue;
            }
            if (attribute.getType().name().toLowerCase().equals("bool")) {
                innerObject.addProperty(attribute.getName(), Boolean.valueOf(Boolean.parseBoolean(SampleEventGenerator.getSampleValue(attribute.getType()))));
                continue;
            }
            innerObject.addProperty(attribute.getName(), (Number)Double.parseDouble(SampleEventGenerator.getSampleValue(attribute.getType())));
        }
        return innerObject;
    }

    private static String getSampleValue(AttributeType attributeType) {
        Random rand = new Random();
        if (attributeType.name().toLowerCase().equals("float")) {
            int hostIndex = rand.nextInt(5);
            return floatValues[hostIndex] + "";
        }
        if (attributeType.name().toLowerCase().equals("double")) {
            int hostIndex = rand.nextInt(5);
            return doubleValues[hostIndex] + "";
        }
        if (attributeType.name().toLowerCase().equals("int")) {
            int hostIndex = rand.nextInt(5);
            return intValues[hostIndex] + "";
        }
        if (attributeType.name().toLowerCase().equals("long")) {
            int hostIndex = rand.nextInt(5);
            return longValues[hostIndex] + "";
        }
        if (attributeType.name().toLowerCase().equals("bool")) {
            int hostIndex = rand.nextInt(2);
            return booleanValues[hostIndex] + "";
        }
        if (attributeType.name().toLowerCase().equals("string")) {
            int hostIndex = rand.nextInt(5);
            return stringValues[hostIndex] + "";
        }
        return "";
    }
}

