/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.stream.core.internal.util;

import java.util.Map;
import org.wso2.carbon.databridge.commons.Event;
import org.wso2.carbon.databridge.commons.StreamDefinition;

public class EventConverter {
    public static Event convertToWSO2Event(org.wso2.siddhi.core.event.Event event, StreamDefinition streamDefinition) {
        int i;
        Object[] metaAttributes = null;
        Object[] correlationAttributes = null;
        Object[] payloadAttributes = null;
        long timeStamp = event.getTimestamp();
        Object[] objArray = event.getData();
        int attributeIndex = 0;
        if (streamDefinition.getMetaData() != null) {
            int metaSize = streamDefinition.getMetaData().size();
            metaAttributes = new Object[metaSize];
            for (i = 0; i < metaSize; ++i) {
                metaAttributes[i] = objArray[attributeIndex++];
            }
        }
        if (streamDefinition.getCorrelationData() != null) {
            int correlationSize = streamDefinition.getCorrelationData().size();
            correlationAttributes = new Object[correlationSize];
            for (i = 0; i < correlationSize; ++i) {
                correlationAttributes[i] = objArray[attributeIndex++];
            }
        }
        if (streamDefinition.getPayloadData() != null) {
            int payloadSize = streamDefinition.getPayloadData().size();
            payloadAttributes = new Object[payloadSize];
            for (i = 0; i < payloadSize; ++i) {
                payloadAttributes[i] = objArray[attributeIndex++];
            }
        }
        return new Event(streamDefinition.getStreamId(), timeStamp, metaAttributes, correlationAttributes, payloadAttributes);
    }

    public static org.wso2.siddhi.core.event.Event convertToEvent(Event event, boolean metaFlag, boolean correlationFlag, boolean payloadFlag, int size) {
        Object[] eventObject;
        Map arbitraryDataMap = event.getArbitraryDataMap();
        if (arbitraryDataMap != null && !arbitraryDataMap.isEmpty()) {
            eventObject = new Object[size + 1];
            eventObject[size] = event.getArbitraryDataMap();
        } else {
            eventObject = new Object[size];
        }
        int count = 0;
        Object[] metaData = event.getMetaData();
        Object[] correlationData = event.getCorrelationData();
        Object[] payloadData = event.getPayloadData();
        if (metaFlag) {
            System.arraycopy(metaData, 0, eventObject, 0, metaData.length);
            count += metaData.length;
        }
        if (correlationFlag) {
            System.arraycopy(correlationData, 0, eventObject, count, correlationData.length);
            count += correlationData.length;
        }
        if (payloadFlag) {
            System.arraycopy(payloadData, 0, eventObject, count, payloadData.length);
            count += payloadData.length;
        }
        return new org.wso2.siddhi.core.event.Event(event.getTimeStamp(), eventObject);
    }
}

